/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.aquarium.model;

import fr.lifl.aquarium.model.LifeRoom;
import fr.lifl.aquarium.model.a.b;
import fr.lifl.aquarium.model.g;
import fr.lifl.aquarium.model.utils.Utils;
import fr.lifl.aquarium.model.utils.h;
import fr.lifl.aquarium.model.utils.i;
import fr.lifl.aquarium.model.utils.j;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.xml.sax.SAXException;

public class CharMatrix
implements Cloneable,
LifeRoom {
    protected char[] K;
    protected Dimension J;
    protected String L;

    public CharMatrix(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public CharMatrix() {
        this(1, 1);
    }

    public CharMatrix(int n2) {
        this(n2, n2);
    }

    public CharMatrix(int n2, int n3) {
        try {
            this.K = new char[n2 * n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            i.a().a(this, j.a().a("notEnoughtMemory"), 0);
            this.delete();
            return;
        }
        this.J = new Dimension(n2, n3);
    }

    public void setEmpty(int n2, int n3) {
        this.set(n2, n3, ' ');
    }

    public boolean isEmpty(int n2, int n3) {
        return this.get(n2, n3) == ' ';
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        char c2 = 'w';
        int n2 = 0;
        while (n2 < this.J.width + 2) {
            stringBuffer.append(c2);
            ++n2;
        }
        stringBuffer.append(string);
        int n3 = 0;
        while (n3 < this.J.height) {
            stringBuffer.append(c2);
            n2 = 0;
            while (n2 < this.J.width) {
                stringBuffer.append(this.get(n2, n3));
                ++n2;
            }
            stringBuffer.append(c2);
            stringBuffer.append(string);
            ++n3;
        }
        n2 = 0;
        while (n2 < this.J.width + 2) {
            stringBuffer.append(c2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean isFood(int n2, int n3) {
        return !this.isEmpty(n2, n3) && !this.isWorm(n2, n3) && !this.isWall(n2, n3);
    }

    public boolean isWalkable(int n2, int n3) {
        return this.isEmpty(n2, n3) || this.isFood(n2, n3);
    }

    public void setWall(int n2, int n3) {
        this.set(n2, n3, '1');
    }

    public Object clone() {
        CharMatrix charMatrix = new CharMatrix(this.J);
        System.arraycopy(this.K, 0, charMatrix.K, 0, this.K.length);
        charMatrix.L = this.L;
        return charMatrix;
    }

    public void createWall(int n2, int n3, int n4, int n5) {
        if (n2 > n4 || n3 > n5) {
            return;
        }
        if (n3 == n5) {
            int n6 = n2;
            while (n6 < n4) {
                this.setWall(n6, n3);
                ++n6;
            }
        } else if (n2 == n4) {
            int n7 = n3;
            while (n7 < n5) {
                this.setWall(n2, n7);
                ++n7;
            }
        } else {
            throw new IllegalArgumentException(j.a().a("doNotKnow"));
        }
    }

    public final char get(int n2, int n3) {
        if (this.checks(n2, n3)) {
            char[] cArray = this.K;
            synchronized (cArray) {
                char c2 = this.K[n3 * this.J.width + n2];
                if (c2 == '\u0000') {
                    Thread.currentThread();
                    Thread.dumpStack();
                    System.exit(0);
                }
                char c3 = c2;
                return c3;
            }
        }
        return '1';
    }

    public void setWorm(int n2, int n3) {
        this.set(n2, n3, '2');
    }

    public void setWorm(int n2, int n3, Color color) {
        this.set(n2, n3, '2');
    }

    public final void set(int n2, int n3, char c2) {
        if (this.checks(n2, n3)) {
            char[] cArray = this.K;
            synchronized (cArray) {
                this.K[n3 * this.J.width + n2] = c2;
            }
        }
    }

    public final void set(int n2, int n3, char c2, Color color) {
        this.set(n2, n3, c2);
        if (c2 == '\u0000') {
            Thread.currentThread();
            Thread.dumpStack();
            System.exit(0);
        }
    }

    public boolean isWorm(int n2, int n3) {
        return this.get(n2, n3) == '2';
    }

    public boolean isWall(int n2, int n3) {
        return this.get(n2, n3) == '1';
    }

    public final int getLine() {
        return this.J.width;
    }

    public final Dimension getDimension() {
        return this.J;
    }

    public void setDimension(int n2, int n3) {
        char[] cArray = new char[n2 * n3];
        int n4 = 0;
        while (n4 < cArray.length) {
            cArray[n4] = 32;
            ++n4;
        }
        int n5 = Math.min(n2, this.J.width);
        int n6 = Math.min(n3, this.J.height);
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0;
            while (n8 < n6) {
                cArray[n8 * n2 + n7] = this.get(n7, n8);
                ++n8;
            }
            ++n7;
        }
        this.K = null;
        this.K = cArray;
        this.J.width = n2;
        this.J.height = n3;
    }

    public final void init() {
        int n2 = 0;
        while (n2 < this.K.length) {
            if (this.K[n2] != '2') {
                this.K[n2] = 32;
            }
            ++n2;
        }
    }

    public final int getColumn() {
        return this.J.height;
    }

    public final boolean checks(int n2, int n3) {
        return n2 >= 0 && n3 >= 0 && n2 < this.J.width && n3 < this.J.height;
    }

    public void putFoods(int n2, g g2) {
        long l2 = this.J.height * this.J.width + 1;
        int n3 = 0;
        while (n3 < n2 && l2 > 0L) {
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            while (!bl) {
                --l2;
                n4 = h.for().a(this.J.width);
                n5 = h.for().a(this.J.height);
                bl = this.isWalkable(n4, n5);
            }
            this.set(n4, n5, g2.M());
            ++n3;
        }
    }

    public void delete() {
        this.K = null;
        this.J = null;
    }

    public static final CharMatrix load(String string) throws IOException, SAXException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        FileInputStream fileInputStream = new FileInputStream(string);
        CharMatrix charMatrix = new CharMatrix(1);
        charMatrix.read(fileInputStream);
        charMatrix.L = string;
        fileInputStream.close();
        return charMatrix;
    }

    public final void saveAs(String string) throws IOException {
        this.L = string;
        this.save();
    }

    public final void save() throws IOException {
        if (this.L == null) {
            throw new NullPointerException();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.L);
        fileOutputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
        fileOutputStream.write(System.getProperty("line.separator").getBytes());
        this.write(fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public String getFileName() {
        return this.L;
    }

    public void setFileName(String string) {
        this.L = string;
    }

    public void asXML(StringBuffer stringBuffer) {
        String string = System.getProperty("line.separator");
        stringBuffer.append("<LIFEROOM type=\"");
        Utils.a(this.getClass(), stringBuffer);
        stringBuffer.append("\" width=\"");
        stringBuffer.append(this.J.width);
        stringBuffer.append("\" height=\"");
        stringBuffer.append(this.J.height);
        stringBuffer.append("\">");
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < this.K.length) {
            char c2 = this.K[n2];
            if (c2 != ' ') {
                stringBuffer.append("<ROOM linear=\"");
                stringBuffer.append(n2);
                stringBuffer.append("\" value=\"");
                stringBuffer.append(c2);
                stringBuffer.append("\"/>");
                stringBuffer.append(string);
            }
            ++n2;
        }
        stringBuffer.append("</LIFEROOM>");
        stringBuffer.append(string);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(64);
        this.asXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "8859_1");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write(this.toXML());
        bufferedWriter.flush();
    }

    public void read(InputStream inputStream) throws IOException, SAXException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        CharMatrix charMatrix = (CharMatrix)b.a(inputStream);
        if (charMatrix == null) {
            throw new IOException(j.a().a("fileForCannotBeRead", fr.lifl.aquarium.model.utils.b.if().a("border.lifeRoom")));
        }
        this.K = null;
        this.K = charMatrix.K;
        this.J = null;
        this.J = charMatrix.J;
        charMatrix = null;
    }

    public void setLinear(int n2, char c2) {
        this.K[n2] = c2;
    }
}

