/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.aquarium.client;

import fr.lifl.aquarium.client.a;
import fr.lifl.aquarium.client.e;
import fr.lifl.aquarium.model.CharMatrix;
import fr.lifl.aquarium.model.LifeRoom;
import fr.lifl.aquarium.model.d;
import fr.lifl.aquarium.model.f;
import fr.lifl.aquarium.model.g;
import fr.lifl.aquarium.model.utils.Utils;
import fr.lifl.aquarium.model.utils.h;
import fr.lifl.aquarium.model.utils.i;
import fr.lifl.aquarium.model.utils.j;
import fr.lifl.aquarium.model.utils.k;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import org.xml.sax.SAXException;

public class JMatrix
extends JComponent
implements Cloneable,
LifeRoom,
PropertyChangeListener {
    protected CharMatrix Q;
    protected Color O = k.for().case("color.empty");
    protected Color M = k.for().case("color.wall");
    protected int N;
    protected Image P;

    public JMatrix(Dimension dimension) {
        this.setDoubleBuffered(false);
        this.Q = new CharMatrix(dimension);
        this.N = k.for().new("pixelSize");
        Dimension dimension2 = (Dimension)dimension.clone();
        dimension2.width *= this.N;
        dimension2.height *= this.N;
        Utils.a(this, dimension2);
        k.for().a(this);
    }

    protected JMatrix() {
        this(new Dimension(1, 1));
    }

    public JMatrix(int n2) {
        this(new Dimension(n2, n2));
    }

    public JMatrix(int n2, int n3) {
        this(new Dimension(n2, n3));
    }

    public void setEmpty(int n2, int n3) {
        this.set(n2, n3, ' ', this.O);
    }

    public boolean isEmpty(int n2, int n3) {
        return this.Q.isEmpty(n2, n3);
    }

    public String toString() {
        return this.Q.toString();
    }

    public boolean isFood(int n2, int n3) {
        return this.Q.isFood(n2, n3);
    }

    public boolean isWalkable(int n2, int n3) {
        return this.Q.isWalkable(n2, n3);
    }

    public void setWall(int n2, int n3) {
        this.set(n2, n3, '1', this.M);
    }

    public Object clone(f f2, d d2) {
        JMatrix jMatrix = new JMatrix(this.Q.getDimension());
        jMatrix.Q.delete();
        jMatrix.Q = null;
        jMatrix.Q = (CharMatrix)this.Q.clone();
        jMatrix.init(jMatrix.Q, f2, d2);
        return jMatrix;
    }

    public Object clone() {
        return this.clone(null, null);
    }

    public void createWall(int n2, int n3, int n4, int n5) {
        if (n2 > n4 || n3 > n5) {
            return;
        }
        if (n3 == n5) {
            int n6 = n2;
            while (n6 < n4) {
                this.setWall(n6, n3);
                ++n6;
            }
        } else if (n2 == n4) {
            int n7 = n3;
            while (n7 < n5) {
                this.setWall(n2, n7);
                ++n7;
            }
        } else {
            throw new IllegalArgumentException("Do not know how to create this!");
        }
    }

    public final char get(int n2, int n3) {
        return this.Q.get(n2, n3);
    }

    public void setWorm(int n2, int n3) {
        this.set(n2, n3, '2');
    }

    public void setWorm(int n2, int n3, Color color) {
        this.set(n2, n3, '2');
        this.a(n2, n3, color);
    }

    public final void set(int n2, int n3, char c2) {
        switch (c2) {
            case ' ': {
                this.set(n2, n3, c2, this.O);
                return;
            }
            case '1': {
                this.set(n2, n3, c2, this.M);
                return;
            }
        }
        this.Q.set(n2, n3, c2);
    }

    public final void set(int n2, int n3, char c2, Color color) {
        this.Q.set(n2, n3, c2);
        this.a(n2, n3, color);
    }

    public boolean isWorm(int n2, int n3) {
        return this.Q.isWorm(n2, n3);
    }

    public boolean isWall(int n2, int n3) {
        return this.Q.isWall(n2, n3);
    }

    public final int getLine() {
        return this.Q.getLine();
    }

    public final Dimension getDimension() {
        return this.Q.getDimension();
    }

    public void setDimension(int n2, int n3) {
        throw new IllegalArgumentException("Can not be used with JMatrix");
    }

    public final synchronized void init() {
        int n2 = this.Q.getLine() * this.N;
        int n3 = this.Q.getColumn() * this.N;
        this.P = new BufferedImage(n2, n3, 1);
        this.Q.init();
        if (this.P != null) {
            Graphics graphics = this.P.getGraphics();
            if (graphics == null) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.O);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(color);
            this.repaint();
        }
    }

    public final synchronized void init(LifeRoom lifeRoom, f f2, d d2) {
        int n2 = this.getLine() * this.N;
        int n3 = this.getColumn() * this.N;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(n2, n3, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            i.a().a(this, j.a().a("notEnoughtMemory"), 0);
            bufferedImage = null;
            return;
        }
        if (this.P != null) {
            this.P.flush();
            this.P = null;
        }
        this.P = bufferedImage;
        Utils.a(this, new Dimension(n2, n3));
        if (this.P != null) {
            Graphics graphics = this.P.getGraphics();
            if (graphics == null) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.O);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(color);
            int n4 = 0;
            while (n4 < this.getLine()) {
                int n5 = 0;
                while (n5 < this.getColumn()) {
                    Serializable serializable;
                    char c2 = lifeRoom.get(n4, n5);
                    if (c2 == ' ') {
                        this.Q.set(n4, n5, ' ');
                    } else if (c2 == '1') {
                        this.Q.set(n4, n5, '1');
                        this.a(n4, n5, this.M, false);
                    } else if (c2 == '2' && d2 != null) {
                        serializable = d2.if(n4, n5);
                        if (serializable != null) {
                            this.Q.set(n4, n5, c2);
                            this.a(n4, n5, ((fr.lifl.aquarium.model.a)serializable).c().o(), false);
                            serializable = null;
                        }
                    } else if (f2 != null) {
                        serializable = f2.new(c2);
                        if (serializable == null) {
                            serializable = this.O;
                        }
                        this.Q.set(n4, n5, c2);
                        this.a(n4, n5, (Color)serializable, false);
                    }
                    ++n5;
                }
                ++n4;
            }
            this.repaint();
        }
    }

    public final int getColumn() {
        return this.Q.getColumn();
    }

    public void putFoods(int n2, g g2) {
        long l2 = this.getColumn() * this.getLine() + 1;
        while (n2 > 0 && l2 > 0L) {
            boolean bl = false;
            int n3 = 0;
            int n4 = 0;
            while (!bl) {
                --l2;
                n3 = h.for().a(this.getLine());
                n4 = h.for().a(this.getColumn());
                bl = this.Q.isWalkable(n3, n4);
            }
            this.set(n3, n4, g2.M(), g2.N());
            --n2;
        }
    }

    public void delete() {
        k.for().if(this);
        this.Q.delete();
        this.Q = null;
    }

    public final void fill(int n2, int n3, char c2, Color color, int n4) {
        if (n4 == 1) {
            if (!this.isWorm(n2, n3)) {
                this.set(n2, n3, c2, color);
            }
        } else {
            int n5 = n2 - n4 / 2;
            int n6 = n2 + n4 / 2;
            int n7 = n3 - n4 / 2;
            int n8 = n3 + n4 / 2;
            int n9 = n5;
            while (n9 < n6) {
                int n10 = n7;
                while (n10 < n8) {
                    if (!this.isWorm(n9, n10)) {
                        this.Q.set(n9, n10, c2);
                        this.a(n9, n10, color, false);
                    }
                    ++n10;
                }
                ++n9;
            }
            this.repaint();
        }
    }

    protected final synchronized void a(int n2, int n3, Color color) {
        this.a(n2, n3, color, true);
    }

    protected final synchronized void a(int n2, int n3, Color color, boolean bl) {
        if (this.Q.checks(n2, n3) && this.P != null) {
            Graphics graphics = this.P.getGraphics();
            if (graphics == null) {
                return;
            }
            int n4 = n2 * this.N;
            int n5 = n3 * this.N;
            Color color2 = graphics.getColor();
            if (color != null) {
                graphics.setColor(color);
            }
            graphics.fillRect(n4, n5, this.N, this.N);
            if (color != null) {
                graphics.setColor(color2);
            }
            if (bl) {
                super.repaint(n4, n5, this.N, this.N);
            }
        }
    }

    public void setFileName(String string) {
        this.Q.setFileName(string);
    }

    public String getFileName() {
        return this.Q.getFileName();
    }

    public void setLinear(int n2, char c2) {
        this.Q.setLinear(n2, c2);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.Q.write(outputStream);
    }

    public void read(InputStream inputStream) throws IOException, SAXException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.Q.read(inputStream);
    }

    public String toXML() {
        return this.Q.toXML();
    }

    public void asXML(StringBuffer stringBuffer) {
        this.Q.asXML(stringBuffer);
    }

    protected void paintComponent(Graphics graphics) {
        if (graphics != null && this.P != null) {
            graphics.drawImage(this.P, 0, 0, this);
        }
    }

    public final void saveAs(String string) throws IOException {
        this.Q.saveAs(string);
    }

    public final void save() throws IOException {
        this.Q.save();
    }

    public void refresh() {
        this.init(this, e.a().if().getFoodMap(), e.a().if().getWormList());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().startsWith("color") || propertyChangeEvent.getPropertyName().equals("pixelSize")) {
            this.O = k.for().case("color.empty");
            this.M = k.for().case("color.wall");
            this.N = k.for().new("pixelSize");
            this.refresh();
            a.int().for();
        }
    }

    public strictfp Point pixelToReal(int n2, int n3) {
        return new Point(n2 / this.N, n3 / this.N);
    }
}

