package fr.lifl.Aquarium.Simulation;
import java.util.Hashtable;
import java.util.Enumeration;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
  * Cette <i>classe</i> represente un ensemble de <tt>Compteur</tt>. <p>
  *
  * Elle est utilisee dans <tt>Ver</tt> et <tt>Aquarium</tt>. <p>
  *
  * Derniere modification 22 Janvier 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Simulation.Compteur
  * @see fr.lifl.Aquarium.Simulation.Ver
  * @see fr.lifl.Aquarium.Simulation.Aquarium
  *
  * @version 1.1
  */
public class TableCompteur implements Serializable,Cloneable
{
  
  /**
    * Constructeur d'une <tt>TableCompteur</tt>. <p>
    */
  public TableCompteur() 
  {
    tableCompteur = new Hashtable();
  }
  
  /**
    * Constructeur d'une <tt>TableCompteur</tt>. <p>
    *
    * @param noms chaque caractere de cette chaine representera un
    * <tt>Compteur</tt>
    */
  public TableCompteur(String noms) 
  {
    this();
    int i;
    if(noms != null)
    {
      if(!(noms.trim().equals("")))
      {
        for(i = 0;i < noms.length();i++)
          putCompteur(new Compteur(), noms.charAt(i) + "");
      }
      else
        tableCompteur = new Hashtable();
    }
    else
      tableCompteur = new Hashtable();
  }
  
  /**
    * Methode qui regarde si tous les <tt>Compteur</tt> sont
    * a zero. <p>
    *
    * Le <tt>Compteur</tt> de nom <i>"I"</i> n'est
    * pas inclu dans ce teste. <p>
    *
    * @return
    * <ul>
    *   <li>true si tous les <tt>Compteur</tt> sont a zero 
    *       <b>SAUF</b> <i>"I"</i>
    *   <li>false sinon
    * </ul>
    */
  public boolean tousAZeroSaufI()
  {
    if(!(tableCompteur.containsKey("I")))
      return false;
    boolean resu = true;
    Enumeration e = tableCompteur.keys();
    String nom = null;
    Compteur c = null;
    while(e.hasMoreElements() && resu)
    {
      nom = (String)(e.nextElement());
      if(nom.equals("I"))
        continue;
      c = (Compteur)tableCompteur.get(nom);
      if(c != null)
        resu = resu && (c.getValeur() == 0);
      else
        System.err.println(Erreur.getString("erreur_tablecompteur_tousazerosaufi"));
    }
    return resu;
  }
  
  /**
    * Methode qui ajoute un <tt>Compteur</tt> dans la 
    * <tt>TableCompteur</tt>. <p>
    *
    * @param nom le nom identifiant le nouveau <tt>Compteur</tt>
    * @param c le nouveau <tt>Compteur</tt>
    *
    * @return
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  public boolean putCompteur(Compteur c, String nom)
  {
    if((nom == null) || (c == null))
      return false;
    if(nom.trim().equals(""))
      return false;
    if(!tableCompteur.containsKey(nom))
    {
      tableCompteur.put(nom, c);
      return true;
    }
    return false;
  }
  
  /**
    * Methode qui sauve une <tt>TableCompteur</tt>. <P>
    *
    * @param nomFichier le nom du fichier ou sauver la table.
    *
    * @return
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  public boolean sauver(String nomFichier)
  {
    int i = 0;
    if(nomFichier == null)
      return false;
    if(nomFichier.trim().equals(""))
      return false;
    try
    {
      FileOutputStream fichierOuvert = new FileOutputStream(nomFichier);
      ObjectOutputStream out = new ObjectOutputStream(fichierOuvert);
      out.writeObject(this);
      out.flush();
      out.close();
      fichierOuvert.close();
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_tablecompteur_sauver"));
      return false;
    }
    return true;
  }
  
  /**
    * Methode qui transforme une <tt>TableCompteur</tt>
    * en chaine de caracteres. <p>
    *
    * @return une <tt>String</tt> representant la <tt>TableCompteur</tt>.
    */
  public String toString()
  {
    return tableCompteur.toString();
  }
  
  /**
    * Methode qui initialise a zero tous les 
    * <tt>Compteur</tt> de la table. <p>
    */
  public void initAll()
  {
    Enumeration e = tableCompteur.keys();
    String nom = null;
    Compteur c = null;
    while(e.hasMoreElements())
    {
      nom = (String)(e.nextElement());
      c = (Compteur)tableCompteur.get(nom);
      if(c != null)
        c.init();
    }
  }
  
  /**
    * Methode qui initialise un <tt>Compteur</tt>. <p>
    *
    * @param nom le nom identifiant le <tt>Compteur</tt> a
    * initialiser.
    */
  public void initCompteur(String nom)
  {
    Compteur c = (Compteur)tableCompteur.get(nom);
    if(c != null)
      c.init();
    else
      System.err.println(Erreur.getString("erreur_tablecompteur_initcompteur"));
  }
  
  /**
    * Methode qui retourne une copie de l'objet. <p>
    *
    * @return une copie de l'objet.
    */
  public Object clone()
  {
    TableCompteur resu = new TableCompteur();
    resu.tableCompteur = (Hashtable)this.tableCompteur.clone();
    return resu;
  }
  
  /**
    * Methode qui retourne le nom du <tt>Compteur</tt> possedant
    * la plus grande valeur. <p>
    *
    * <b>ATTENTION !</b> :
    * <ul>
    *   <li>Si il y des <tt>Compteur</tt> qui ont la meme
    *       valeur, c'est le nom du dernier trouve qui est affiche.
    *   <li>I n'est pas pris en compte.
    *   <li>Le cas particulier ou toutes les valeurs sont a zero
    *       est traite dans <tt>tousAZeroSaufI()</tt>
    * </ul>
    *
    * @return le nom du <tt>Compteur</tt> qui a la plus grande
    * valeur.
    */
  public String getMax()
  {
    String resu = null;
    int max = Integer.MIN_VALUE;
    Enumeration e = tableCompteur.keys();
    while(e.hasMoreElements())
    {
      String nom = (String)(e.nextElement());
      
      // Le I ne m'interesse pas
      if(nom.equals("I"))
        continue;
      Compteur c = (Compteur)tableCompteur.get(nom);
      if(c != null)
      {
        if(max < c.getValeur())
        {
          max = c.getValeur();
          resu = nom;
        }
      }
      else
        System.err.println(Erreur.getString("erreur_tablecompteur_getmax"));
    }
    return resu;
  }
  
  /**
    * Methode qui incremente un <tt>Compteur</tt>. <p>
    *
    * @param nom le nom identifiant le <tt>Compteur</tt> a
    * incrementer.
    */
  public void incCompteur(String nom)
  {
    Compteur c = (Compteur)tableCompteur.get(nom);
    if(c != null)
      c.inc();
    else
      System.err.println(Erreur.getString("erreur_tablecompteur_inccompteur"));
  }
  
  /**
    * Charge une <tt>TableCompteur</tt>. <P>
    *
    * @param nomFichier le nom du fichier d'ou charger la table
    *
    * @return
    * <ul>
    *   <li>la <tt>TableCompteur</tt> contenu dans le fichier
    *   <li>null sinon
    * </ul>
    */
  public static TableCompteur charger(String nomFichier)
  {
    try
    {
      FileInputStream fichierOuvert = new FileInputStream(nomFichier);
      ObjectInputStream in = new ObjectInputStream(fichierOuvert);
      TableCompteur tc = (TableCompteur)in.readObject();
      in.close();
      fichierOuvert.close();
      return tc;
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_tablecompteur_charger"));
      return null;
    }
  }
  
  /** Les <tt>Compteur</tt> sont ranges dans une <tt>Hashtable</tt>. <p> */
  protected Hashtable tableCompteur = null;
}
