package fr.lifl.Aquarium.Ihm;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Dimension;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente un type de fenetre amelioree. <p>
  *
  * Les ameliorations sont les suivantes :
  * <ul>
  *   <li>Fenetre centrable par rapport a l'ecran
  *   <li>La fenetre a un fond gris clair
  *   <li>Possibilite de lui donner une icone
  * </ul>
  *
  * Derniere modification 09 Decembre 1999 <br>
  *
  * @author
  *	<ul>
  *		<li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a>
  *	</ul>
  *
  * @version 1.0
  */
public class SuperFenetre extends JFrame
{
  
  /**
    * Methode qui donne une icone a la fenetre. <P>
    *
    * Si l'icone n'est pas la, rien ne se passe. <P>
    *
    * Les icones sont theoriquement en 32x32 en 16 couleurs, sous
    * certains systemes, ils peuvent apparaitre en 16x16, ou en
    * noir et blanc. <P>
    *
    * @param monIcone le chemin pour trouver l'icone.
    *
    * @return
    *   <ul>
    *     <li>true si tout c'est bien passe
    *     <li>false si l'image n'a pas pu etre chargee
    *   </ul>
    */
  public boolean setIcone(String monIcone)
  {
    String nom = null;
    int i = 0;
    if((monIcone == null) || (monIcone.trim().equals("")))
      return false;
    File monFichier = new File(monIcone);
    if(monFichier.exists())
    {
      if(monFichier.canRead())
      {
        try
        {
          nom = monFichier.getCanonicalPath();
        }
        catch(IOException io)
        {
          return false;
        }
        Image im = this.getToolkit().getImage(nom);
        
        // Permet un meilleur rendu de l'icone pour Windows 98 uniquement.
        im = im.getScaledInstance(16, 16, im.SCALE_AREA_AVERAGING);
        this.prepareImage(im, im.getWidth(this), im.getHeight(this), this);
        
        // pour SunSolaris et Hp l'icone doit etre en 64x64
        
        // im = im.getScaledInstance(64,64,im.SCALE_AREA_AVERAGING);
        
        // f.prepareImage(im,64,64,f);
        this.setIconImage(im);
        return true;
      }
      else
        return false;
    }
    else
      return false;
  }
  
  /**
    * Methode qui centre une fenetre par rapport a l'ecran. <P>
    *
    * <STRONG>BUG</STRONG> :
    * <UL>
    *   <LI>Sous Kde (pour freeBSD) le centrage se fait
    *   en fonction du bon vouloir du systeme.
    * </UL>
    *
    * @param w la fenetre (Frame ou Dialog) a centrer.
    */
  public void centrer()
  {
    
    // Centrage de la fenetre
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = this.getSize();
    if(frameSize.height > screenSize.height)
      frameSize.height = screenSize.height;
    if(frameSize.width > screenSize.width)
      frameSize.width = screenSize.width;
    this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
  }
  
  /**
    * Constructeur d'une <tt>SuperFenetre</tt>. <p>
    *
    * @param titre le titre de la fenetre.
    * @param fM la fenetre mere.
    * @param l locale
    */
  public SuperFenetre(String titre, Frame fM) 
  {
    super(titre);
    this.setBackground(couleur);
    this.addWindowListener(new WindowAdapter() 
    {
      public void windowClosing(WindowEvent e)
      {
        fermerFenetre();
      }
    });
    contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout());
    fenetreMere = fM;
  }
  
  /**
    * Constructeur d'une <tt>SuperFenetre</tt>. <p>
    *
    * Par defaut la fenetre ne possede pas de fenetre mere et 
    * le language est en <i>francais</i>. <p>
    *
    * @param titre le titre de la fenetre.
    */
  public SuperFenetre(String titre) 
  {
    this(titre, null);
  }
  
  /**
    * Constructeur d'une <tt>SuperFenetre</tt>. <p>
    *
    * Par defaut le language est <i>francais</i>. <p>
    *
    * @param fM la fenetre mere.
    */
  public SuperFenetre(Frame fM) 
  {
    this("", fM);
  }
  
  /**
    * Constructeur d'une <tt>SuperFenetre</tt>. <p>
    *
    * Par defaut la fenetre ne possede pas de fenetre mere, 
    * le language est en <i>francais</i>. <p>
    */
  public SuperFenetre() 
  {
    this("");
  }
  
  /**
    * Fermeture de la fenetre. <P>
    *
    * Si la fenetre n'a pas de fenetre mere, alors on quitte le 
    * programme. <p>
    */
  protected void fermerFenetre()
  {
    setVisible(false);
    
    // On rend la main a la fentre mere
    if(fenetreMere != null)
    {
      fenetreMere.setEnabled(true);
      fenetreMere.toFront();
    }
    dispose();
    if(fenetreMere == null)
      System.exit(0);
  }
  
  /** Definit une taille de 1024x768. <P> */
  public final static Dimension BIG = new Dimension(1024, 768);
  
  /** Definit une taille de 800x600. <P> */
  public final static Dimension NORMAL = new Dimension(800, 600);
  
  /** Definit une taille de 640x480. <P> */
  public final static Dimension SMALL = new Dimension(640, 480);
  
  /** La fenetre parente, ou mere. <p> */
  protected Frame fenetreMere = null;
  
  /** Le container de ma fenetre. <P> */
  protected Container contentPane = null;
  
  /** Couleur par defaut de la fenetre. <p> */
  private final Color couleur = Color.lightGray;
}
