package fr.lifl.Aquarium.Ihm;
import javax.swing.JDialog;
import java.awt.Container;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.Frame;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener; // Pour les boutons
import java.awt.event.ActionEvent;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <I>classe</I> represente une fenetre de dialogue. <P>
  *
  * Celle-ci peut apparaitre pour diverses raisons et est toujours 
  * <i>modale</i>. <P>
  *
  * <b>ATTENTION !</b> Sous certains systemes, HP, SunSolaris vieux modeles,
  * les fenetres de type <i>modale</i> plantent le programme. <p>
  *
  * Derniere modification 18 Decembre 1999 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @version 1.0
  */
public class SuperDialog extends JDialog
{
  
  /**
    * Methode qui centre une fenetre par rapport a l'ecran. <P>
    *
    * <STRONG>BUG</STRONG> :
    * <UL>
    *   <LI>Sous Kde (pour freeBSD) le centrage se fait
    *   en fonction du bon vouloir du system.
    * </UL>
    *
    * @param w la fenetre (Frame ou Dialog) a centrer.
    */
  public void centrer()
  {
    
    // Centrage de la fenetre
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = this.getSize();
    if(frameSize.height > screenSize.height)
      frameSize.height = screenSize.height;
    if(frameSize.width > screenSize.width)
      frameSize.width = screenSize.width;
    this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
  }
  
  /**
    * Le constructeur d'une fenetre de dialogue. <P>
    *
    * Une fenetre de Dialog sera modale par rapport a sa fenetre
    * mere. <p>
    *
    * La fenetre est <i>modale</i> par defaut. <p>
    *
    * @param fd la fenetre qui a cree et ouvert cette fenetre (sa fenetre Mere).
    */
  public SuperDialog(Dialog fd) 
  {
    this(fd, true);
  }
  
  /**
    * Le constructeur d'une fenetre de dialogue. <P>
    *
    * Une fenetre de Dialog sera modale par rapport a sa fenetre
    * mere. <p>
    *
    * @param fd la fenetre qui a cree et ouvert cette fenetre (sa fenetre Mere).
    * @param b indique si la fenetre sera modale ou non
    */
  public SuperDialog(Dialog fd, boolean b) 
  {
    super(fd, b);
    fenetreMere = fd;
    contentPane = getContentPane();
    setBackground(Color.lightGray);
    this.addWindowListener(new WindowAdapter() 
    {
      public void windowClosing(WindowEvent e)
      {
        fermerFenetre();
      }
    });
  }
  
  /**
    * Le constructeur d'une fenetre de dialogue. <P>
    *
    * Une fenetre de Dialog sera modale par rapport a sa fenetre
    * mere. <p>
    *
    * La fenetre est <i>modale</i> par defaut. <p>
    *
    * @param fM la fenetre qui a cree et ouvert cette fenetre (sa fenetre Mere).
    */
  public SuperDialog(Frame fM) 
  {
    this(fM, true);
  }
  
  /**
    * Le constructeur d'une fenetre de dialogue. <P>
    *
    * Une fenetre de Dialog sera modale par rapport a sa fenetre
    * mere. <p>
    *
    * @param fM la fenetre qui a cree et ouvert cette fenetre (sa fenetre Mere).
    * @param b indique si la fenetre sera modale ou non
    */
  public SuperDialog(Frame fM, boolean b) 
  {
    super(fM, b);
    fenetreMere = fM;
    contentPane = getContentPane();
    setBackground(Color.lightGray);
    this.addWindowListener(new WindowAdapter() 
    {
      public void windowClosing(WindowEvent e)
      {
        fermerFenetre();
      }
    });
  }
  
  /**
    * Fermeture de la fenetre. <P>
    *
    * Si la fenetre n'a pas de fenetre mere, alors on quitte le 
    * programme. <p>
    */
  protected void fermerFenetre()
  {
    setVisible(false);
    
    // On rend la main a la fentre mere
    if(fenetreMere != null)
      fenetreMere.toFront();
    dispose();
    if(fenetreMere == null)
      System.exit(0);
  }
  
  /** La fenetre parente. <p> */
  protected Window fenetreMere = null;
  
  /** Le container de ma fenetre. <P> */
  protected Container contentPane = null;
}
