package fr.lifl.Aquarium.Simulation;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.awt.Dimension;
import java.awt.Point;

/**
  * Cette <i>classe</i> definit l'objet piste utilise afin que les vers
  * puissent se deplacer. <P>
  *
  * Pour <i>optimiser</i> la <tt>Piste</tt>, celle-ci est representee non
  * pas par une matrice carre, mais par une matrice a une dimension. <p>
  *
  * Derniere modification 22 Janvier 2000. <p>
  *
  * @author
  * <ul>
  *   <li>Hiblot Sebastien (V1.0)
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V2.++)
  * </ul>
  *
  * @version 2.5
  */
public class Piste implements Serializable,Cloneable
{
  
  /**
    * Surcharge de toString(). <p>
    *
    * Transforme un objet Piste en une chaine de caracteres. <p>
    *
    * <b>ATTENTION !</b> : Cette methode est <b>TRES TRES</b> 
    * lente. <p>
    *
    * @return une chaine de caracteres representant une piste.
    */
  public String toString()
  {
    int i, j;
    StringBuffer resu = new StringBuffer();
    resu.append("[ X=");
    resu.append(taillePiste.width);
    resu.append(", Y=");
    resu.append(taillePiste.height);
    resu.append(",\n");
    for(i = 0;i < taillePiste.height;i++)
    {
      for(j = 0;j < taillePiste.width;j++)
        resu.append(getCase(j, i));
      resu.append("\n");
    }
    resu.append("]");
    return resu.toString();
  }
  
  /**
    * Methode qui place le VIDE dans la case. <P>
    *
    * @param p <tt>Point</tt> a remplir
    */
  public void setCaseVide(Point p)
  {
    if(p != null)
      setCaseVide(p.x, p.y);
  }
  
  /**
    * Methode qui place le VIDE dans la case (x,y). <P>
    *
    * @param x Coordonnee en x du caractere VIDE
    * @param y Coordonnee en y du caractere VIDE
    */
  public void setCaseVide(int x, int y)
  {
    setCase(x, y, VIDE);
  }
  
  /**
    * Methode qui renvoie true si la case (x,y) est VIDE. <p>
    *
    * @param x Coordonnee en x du charactere
    * @param y Coordonnee en y du charactere
    *
    * @return
    * <ul>
    *   <li>true si la case contient VIDE
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstVide(int x, int y)
  {
    return (getCase(x, y) == VIDE);
  }
  
  /**
    * Methode qui place le MUR dans la case. <P>
    *
    * @param p <tt>Point</tt> a remplir
    */
  public void setCaseMur(Point p)
  {
    if(p != null)
      setCaseMur(p.x, p.y);
  }
  
  /**
    * Methode qui renvoie le caractere contenu dans la case. <p>
    *
    * @param p le <tt>Point</tt> dont on veut connaitre la valeur
    *
    * @return le caractere contenu dans la case (x,y) de la piste
    */
  public char getCase(Point p)
  {
    if(p == null)
      return MUR;
    return getCase(p.x, p.y);
  }
  
  /**
    * Methode qui renvoie true si la case est traversable. <p>
    *
    * Une case traversable est soit de la <b>Nourriture</b>
    * soit <b>VIDE</b>. <p>
    *
    * @param x Coordonnee en x du point
    * @param x Coordonnee en y du point
    *
    * @return
    * <ul>
    *   <li>true si la case est traversable
    *   <li>false si la case contient quelque chose de non traversable
    * </ul>
    */
  public boolean caseEstTraversable(int x, int y)
  {
    return ((!(caseEstMur(x, y))) && (!(caseEstVer(x, y))));
  }
  
  /**
    * Methode qui place le MUR dans la case (x,y). <P>
    *
    * @param x Coordonnee en x du caractere MUR
    * @param y Coordonnee en y du caractere MUR
    */
  public void setCaseMur(int x, int y)
  {
    setCase(x, y, MUR);
  }
  
  /**
    * Methode qui place le VER dans la case. <P>
    *
    * @param p <tt>Point</tt> a remplir
    */
  public void setCaseVer(Point p)
  {
    if(p != null)
      setCaseVer(p.x, p.y);
  }
  
  /**
    * Methode fabrique un mur allant de (x1,y1) a (x2,y2). <p>
    *
    * <b>ATTENTION</b> : ne trace pas <i>encore</i> les droites en biais. <p>
    *
    * @param x1 Coordonnee en x du point de depart en haut a gauche du mur.
    * @param y1 Coordonnee en y du point de depart en haut a gauche du mur.
    * @param x2 Coordonnee en x du point de depart en bas a droite du mur.
    * @param y2 Coordonnee en y du point de depart en bas a droite du mur.
    */
  public void creerMur(int x1, int y1, int x2, int y2)
  {
    if((x1 > x2) || (y1 > y2))
      return ;
    int x, y;
    
    // cas de la droite
    
    // Sur x
    if(y1 == y2)
    {
      for(x = x1;x < x2;x++)
        setCaseMur(x, y1);
      return ;
    }
    
    // Sur y
    if(x1 == x2)
    {
      for(y = y1;y < y2;y++)
        setCaseMur(x1, y);
      return ;
    }
  }
  
  /**
    * Methode qui place le VER dans la case (x,y). <P>
    *
    * @param x Coordonnee en x du caractere VER
    * @param y Coordonnee en y du caractere VER
    */
  public void setCaseVer(int x, int y)
  {
    setCase(x, y, VER);
  }
  
  /**
    * Methode qui place le caractere c dans la case (x,y). <P>
    *
    * @param x Coordonnee en x du caractere
    * @param y Coordonnee en y du caractere
    * @param c le caractere c a placer dans la case (x,y)
    */
  public void setCase(int x, int y, char c)
  {
    if(verifier(x, y))
      piste[y * taillePiste.width + x] = c;
  }
  
  /**
    * Constructeur d'un objet piste. <p>
    *
    * Par defaut la piste est un carre de 
    * TAILLE_PAR_DEFAUT*TAILLE_PAR_DEFAUT. <p>
    */
  public Piste() 
  {
    this(TAILLE_PAR_DEFAUT);
  }
  
  /**
    * Methode qui renvoie true si la case est traversable. <p>
    *
    * Une case traversable est soit de la <b>Nourriture</b>
    * soit <b>VIDE</b>. <p>
    *
    * @return
    * <ul>
    *   <li>true si la case est traversable
    *   <li>false si la case contient quelque chose de non traversable
    * </ul>
    */
  public boolean caseEstTraversable(Point p)
  {
    return caseEstTraversable(p.x, p.y);
  }
  
  /**
    * Constructeur d'un objet piste. <p>
    *
    * La piste est un carre de 150*150
    *
    * @param taille la taille de la piste 
    */
  public Piste(int taille) 
  {
    this(taille, taille);
  }
  
  /**
    * Methode qui renvoie true si la case est VER. <p>
    *
    * @param <tt>Point</tt> qui serait un Ver
    *
    * @return
    * <ul>
    *   <li>true si la case contient VER
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstVer(Point p)
  {
    if(p == null)
      return false;
    return caseEstVer(p.x, p.y);
  }
  
  /**
    * Constructeur d'un objet piste. <p>
    *
    * @param x la taille de la piste en longueur
    * @param y la taille de la piste en largeur
    */
  public Piste(int x, int y) 
  {
    piste = new char[x * y];
    taillePiste.height = y;
    taillePiste.width = x;
    init();
  }
  
  /**
    * Methode qui renvoie true si la case est VIDE. <p>
    *
    * @param p <tt>Point</tt> qui serait VIDE
    *
    * @return
    * <ul>
    *   <li>true si la case contient VIDE
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstVide(Point p)
  {
    if(p == null)
      return false;
    return caseEstVide(p.x, p.y);
  }
  
  /**
    * Constructeur d'un objet piste. <p>
    *
    * @param d la taille de la piste
    */
  public Piste(Dimension d) 
  {
    this(d.width, d.height);
  }
  
  /**
    * Methode qui retourne une copie de l'objet. <p>
    *
    * @return une copie de l'objet.
    */
  public Object clone()
  {
    Piste resu = new Piste(this.taillePiste);
    int i, j;
    for(i = 0;i < taillePiste.width;i++)
      for(j = 0;j < taillePiste.height;j++)
        resu.setCase(i, j, this.getCase(i, j));
    return resu;
  }
  
  /**
    * Methode qui renvoie true si la case (x,y) est MUR. <p>
    *
    * <b>ATTENTION !</b>
    * <ul>
    *   Toutes les cases hors de la <tt>Piste</tt> sont
    *   conciderees comme des MUR.
    * </ul>
    *
    * @param x Coordonnee en x du charactere
    * @param y Coordonnee en y du charactere
    *
    * @return
    * <ul>
    *   <li>true si la case contient MUR
    *   <li>false si la case contient autre chose ou sort des limites
    * </ul>
    */
  public boolean caseEstMur(int x, int y)
  {
    return (getCase(x, y) == MUR);
  }
  
  /**
    * Methode qui renvoie le caractere contenu dans la case (x,y). <p>
    *
    * @param x Coordonnee en x du caractere
    * @param y Coordonnee en y du caractere
    *
    * @return le caractere contenu dans la case (x,y) de la piste
    */
  public char getCase(int x, int y)
  {
    if(verifier(x, y))
      return (piste[y * taillePiste.width + x]);
    else
      return MUR;
  }
  
  /**
    * Methode qui renvoie true si la case est MUR. <p>
    *
    * @param p <tt>Point</tt> qui serait MUR
    *
    * @return
    * <ul>
    *   <li>true si la case contient MUR
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstMur(Point p)
  {
    if(p == null)
      return true;
    return caseEstMur(p.x, p.y);
  }
  
  /**
    * Methode qui place le caractere c dans la case. <P>
    *
    * @param p <tt>Point</tt> a remplir
    * @param c le caractere c a placer dans la case (x,y)
    */
  public void setCase(Point p, char c)
  {
    if(p != null)
      setCase(p.x, p.y, c);
  }
  
  /**
    * Methode qui renvoie true si la case (x,y) est de la nourriture. <p>
    *
    * @param x Coordonnee en x du charactere
    * @param y Coordonnee en y du charactere
    *
    * @return
    * <ul>
    *   <li>true si la case contient de la nourriture
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstNourriture(int x, int y)
  {
    try
    {
      if((!caseEstMur(x, y)) && (!caseEstVide(x, y)) && (!caseEstVer(x, y)))
        return true;
    }
    catch(ArrayIndexOutOfBoundsException ao)
    {
      ;
    }
    return false;
  }
  
  /**
    * Methode qui sauve le contenu d'une piste. <P>
    *
    * @param nomFichier le nom du fichier ou sauver la piste
    *
    * @return
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  public boolean sauver(String nomFichier)
  {
    int i = 0;
    if(nomFichier == null)
      return false;
    if(nomFichier.trim().equals(""))
      return false;
    try
    {
      FileOutputStream fichierOuvert = new FileOutputStream(nomFichier);
      ObjectOutputStream out = new ObjectOutputStream(fichierOuvert);
      out.writeObject(this);
      out.flush();
      out.close();
      fichierOuvert.close();
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_piste_sauver"));
      return false;
    }
    return true;
  }
  
  /**
    * Methode qui renvoie true si la case est de la nourriture. <p>
    *
    * @param p <tt>Point</tt> qui serait de la Nourriture
    *
    * @return
    * <ul>
    *   <li>true si la case contient de la nourriture
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstNourriture(Point p)
  {
    if(p == null)
      return false;
    return caseEstNourriture(p.x, p.y);
  }
  
  /**
    * Methode qui renvoie true si la case (x,y) est VER. <p>
    *
    * @param x Coordonnee en x du charactere
    * @param y Coordonnee en y du charactere
    *
    * @return
    * <ul>
    *   <li>true si la case contient VER
    *   <li>false si la case contient autre chose
    * </ul>
    */
  public boolean caseEstVer(int x, int y)
  {
    return (getCase(x, y) == VER);
  }
  
  /**
    * Methode qui retourne la taille de la piste en Y. <P>
    *
    * @return la taille de la piste en Y
    */
  public final int getTailleY()
  {
    return taillePiste.height;
  }
  
  /**
    * Methode qui retourne la taille de la piste en X. <P>
    *
    * @return la taille de la piste en X
    */
  public final int getTailleX()
  {
    return taillePiste.width;
  }
  
  /**
    * Methode qui retourne la dimension de la piste. <P>
    *
    * Celle-ci n'est pas forcement carree. <p>
    *
    * @return la dimension de la piste
    */
  public final Dimension getTaille()
  {
    return new Dimension(taillePiste);
  }
  
  /**
    * Methode qui initialise la piste. <p>
    *
    * La piste est remplie par le caractere VIDE.
    */
  public final void init()
  {
    int i, j;
    for(i = 0;i < taillePiste.width;i++)
      for(j = 0;j < taillePiste.height;j++)
        setCaseVide(i, j);
  }
  
  /**
    * Charge une piste. <P>
    *
    * @param nomFichier le nom du fichier d'ou charger la piste
    *
    * @return
    * <ul>
    *   <li>l'objet Piste contenu dans le fichier
    *   <li>null si nomFichier=null ou ="" ou ="Default"
    * </ul>
    */
  public static Piste charger(String nomFichier)
  {
    int i, j;
    if(nomFichier == null)
      return null;
    if(nomFichier.trim().equals(""))
      return null;
    if(nomFichier.equals("Default"))
      return null;
    try
    {
      FileInputStream fichierOuvert = new FileInputStream(nomFichier);
      ObjectInputStream in = new ObjectInputStream(fichierOuvert);
      Piste p = (Piste)in.readObject();
      in.close();
      fichierOuvert.close();
      return p;
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_piste_charger"));
    }
    return null;
  }
  
  /**
    * Verifie si x et y sont dans les bornes du tableau. <p>
    * 
    * @param x la coordonnee en X du point
    * @param y la coordonnee en Y du point
    *
    * @return
    * <ul>
    *		<li>true si (x,y) e du tableau.
    *		<li>false sinon
    *	</ul>
    */
  protected final boolean verifier(int x, int y)
  {
    if((x < 0) || (y < 0))
      return false;
    if((x >= taillePiste.width) || (y >= taillePiste.height))
      return false;
    return true;
  }
  
  /** Valeur d'un Ver dans la piste. <p> */
  public final static char VER = '1';
  
  // ATTENTION !!!
  
  // Il est important d'utiliser les chiffres comme caractere 
  
  // et pas 'V' pour vide, car cette lettre est
  
  // un identifiant de type de Nourriture.
  
  /** Valeur d'une case vide dans la piste. <p> */
  public final static char VIDE = ' ';
  
  /** Valeur d'un Mur dans la piste. <p> */
  public final static char MUR = 'M';
  
  /** La taille de la grille par defaut (150). <p> */
  public final static int TAILLE_PAR_DEFAUT = 150;
  
  /** La taille de la Piste. <p>*/
  private Dimension taillePiste = new Dimension(0, 0);
  
  /** Le piste. <p> */
  private char piste[] = null;
}
