package fr.lifl.Aquarium.Ihm;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente le panneau qui represente graphiquement
  * les parametres. <p>
  *
  * Il est contenu dans la <tt>FenetreParametres</tt>. <p>
  *
  * Derniere modification 05 Mars 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Ihm.FenetreParametres
  *
  * @version 1.2
  */
public class PanneauParametres extends BoiteEntouree
{
  
  /**
    * Methode qui teste la veracite des parametres. <p>
    *
    * @return
    * <ul>
    *   <li>true si tout va bien
    *   <li>false sinon
    * </ul>
    */
  public boolean accepterParametres(Parametres p)
  {
    try
    {
      p.setCas(tfCas.getText());
      p.setCoutDeplacement(Float.parseFloat(tfCoutDeplacement.getText()));
      p.setNbVerTue(Integer.parseInt(tfNbVerTue.getText()));
      p.setPeriodeEvolution(Integer.parseInt(tfPeriodeEvolution.getText()));
      p.setNbVer(Integer.parseInt(tfNbVer.getText()));
      p.setTailleVer(Integer.parseInt(tfTailleVer.getText()));
      p.setTaillePiste(new Dimension(Integer.parseInt(tfTaillePisteX.getText()), Integer.parseInt(tfTaillePisteY.getText())));
      p.setPeriodeSevrage(Integer.parseInt(tfPeriodeSevrage.getText()));
      p.setVitesse(Integer.parseInt(tfVitesse.getText()));
    }
    catch(NumberFormatException ne)
    {
      return false;
    }
    return true;
  }
  
  /**
    * Constructeur d'un <tt>PanneauParametres</tt>. <p>
    *
    * @param fM la fenetre a laquelle il appartient.
    */
  public PanneauParametres(FenetreParametre fM) 
  {
    super(Langage.getString("parametres"));
    fenetreMere = fM;
    setLayout(new BorderLayout());
    tfVitesse = new TextField();
    tfCas = new TextField();
    tfCoutDeplacement = new TextField();
    tfCas.setEditable(false);
    tfNbVerTue = new TextField();
    tfPeriodeEvolution = new TextField();
    tfNbVer = new TextField();
    tfTailleVer = new TextField();
    tfTaillePisteX = new TextField();
    tfTaillePisteY = new TextField();
    tfPeriodeSevrage = new TextField();
    bTbNourriture = new Button(Langage.getString("nourriture"));
    bAlgo = new Button(Langage.getString("algo"));
    bTypeHalo = new Button(Langage.getString("bouton_halo"));
    pCentre = new Panel();
    pCentre.setLayout(new GridLayout(12, 2, 5, 5));
    pCentre.add(new Label(Langage.getString("cas_etudie"), Label.RIGHT));
    pCentre.add(tfCas);
    pCentre.add(new Label(Langage.getString("nb_vers_tues"), Label.RIGHT));
    pCentre.add(tfNbVerTue);
    pCentre.add(new Label(Langage.getString("cout_deplacement"), Label.RIGHT));
    pCentre.add(tfCoutDeplacement);
    pCentre.add(new Label(Langage.getString("periode_evolution"), Label.RIGHT));
    pCentre.add(tfPeriodeEvolution);
    pCentre.add(new Label(Langage.getString("nb_vers"), Label.RIGHT));
    pCentre.add(tfNbVer);
    pCentre.add(new Label(Langage.getString("taille_ver"), Label.RIGHT));
    pCentre.add(tfTailleVer);
    pCentre.add(new Label(Langage.getString("periode_sevrage"), Label.RIGHT));
    pCentre.add(tfPeriodeSevrage);
    pCentre.add(new Label(Langage.getString("vitesse"), Label.RIGHT));
    pCentre.add(tfVitesse);
    pCentre.add(new Label(Langage.getString("taille_piste"), Label.RIGHT));
    Panel panel = new Panel();
    panel.setLayout(new GridLayout(1, 2));
    panel.add(tfTaillePisteX);
    panel.add(tfTaillePisteY);
    pCentre.add(panel);
    pCentre.add(new Label(Langage.getString("algo"), Label.RIGHT));
    pCentre.add(bAlgo);
    pCentre.add(new Label(Langage.getString("tb_nourriture"), Label.RIGHT));
    pCentre.add(bTbNourriture);
    pCentre.add(new Label(Langage.getString("type_halo"), Label.RIGHT));
    pCentre.add(bTypeHalo);
    bTypeHalo.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionChoisirHalo();
      }
    });
    bAlgo.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionChoisirAlgo();
      }
    });
    bTbNourriture.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionTableNourriture();
      }
    });
    setParametre(fM.getParametres());
    this.add(pCentre, BorderLayout.CENTER);
  }
  
  /**
    * Modifie le cas etudie. <p>
    *
    * @param cas le nouveau cas
    */
  public void setCas(String cas)
  {
    if(cas != null)
      tfCas.setText(cas);
  }
  
  /**
    * Methode qui met dans le panneau les valeurs d'un
    * <tt>Parametres</tt>. <p>
    *
    * @param p le <tt>Parametres</tt> a afficher.
    */
  public void setParametre(Parametres p)
  {
    if(p != null)
    {
      tfCas.setText(p.getCas());
      tfCoutDeplacement.setText(String.valueOf(p.getCoutDeplacement()));
      tfNbVerTue.setText(String.valueOf(p.getNbVerTue()));
      tfPeriodeEvolution.setText(String.valueOf(p.getPeriodeEvolution()));
      tfNbVer.setText(String.valueOf(p.getNbVer()));
      tfTailleVer.setText(String.valueOf(p.getTailleVer()));
      tfTaillePisteX.setText(String.valueOf(p.getTaillePiste().width));
      tfTaillePisteY.setText(String.valueOf(p.getTaillePiste().height));
      tfPeriodeSevrage.setText(String.valueOf(p.getPeriodeSevrage()));
      tfVitesse.setText(String.valueOf(p.getVitesse()));
    }
  }
  
  /**
    * Methode qui remplit ouvre une fenetre pour configurer l'algorithme. <p>
    *
    * @see fr.lifl.Aquarium.Ihm.FenetreConfigurerAlgoGenetic
    */
  protected void actionChoisirAlgo()
  {
    FenetreConfigurerAlgoGenetic fg = new FenetreConfigurerAlgoGenetic(fenetreMere);
  }
  
  /**
    * Methode qui ouvre une fenetre pour configurer les types de halo. <p>
    *
    * @see fr.lifl.Aquarium.Ihm.FenetreConfigurerHalo
    */
  protected void actionChoisirHalo()
  {
    FenetreConfigurerHalo fh = new FenetreConfigurerHalo(fenetreMere);
  }
  
  /**
    * Methode qui remplit ouvre une fenetre pour configurer une
    * <tt>TableNourriture</tt>. <p>
    *
    * @see fr.lifl.Aquarium.Ihm.FenetreConfigurerTableNourriture
    */
  protected void actionTableNourriture()
  {
    FenetreConfigurerTableNourriture fc = new FenetreConfigurerTableNourriture(fenetreMere);
  }
  private TextField tfTaillePisteY = null;
  private TextField tfPeriodeSevrage = null;
  private TextField tfNbVerTue = null;
  private TextField tfVitesse = null;
  private TextField tfNbVer = null;
  private Panel pCentre = null;
  private FenetreParametre fenetreMere = null;
  private TextField tfCoutDeplacement = null;
  private TextField tfTailleVer = null;
  private TextField tfTaillePisteX = null;
  private TextField tfPeriodeEvolution = null;
  private TextField tfCas = null;
  private Button bTypeHalo = null;
  private Button bAlgo = null;
  private Button bTbNourriture = null;
}
