package fr.lifl.Aquarium.Ihm;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JScrollPane;
import javax.swing.JScrollBar;
import java.awt.TextArea;
import java.awt.Color;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.BufferedWriter;

/**
  * Cette <i>classe</i> represente le <tt>Panneau</tt> d'information. <p>
  * 
  * Elle ne fait qu'encapsuler un <tt>JTextField</tt>, et pas un <tt>TextField</tt> car il 
  * semble y avoir une taille maximale pour ce dernier. <p>
  *
  * Derniere modification 15 Mars 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @version 1.0
  */
public class Panneau extends JTextArea
{
  
  /**
    * Le constructeur d'un panneau. <P>
    *
    * @param s le contenu initial du panneau.
    * @param X taille en X
    * @param Y taille en Y
    */
  public Panneau(String s, int X, int Y) 
  {
    super(Y, X);
    setDoubleBuffered(true);
    setBackground(Color.white);
    if(s != null)
      this.setText(s);
  }
  
  /**
    * Permet de charger le contenu d'un fichier dans un panneau, au format <b>ASCII</b>. <p>
    * 
    * @param nomFichier le nom du fichier.
    *
    * @return
    * <ul>
    *		<li>true si tout est ok
    *		<li>false si il y a eu un probleme
    *	</ul>
    */
  public boolean charger(String nomFichier)
  {
    int i = 0;
    StringBuffer chaine = new StringBuffer();
    if(nomFichier == null)
      return false;
    File fichierOuvert = new File(nomFichier);
    if(!fichierOuvert.exists())
      return false;
    if(!fichierOuvert.canRead())
      return false;
    try
    {
      String pas = null;
      BufferedReader fluxLu = new BufferedReader(new FileReader(fichierOuvert));
      while((pas = fluxLu.readLine()) != null)
      {
        chaine.append(pas);
        chaine.append("\n");
      }
      fluxLu.close();
    }
    catch(IOException e)
    {
      return false;
    }
    setText(String.valueOf(chaine));
    return true;
  }
  
  /**
    * Methode qui efface la totalite du panneau. <P>
    */
  public void effacer()
  {
    setText("");
  }
  
  /**
    * Methode qui compte le nombre de lignes contenues dans le
    * panneau. <P>
    *
    * @return le nombre de lignes du panneau.
    */
  public int nbLigne()
  {
    int i = 0;
    int resu = 0;
    String s = getText();
    for(i = 0;i < s.length();i++)
      if(s.charAt(i) == '\n')
        resu++;
    return (resu);
  }
  
  /**
    * Permet de sauver le contenu du panneau, au format <b>ASCII</b>. <p>
    * 
    * @param nomFichier le nom du fichier qui recevra le contenu du panneau.
    *
    * @return
    * <ul>
    *		<li>true si tout est ok
    *		<li>false si il y a eut un probleme
    *	</ul>
    */
  public boolean sauver(String nomFichier)
  {
    int i = 0;
    if(nomFichier == null)
      return false;
    File fichierOuvert = new File(nomFichier);
    if(fichierOuvert.exists())
    {
      if(!fichierOuvert.canWrite())
        return false;
    }
    try
    {
      BufferedWriter fluxEcrit = new BufferedWriter(new FileWriter(fichierOuvert));
      String chaine = getText();
      fluxEcrit.write(chaine, 0, chaine.length());
      fluxEcrit.close();
    }
    catch(IOException e)
    {
      return false;
    }
    return true;
  }
  
  /**
    * Le constructeur d'un panneau central. <P>
    *
    * Par defaut, il ne contiendra aucun texte. <P>
    */
  public Panneau() 
  {
    
    //super();
    this("", 1, 5);
  }
}
