package fr.lifl.Aquarium.Simulation;
import java.util.Random;
import java.awt.Color;
import java.io.Serializable;

/**
  * Cette <i>classe</i> represente la nourriture. <p>
  *
  * Une nourriture est representee par un type, une valeur 
  * energetique et une couleur. <p>
  *
  * La valeur energetique d'une nourriture tiree aleatoirement 
  * est comprise entre 0.0 et 1.0. <p>
  *
  * La couleur doit etre fixee par l'utilisateur. <p>
  *  
  * Derniere modification 22 Janvier 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.TableNourriture
  *
  * @version 1.1
  */
public class Nourriture implements Serializable,Cloneable
{
  
  /**
    * Surcharge de la methode toString(). <p>
    *
    * Transforme un objet Nourriture en une chaine de caracteres. <br>
    * Exemple : [a,0.6131362,lightgray] => [type,valeurEnergetique,couleur]. <p>
    *
    * @return une chaine de caractere representant un objet Nourriture.
    */
  public String toString()
  {
    StringBuffer resu = new StringBuffer();
    resu.append("('");
    resu.append(type);
    resu.append("', ");
    resu.append(valeurEnergetique);
    resu.append(", ");
    resu.append(colorToString(couleur));
    resu.append(")");
    return resu.toString();
  }
  
  /**
    * Constructeur d'un objet Nourriture. <p>
    *
    * @param t le type de la nourriture
    * @param val la valeur energetique de la nourriture.
    * @param c la couleur de la nourriture
    */
  public Nourriture(char t, float val, Color c) 
  {
    type = t;
    valeurEnergetique = val;
    couleur = c;
  }
  
  /**
    * Constructeur d'un objet Nourriture. <p>
    *
    * @param t le type de la nourriture
    * @param val la valeur energetique de la nourriture.
    */
  public Nourriture(char t, float val) 
  {
    type = t;
    valeurEnergetique = val;
  }
  
  /**
    * Constructeur d'un objet Nourriture. <p>
    *
    * La valeur energetique de la nourriture est tiree de
    * facon aleatoire, celle-ci sera comprise entre 0.0 et 1.0. <p>
    *
    * @param t le type de la nourriture
    */
  public Nourriture(char t) 
  {
    type = t;
    valeurEnergetique = Generateur.tirerFloat();
  }
  
  /**
    * Methode qui retourne une copie de l'objet. <p>
    *
    * @return une copie de l'objet.
    */
  public Object clone()
  {
    Nourriture resu = new Nourriture();
    resu.type = this.type;
    resu.valeurEnergetique = this.valeurEnergetique;
    if(couleur != null)
      resu.couleur = new Color(this.couleur.getRed(), this.couleur.getGreen(), this.couleur.getBlue());
    return resu;
  }
  
  /**
    * Modifie la couleur de la nourriture. <p>
    *
    * La couleur n'est utilisee que pour l'affichage. <p>
    *
    * @param la nouvelle couleur de l'objet nourriture
    */
  public final void setCouleur(Color c)
  {
    if(c != null)
      couleur = c;
  }
  
  /**
    * Retourne la valeur energetique d'un objet Nourriture. <p>
    *
    * @return la valeur energetique
    */
  public final float getValeur()
  {
    return valeurEnergetique;
  }
  
  /**
    * Retourne la couleur de la nourriture. <p>
    *
    * @return la couleur de l'objet nourriture
    */
  public final Color getCouleur()
  {
    return couleur;
  }
  
  /**
    * Retourne le type d'un objet Nourriture. <p>
    *
    * @return le type
    */
  public final char getType()
  {
    return type;
  }
  
  /**
    * Methode qui convertit une <tt>String</tt> en une 
    * <tt>Color</tt>. <p>
    *
    * @param s la chaine representant une couleur.
    * 
    * @return une couleur
    */
  public final static Color stringToColor(String s)
  {
    if(s.equals("black"))
      return Color.black;
    if(s.equals("cyan"))
      return Color.cyan;
    if(s.equals("blue"))
      return Color.blue;
    if(s.equals("darkGray"))
      return Color.darkGray;
    if(s.equals("gray"))
      return Color.gray;
    if(s.equals("green"))
      return Color.green;
    if(s.equals("lightGray"))
      return Color.lightGray;
    if(s.equals("magenta"))
      return Color.magenta;
    if(s.equals("orange"))
      return Color.orange;
    if(s.equals("pink"))
      return Color.pink;
    if(s.equals("red"))
      return Color.red;
    if(s.equals("white"))
      return Color.white;
    if(s.equals("yellow"))
      return Color.yellow;
    Color c = Color.white;
    try
    {
      c = Color.decode(s);
    }
    catch(NumberFormatException ne)
    {
      ;
    }
    return c;
  }
  
  /**
    * Methode qui convertit une couleur en sa representation chainee. <p>
    *
    * L'utilisation de toString() sur une couleur donne ses composantes 
    * RGB, or je veux une chaine lisible, comme black, blue ... <p>
    *
    * @param c la couleur a tester.
    * 
    * @return une chaine lisible representant c
    */
  public final static String colorToString(Color c)
  {
    
    // On peut ce demander si il est necessaire d'utiliser
    
    // c.equals(Color.black), car Color.black est un final static
    
    // je peux donc sans danger comparer directement les pointeurs
    
    // plutot que de faire appel a equals() qui est plus lourd.
    
    // Mais il n'en est rien, car si je serialise une TableNourriture
    
    // je ne pourrais plus utiliser les pointeurs, car se seront
    
    // de vraie couleurs.
    
    // IL EST DONC IMPERATIF D'UTILISER .equals()
    if(c.equals(Color.black))
      return "black";
    if(c.equals(Color.cyan))
      return "cyan";
    if(c.equals(Color.blue))
      return "blue";
    if(c.equals(Color.darkGray))
      return "darkGray";
    if(c.equals(Color.gray))
      return "gray";
    if(c.equals(Color.green))
      return "green";
    if(c.equals(Color.lightGray))
      return "lightGray";
    if(c.equals(Color.magenta))
      return "magenta";
    if(c.equals(Color.orange))
      return "orange";
    if(c.equals(Color.pink))
      return "pink";
    if(c.equals(Color.red))
      return "red";
    if(c.equals(Color.white))
      return "white";
    if(c.equals(Color.yellow))
      return "yellow";
    return c.toString();
  }
  
  /**
    * Constructeur sans parametre de <tt>Nourriture</tt>. <p>
    *
    * Ce constructeur ne <b><u>doit rien faire</u></b>, il sert uniquement dans
    * la methode <tt>clone()</tt>. <p>
    */
  protected Nourriture() 
  {
    ;
  }
  
  /** La couleur de la <tt>Nourriture</tt>. <p> */
  protected Color couleur = null;
  
  /** La valeur energetique de la <tt>Nourriture</tt>. <p> */
  protected float valeurEnergetique = 0;
  
  /** Le type de la <tt>Nourriture</tt>. <p> */
  protected char type;
}
