package fr.lifl.Aquarium.Ihm;
import javax.swing.ImageIcon;
import java.awt.Color;

/**
  * Cette <i>classe</i> contient toutes les icones utilisees par le
  * logiciel. </p>
  *
  * Derniere modification 23 Janvier 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @version 1.1
  */
public class MesIcones
{
  
  /**
    * Constructeur de MesIcones. <p>
    *
    * Ne sert a rien.
    */
  public MesIcones() 
  {
    ;
  }
  
  /**
    * Cette methode permet d'atteindre les <tt>ImageIcone</tt>
    * representant les couleurs. <p>
    *
    * @param le nom d'un couleur ("black","blue"....)
    * 
    * @return l'<tt>ImageIcone</tt> associe.
    */
  public static ImageIcon getCouleur(String couleur)
  {
    if(couleur.equals("black"))
      return IMG_COULEURS[0];
    if(couleur.equals("blue"))
      return IMG_COULEURS[1];
    if(couleur.equals("white"))
      return IMG_COULEURS[2];
    if(couleur.equals("cyan"))
      return IMG_COULEURS[3];
    if(couleur.equals("darkGray"))
      return IMG_COULEURS[4];
    if(couleur.equals("gray"))
      return IMG_COULEURS[5];
    if(couleur.equals("green"))
      return IMG_COULEURS[6];
    if(couleur.equals("lightGray"))
      return IMG_COULEURS[7];
    if(couleur.equals("magenta"))
      return IMG_COULEURS[8];
    if(couleur.equals("orange"))
      return IMG_COULEURS[9];
    if(couleur.equals("pink"))
      return IMG_COULEURS[10];
    if(couleur.equals("red"))
      return IMG_COULEURS[11];
    if(couleur.equals("yellow"))
      return IMG_COULEURS[12];
    return IMG_COULEURS[0];
  }
  
  /**
    * Cette methode permet d'atteindre les <tt>ImageIcone</tt>
    * representant les couleurs. <p>
    *
    * @param la couleur (Color.black,Color.blue....)
    * 
    * @return l'<tt>ImageIcone</tt> associe.
    */
  public static ImageIcon getCouleur(Color couleur)
  {
    if(couleur.equals(Color.black))
      return IMG_COULEURS[0];
    if(couleur.equals(Color.blue))
      return IMG_COULEURS[1];
    if(couleur.equals(Color.white))
      return IMG_COULEURS[2];
    if(couleur.equals(Color.cyan))
      return IMG_COULEURS[3];
    if(couleur.equals(Color.darkGray))
      return IMG_COULEURS[4];
    if(couleur.equals(Color.gray))
      return IMG_COULEURS[5];
    if(couleur.equals(Color.green))
      return IMG_COULEURS[6];
    if(couleur.equals(Color.lightGray))
      return IMG_COULEURS[7];
    if(couleur.equals(Color.magenta))
      return IMG_COULEURS[8];
    if(couleur.equals(Color.orange))
      return IMG_COULEURS[9];
    if(couleur.equals(Color.pink))
      return IMG_COULEURS[10];
    if(couleur.equals(Color.red))
      return IMG_COULEURS[11];
    if(couleur.equals(Color.yellow))
      return IMG_COULEURS[12];
    return IMG_COULEURS[0];
  }
  
  /** ImageIcon pour le bouton et le menu lancer. <p> */
  public final static ImageIcon IMG_LANCER = new ImageIcon(NomIcones.NOM_IMG_LANCER);
  
  /** ImageIcon pour le bouton et le menu accelerer. <p> */
  public final static ImageIcon IMG_ACCELERER = new ImageIcon(NomIcones.NOM_IMG_ACCELERER);
  
  /** ImageIcon pour le bouton et le menu arreter. <p> */
  public final static ImageIcon IMG_ARRETER = new ImageIcon(NomIcones.NOM_IMG_ARRETER);
  
  /** ImageIcon pour le bouton et le menu creer table nourriture. <p> */
  public final static ImageIcon IMG_CONFIGURER = new ImageIcon(NomIcones.NOM_IMG_CONFIGURER);
  
  /** ImageIcon pour le bouton et le menu Fonctionnement. <p> */
  public final static ImageIcon IMG_FONCT = new ImageIcon(NomIcones.NOM_IMG_FONCT);
  
  /** Les couleurs. <p> */
  public final static ImageIcon IMG_COULEURS[] = 
  {
    new ImageIcon(NomIcones.NOM_COULEURS[0]), new ImageIcon(NomIcones.NOM_COULEURS[1]), 
    new ImageIcon(NomIcones.NOM_COULEURS[2]), new ImageIcon(NomIcones.NOM_COULEURS[3]), 
    new ImageIcon(NomIcones.NOM_COULEURS[4]), new ImageIcon(NomIcones.NOM_COULEURS[5]), 
    new ImageIcon(NomIcones.NOM_COULEURS[6]), new ImageIcon(NomIcones.NOM_COULEURS[7]), 
    new ImageIcon(NomIcones.NOM_COULEURS[8]), new ImageIcon(NomIcones.NOM_COULEURS[9]), 
    new ImageIcon(NomIcones.NOM_COULEURS[10]), new ImageIcon(NomIcones.NOM_COULEURS[11]), 
    new ImageIcon(NomIcones.NOM_COULEURS[12]), new ImageIcon(NomIcones.NOM_COULEURS[13])
  };
  
  /** ImageIcon pour le bouton et le menu aide. <p> */
  public final static ImageIcon IMG_AIDE = new ImageIcon(NomIcones.NOM_IMG_AIDE);
  
  /** ImageIcon pour le bouton et le menu a propos. <p> */
  public final static ImageIcon IMG_APROPOS = new ImageIcon(NomIcones.NOM_IMG_APROPOS);
  
  /** ImageIcon pour le bouton et le menu pause. <p> */
  public final static ImageIcon IMG_PAUSE = new ImageIcon(NomIcones.NOM_IMG_PAUSE);
  
  /** ImageIcon pour le bouton et le menu Nourrir. <p> */
  public final static ImageIcon IMG_NOURRITURE = new ImageIcon(NomIcones.NOM_IMG_NOURRITURE);
  
  /** ImageIcon pour le bouton et le menu Enregistrer Sous. <p> */
  public final static ImageIcon IMG_SAUVER_SOUS = new ImageIcon(NomIcones.NOM_IMG_SAUVER_SOUS);
  
  /** ImageIcon pour le bouton et le menu Quitter. <p> */
  public final static ImageIcon IMG_QUITTER = new ImageIcon(NomIcones.NOM_IMG_QUITTER);
  
  /** ImageIcon pour le bouton et le menu Enregistrer. <p> */
  public final static ImageIcon IMG_SAUVER = new ImageIcon(NomIcones.NOM_IMG_SAUVER);
  
  /** ImageIcon pour le bouton et le menu parametre. <p> */
  public final static ImageIcon IMG_PARAMETRE = new ImageIcon(NomIcones.NOM_IMG_PARAMETRE);
  
  /** ImageIcon pour le bouton et le menu Ouvrir. <p> */
  public final static ImageIcon IMG_OUVRIR = new ImageIcon(NomIcones.NOM_IMG_OUVRIR, "Ouvrir");
  
  /** ImageIcon pour les fenetres de dialogue. <p> */
  public final static ImageIcon IMG_DIALOG_I = new ImageIcon(NomIcones.NOM_IMG_DIALOG_I);
}
