package fr.lifl.Aquarium.Ihm;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import java.awt.FileDialog;
import java.awt.event.ActionListener; // Pour les JMenus
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener; // Pour les menus coches
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <I>classe</I> contient l'objet <tt>JMenuFenetrePrincipale</tt>. <P>
  *
  * C'est la representation du JMenu principal affiche sur la
  * fenetre principale. <P>
  *
  * Il est <b>tres</b> important de comprendre la gestion des evenements
  * ici, c'est la <tt>fenetreMere</tt> (c.a.d la <tt>FenetrePrincipale</tt>)
  * qui <b>execute</b> les actions, le menu ne fait que 
  * <b>signaler</b> a la <tt>FenetrePrincipale</tt> qu'une action a ete
  * levee. <p>
  *
  * Derniere modification 27 Janvier 2000 <br>
  *  
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @version V1.4
  *
  * @see fr.lifl.Aquarium.Ihm.FenetrePrincipale
  */
public class MenuFenetrePrincipale extends JMenuBar implements ActionListener,ItemListener
{
  public int getExperienceNb()
  {
    return experienceNb;
  }
  
  /**
    * Methode qui arrete la simulation. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void arreter()
  {
    if((GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER) || (GestionSimulation.ETAT_COURANT == GestionSimulation.PAUSE) || (GestionSimulation.ETAT_COURANT == GestionSimulation.ACCELERER))
    {
      JMenuItemLancer.setText(Langage.getString("lancer"));
      JMenuItemLancer.setEnabled(true);
      JMenuItemEnregistrer.setEnabled(false);
      JMenuItemEnregistrerSous.setEnabled(false);
      JMenuItemOuvrir.setEnabled(true);
      JMenuItemAccelerer.setEnabled(false);
      JMenuItemPause.setEnabled(false);
      JMenuItemArreter.setEnabled(false);
    }
  }
  
  /**
    * Declenchement d'un evenement. <p>
    *
    * @param e l'action visee.
    */
  public void actionPerformed(ActionEvent e)
  {
    Object o = e.getSource();
    if(o.equals(JMenuItemOuvrir))
      actionOuvrir();
    if(o.equals(JMenuItemEnregistrer))
      actionEnregistrer();
    if(o.equals(JMenuItemEnregistrerSous))
      actionEnregistrerSous();
    if(o.equals(JMenuItemQuitter))
      actionQuitter();
    if(o.equals(JMenuItemFonctionnement))
      actionFonctionnement();
    if(o.equals(JMenuItemAPropos))
      actionAPropos();
    if(o.equals(JMenuItemLancer))
      actionLancer();
    if(o.equals(JMenuItemAccelerer))
      actionAccelerer();
    if(o.equals(JMenuItemPause))
      actionPause();
    if(o.equals(JMenuItemArreter))
      actionArreter();
    if(o.equals(JMenuItemParametre))
      actionParametre();
    if(o.equals(JMenuItemPanneauEffacer))
      actionEffacer();
    if(o.equals(JMenuItemPanneauEnregistrer))
      actionSauverPanneau();
    if(o.equals(JMenuItemPanneauCharger))
      actionChargerPanneau();
    if(o.equals(JMenuItemPanneauInformer))
      actionInformer();
    if(o.equals(JMenuItemPanneauLister))
      actionLister();
  }
  
  /**
    * Methode qui accelere la simulation en desactivant l'affichage. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void accelerer()
  {
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER)
    {
      JMenuItemLancer.setEnabled(true);
      JMenuItemEnregistrer.setEnabled(false);
      JMenuItemEnregistrerSous.setEnabled(false);
      JMenuItemOuvrir.setEnabled(false);
      JMenuItemLancer.setText(Langage.getString("vitesse_normal"));
      JMenuItemAccelerer.setEnabled(false);
      JMenuItemPause.setEnabled(false);
      JMenuItemArreter.setEnabled(true);
    }
  }
  
  /**
    * Le constructeur d'un JMenu de fenetre principale. <P>
    *
    * @param fM la fenetre a laquelle il va appartenir.
    */
  public MenuFenetrePrincipale(FenetrePrincipale fM) 
  {
    int i;
    fenetreMere = fM;
    setOpaque(true);
    
    // Label
    JMenuFichier = new JMenu(Langage.getString("fichier"));
    JMenuItemOuvrir = new JMenuItem(Langage.getString("ouvrir"), MesIcones.IMG_OUVRIR);
    JMenuItemEnregistrer = new JMenuItem(Langage.getString("enregistrer"), MesIcones.IMG_SAUVER);
    JMenuItemEnregistrerSous = new JMenuItem(Langage.getString("enregistrer_sous"), MesIcones.IMG_SAUVER_SOUS);
    JMenuItemQuitter = new JMenuItem(Langage.getString("quitter"), MesIcones.IMG_QUITTER);
    JMenuSimulationExperimental = new JMenu(Langage.getString("simulation_experimental"));
    JRadioButtonMenuItemHasard = new JRadioButtonMenuItem(Langage.getString("hasard"));
    JRadioButtonMenuItemExperience1 = new JRadioButtonMenuItem(Langage.getString("experience") + " " + 1);
    JRadioButtonMenuItemExperience2 = new JRadioButtonMenuItem(Langage.getString("experience") + " " + 2);
    JRadioButtonMenuItemExperience3 = new JRadioButtonMenuItem(Langage.getString("experience") + " " + 3);
    JRadioButtonMenuItemExperience4 = new JRadioButtonMenuItem(Langage.getString("experience") + " " + 4);
    JRadioButtonMenuItemExperience5 = new JRadioButtonMenuItem(Langage.getString("experience") + " " + 5);
    
    // Panneau
    JMenuPanneau = new JMenu(Langage.getString("panneau_information"));
    JMenuItemPanneauEffacer = new JMenuItem(Langage.getString("panneau_effacer"));
    JMenuItemPanneauEnregistrer = new JMenuItem(Langage.getString("enregistrer_sous"), MesIcones.IMG_SAUVER_SOUS);
    JMenuItemPanneauCharger = new JMenuItem(Langage.getString("ouvrir"), MesIcones.IMG_OUVRIR);
    JMenuItemPanneauInformer = new JMenuItem(Langage.getString("information"), MesIcones.IMG_AIDE);
    JMenuItemPanneauLister = new JMenuItem(Langage.getString("lister"));
    
    // Aide
    JMenuAide = new JMenu(Langage.getString("aide"));
    JMenuItemFonctionnement = new JMenuItem(Langage.getString("fonctionnement"), MesIcones.IMG_FONCT);
    JMenuItemAPropos = new JMenuItem(Langage.getString("a_propos"), MesIcones.IMG_APROPOS);
    JMenuSimulation = new JMenu(Langage.getString("simulation"));
    JMenuItemLancer = new JMenuItem(Langage.getString("lancer"), MesIcones.IMG_LANCER);
    JMenuItemAccelerer = new JMenuItem(Langage.getString("accelerer"), MesIcones.IMG_ACCELERER);
    JMenuItemPause = new JMenuItem(Langage.getString("pause"), MesIcones.IMG_PAUSE);
    JMenuItemArreter = new JMenuItem(Langage.getString("arreter"), MesIcones.IMG_ARRETER);
    JMenuItemParametre = new JMenuItem(Langage.getString("parametres"), MesIcones.IMG_PARAMETRE);
    
    // Evenements
    JMenuItemPanneauEffacer.addActionListener(this);
    JMenuItemPanneauEnregistrer.addActionListener(this);
    JMenuItemPanneauCharger.addActionListener(this);
    JMenuItemOuvrir.addActionListener(this);
    JMenuItemEnregistrer.addActionListener(this);
    JMenuItemEnregistrerSous.addActionListener(this);
    JMenuItemQuitter.addActionListener(this);
    JMenuItemFonctionnement.addActionListener(this);
    JMenuItemAPropos.addActionListener(this);
    JMenuItemLancer.addActionListener(this);
    JMenuItemAccelerer.addActionListener(this);
    JMenuItemPause.addActionListener(this);
    JMenuItemArreter.addActionListener(this);
    JMenuItemParametre.addActionListener(this);
    JMenuItemPanneauInformer.addActionListener(this);
    JMenuItemPanneauLister.addActionListener(this);
    
    //JMenuItemConfigurerTableN.addActionListener(this);
    JRadioButtonMenuItemHasard.addItemListener(this);
    JRadioButtonMenuItemExperience1.addItemListener(this);
    JRadioButtonMenuItemExperience2.addItemListener(this);
    JRadioButtonMenuItemExperience3.addItemListener(this);
    JRadioButtonMenuItemExperience4.addItemListener(this);
    JRadioButtonMenuItemExperience5.addItemListener(this);
    groupeSimulation = new ButtonGroup();
    groupeSimulation.add(JRadioButtonMenuItemHasard);
    groupeSimulation.add(JRadioButtonMenuItemExperience1);
    groupeSimulation.add(JRadioButtonMenuItemExperience2);
    groupeSimulation.add(JRadioButtonMenuItemExperience3);
    groupeSimulation.add(JRadioButtonMenuItemExperience4);
    groupeSimulation.add(JRadioButtonMenuItemExperience5);
    JRadioButtonMenuItemHasard.setSelected(true);
    
    // Les raccourcis claviers
    JMenuItemPanneauEffacer.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, 2));
    JMenuItemOuvrir.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, 2));
    JMenuItemEnregistrer.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, 2));
    JMenuItemEnregistrerSous.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F12, 0));
    JMenuItemQuitter.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, 2));
    JMenuItemLancer.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0));
    JMenuItemPause.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, 0));
    JMenuItemArreter.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, 0));
    JMenuItemParametre.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_M, 0));
    
    // Construction du menu
    this.add(JMenuFichier);
    this.add(JMenuSimulation);
    this.add(JMenuPanneau);
    this.add(JMenuAide);
    JMenuFichier.add(JMenuItemOuvrir);
    JMenuFichier.add(JMenuItemEnregistrer);
    JMenuFichier.add(JMenuItemEnregistrerSous);
    JMenuFichier.addSeparator();
    JMenuFichier.add(JMenuItemQuitter);
    JMenuSimulation.add(JMenuItemParametre);
    JMenuSimulation.addSeparator();
    JMenuSimulationExperimental.add(JRadioButtonMenuItemHasard);
    JMenuSimulationExperimental.add(JRadioButtonMenuItemExperience1);
    JMenuSimulationExperimental.add(JRadioButtonMenuItemExperience2);
    JMenuSimulationExperimental.add(JRadioButtonMenuItemExperience3);
    JMenuSimulationExperimental.add(JRadioButtonMenuItemExperience4);
    JMenuSimulationExperimental.add(JRadioButtonMenuItemExperience5);
    JMenuSimulation.add(JMenuSimulationExperimental);
    JMenuSimulation.addSeparator();
    JMenuSimulation.add(JMenuItemLancer);
    JMenuSimulation.add(JMenuItemAccelerer);
    JMenuSimulation.add(JMenuItemPause);
    JMenuSimulation.add(JMenuItemArreter);
    JMenuPanneau.add(JMenuItemPanneauInformer);
    JMenuPanneau.add(JMenuItemPanneauLister);
    JMenuPanneau.add(JMenuItemPanneauEffacer);
    JMenuPanneau.add(JMenuItemPanneauCharger);
    JMenuPanneau.add(JMenuItemPanneauEnregistrer);
    JMenuAide.add(JMenuItemFonctionnement);
    JMenuAide.addSeparator();
    JMenuAide.add(JMenuItemAPropos);
    
    // Pas encore implemente jdk1.2.2 !!!!!
    
    // this.setHelpMenu(JMenuAide);
    
    // Tant que la simulation n'est pas lance, l'option pause, accelerer
    
    // et arreter sont grisees  
    JMenuItemAccelerer.setEnabled(false);
    JMenuItemPause.setEnabled(false);
    JMenuItemArreter.setEnabled(false);
    JMenuItemEnregistrer.setEnabled(false);
    JMenuItemEnregistrerSous.setEnabled(false);
  }
  
  /**
    * Methode qui place la simulation en pause. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void pause()
  {
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER)
    {
      JMenuItemLancer.setEnabled(true);
      JMenuItemEnregistrer.setEnabled(true);
      JMenuItemEnregistrerSous.setEnabled(true);
      JMenuItemOuvrir.setEnabled(false);
      JMenuItemLancer.setText(Langage.getString("continuer"));
      JMenuItemAccelerer.setEnabled(false);
      JMenuItemPause.setEnabled(false);
      JMenuItemArreter.setEnabled(true);
    }
  }
  public void itemStateChanged(ItemEvent e)
  {
    JRadioButtonMenuItem oJrb = (JRadioButtonMenuItem)e.getSource();
    if(estExperimental(oJrb))
    {
      
      // Experience 1
      if(oJrb.getText().equals(Langage.getString("experience") + " " + 1))
      {
        experienceNb = 1;
        fenetreMere.creerAquarium();
      }
      
      // Experience 2
      if(oJrb.getText().equals(Langage.getString("experience") + " " + 2))
      {
        experienceNb = 2;
        fenetreMere.creerAquarium();
      }
      
      // Experience 3
      if(oJrb.getText().equals(Langage.getString("experience") + " " + 3))
      {
        experienceNb = 3;
      
      //fenetreMere.creerAquarium();
      }
      
      // Experience 4
      if(oJrb.getText().equals(Langage.getString("experience") + " " + 4))
      {
        experienceNb = 4;
      
      //fenetreMere.creerAquarium();
      }
      
      // Experience 5
      if(oJrb.getText().equals(Langage.getString("experience") + " " + 5))
      {
        experienceNb = 5;
      
      //fenetreMere.creerAquarium();
      }
      
      // Normal
      if(oJrb.getText().equals(Langage.getString("hasard")))
      {
        experienceNb = 0;
        fenetreMere.creerAquarium();
      }
      return ;
    }
  }
  
  /**
    * Methode qui lance la simulation. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void lancer()
  {
    JMenuItemLancer.setEnabled(false);
    JMenuItemEnregistrer.setEnabled(false);
    JMenuItemEnregistrerSous.setEnabled(false);
    JMenuItemOuvrir.setEnabled(false);
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.PAUSE)
    {
      JMenuItemLancer.setText(Langage.getString("lancer"));
      JMenuItemAccelerer.setEnabled(true);
      JMenuItemPause.setEnabled(true);
      JMenuItemArreter.setEnabled(true);
    }
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
    {
      JMenuItemAccelerer.setEnabled(true);
      JMenuItemPause.setEnabled(true);
      JMenuItemArreter.setEnabled(true);
    }
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.ACCELERER)
    {
      JMenuItemLancer.setText(Langage.getString("lancer"));
      JMenuItemAccelerer.setEnabled(true);
      JMenuItemPause.setEnabled(true);
      JMenuItemArreter.setEnabled(true);
    }
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu A Propos. <p>
    */
  protected void actionAPropos()
  {
    fenetreMere.aPropos();
  }
  
  /**
    * Sauve le panneau d'information. <p>
    */
  protected void actionSauverPanneau()
  {
    fenetreMere.sauverPanneau();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Quitter. <p>
    */
  protected void actionQuitter()
  {
    fenetreMere.quitter();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Informer. <p>
    */
  protected void actionInformer()
  {
    fenetreMere.informer();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Fonctionnement. <p>
    */
  protected void actionFonctionnement()
  {
    fenetreMere.aide();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Enregistrer. <p>
    */
  protected void actionEnregistrer()
  {
    fenetreMere.sauver();
  }
  
  /**
    * Charge le panneau d'information. <p>
    */
  protected void actionChargerPanneau()
  {
    fenetreMere.chargerPanneau();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Accelerer. <p>
    */
  protected void actionAccelerer()
  {
    fenetreMere.accelerer();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Pause. <p>
    */
  protected void actionPause()
  {
    fenetreMere.pause();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Enregistrer Sous. <p>
    */
  protected void actionEnregistrerSous()
  {
    fenetreMere.sauverSous();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Parametre. <p>
    */
  protected void actionParametre()
  {
    fenetreMere.afficheParametre();
  }
  
  /**
    * Efface le panneau d'information. <p>
    */
  protected void actionEffacer()
  {
    fenetreMere.effacer();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Ouvrir. <p>
    */
  protected void actionOuvrir()
  {
    fenetreMere.charger();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Arreter. <p>
    */
  protected void actionArreter()
  {
    fenetreMere.arreter();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Lister. <p>
    */
  protected void actionLister()
  {
    fenetreMere.lister();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le menu Lancer. <p>
    */
  protected void actionLancer()
  {
    fenetreMere.lancer();
  }
  private boolean estExperimental(JRadioButtonMenuItem o)
  {
    boolean resu = false;
    if(o == null)
      return resu;
    resu = o.getText().startsWith(Langage.getString("experience")) || o.getText().startsWith(Langage.getString("hasard"));
    return resu;
  }
  
  /** Le numero de l'experience choisie. <p> */
  protected int experienceNb = 0;
  private JMenuItem JMenuItemFonctionnement = null;
  private FenetrePrincipale fenetreMere = null;
  private JMenuItem JMenuItemOuvrir = null;
  private JMenuItem JMenuItemPanneauCharger = null;
  private JMenuItem JMenuItemEnregistrerSous = null;
  private JMenuItem JMenuItemPanneauEffacer = null;
  private JMenuItem JMenuItemPause = null;
  private JMenuItem JMenuItemLancer = null;
  
  // Panneau
  private JMenu JMenuPanneau = null;
  private JMenuItem JMenuItemPanneauInformer = null;
  private JMenuItem JMenuItemQuitter = null;
  private JMenuItem JMenuItemArreter = null;
  private JMenuItem JRadioButtonMenuItemExperience4 = null;
  private JMenuItem JMenuItemAccelerer = null;
  private JMenuItem JRadioButtonMenuItemExperience3 = null;
  
  // Simulation
  private JMenu JMenuSimulation = null;
  private JMenuItem JRadioButtonMenuItemExperience2 = null;
  private JMenuItem JMenuItemPanneauEnregistrer = null;
  private JMenuItem JRadioButtonMenuItemExperience1 = null;
  private JMenuItem JMenuItemPanneauLister = null;
  private JMenuItem JRadioButtonMenuItemHasard = null;
  private JMenuItem JMenuItemEnregistrer = null;
  private JMenu JMenuSimulationExperimental = null;
  private JMenuItem JMenuItemAPropos = null;
  private JMenuItem JMenuItemParametre = null;
  
  // Aide
  private JMenu JMenuAide = null;
  private JMenuItem JRadioButtonMenuItemExperience5 = null;
  
  // Fichier
  private JMenu JMenuFichier = null;
  
  // Group
  private ButtonGroup groupeSimulation = null;
}
