package fr.lifl.Aquarium.Simulation;
import java.util.Locale;
import java.util.ResourceBundle;

/**
  * Cette <i>classe</i> permet d'acceder facilement au
  * ressourceBundle qui doit ce charger du langage. <p>
  *
  * Derniere modification 17 Janvier 2000. <p>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.0)
  * </ul>
  *
  * @version 1.0
  */
public class Langage
{
  
  /** Chemin des .properties. <p> */
  private final static String CHEMIN = "locale/Messages";
  private final static Locale localeEn = new Locale("en", "US");
  
  /** Pour le multilangage. <p> */
  private final static Locale localeFr = new Locale("fr", "FR");

  /** Pour le multi-langage. <p> */
  private static ResourceBundle resourceBundle = ResourceBundle.getBundle(CHEMIN, localeFr);

  
  /**
    * Retourne la chaine associee a son nom. <p>
    *
    * @param s le nom
    *
    * @return la chaine associee a son nom
    */
  public final static String getString(String s)
  {
    if(s != null)
      return resourceBundle.getString(s);
    return "";
  }
  
  /**
    * Modifie le langage utilise. <p>
    *
    * @param s soit "FR" soit "EN".
    */
  public final static void setLanguage(String s)
  {
    if(s == null)
      return ;
    if(s.equals("FR"))
      resourceBundle = ResourceBundle.getBundle(CHEMIN, localeFr);
    if(s.equals("EN"))
      resourceBundle = ResourceBundle.getBundle(CHEMIN, localeEn);
  }
  
}
