package fr.lifl.Aquarium.Simulation;
import java.util.Random;

/**
  * <i>Classe</i> permettant de definir l'objet <tt>Generateur</tt>. <P>
  *
  * Celui-ci caracterise les generateurs de nombres aleatoires. <p>
  *
  * <b>ATTENTION !</b> Il ne peut y avoir qu'un seul generateur a la fois. <p>
  *
  * Derniere modification 29 Janvier 2000. <p>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.0)
  * </ul>
  *
  * @version 1.0
  */
public class Generateur
{
  
  /**
    * Change la graine du generateur. <p>
    *
    * @param seed la nouvelle graine
    */
  public static void setSeed(long seed)
  {
    generateur.setSeed(seed);
  }
  
  /**
    * Methode utilisee pour obtenir soit + soit -. <p>
    * 
    * @return
    * <ul>
    *	<li>Soit +1, pour +
    *	<li>Soit -1, pour -
    * </ul>
    */
  public static int signe()
  {
    int r = Generateur.tirerIntEntre(2);
    if(r == 1)
      return -1;
    else
      return +1;
  }
  
  /**
    * Tire un <tt>double</tt> de facon aleaoire. <p>
    *
    * @return le double tire (entre 0.0 inclu et 1.0 exclu)
    */
  public static double tirerDouble()
  {
    return Math.abs(generateur.nextDouble());
  }
  
  /**
    * Tire un <tt>double</tt> de facon aleaoire compris entre <tt>0.0</tt>
    * et <tt>sup</tt>. <p>
    *
    * @param sup la borne superieure <b>stricte</b> du nombre a tirer
    *
    * @return le double tire
    */
  public static double tirerDoubleEntre(int sup)
  {
    return Math.abs(generateur.nextDouble() * sup);
  }
  
  /**
    * Tire un <tt>int</tt> de facon aleaoire compris entre <tt>inf</tt>
    * et <tt>sup</tt>. <p>
    *
    * @param inf la borne inferieure du nombre a tirer
    * @param sup la borne superieure <b>stricte</b> du nombre a tirer
    *
    * @return le int tire
    */
  public static int tirerIntEntre(int inf, int sup)
  {
    int resu = 0;
    if(sup > 0)
    {
      resu = generateur.nextInt(sup);
      if(resu < inf)
        resu = inf;
    }
    return resu;
  }
  
  /**
    * Tire un <tt>float</tt> de facon aleaoire compris entre <tt>0.0</tt>
    * et <tt>sup</tt>. <p>
    *
    * @param sup la borne superieure <b>stricte</b> du nombre a tirer
    *
    * @return le flotant tire
    */
  public static float tirerFloatEntre(int sup)
  {
    return Math.abs(generateur.nextFloat() * sup);
  }
  
  /**
    * Tire un <tt>int</tt> de facon aleaoire. <p>
    *
    * @return l'entier tire
    */
  public static int tirerInt()
  {
    return Math.abs(generateur.nextInt());
  }
  
  /**
    * Tire un <tt>int</tt> de facon aleaoire compris entre <tt>0</tt>
    * et <tt>sup</tt>. <p>
    *
    * @param sup la borne superieure <b>stricte</b> du nombre a tirer
    *
    * @return le int tire
    */
  public static int tirerIntEntre(int sup)
  {
    return generateur.nextInt(Math.abs(sup));
  }
  
  /**
    * Tire un <tt>float</tt> de facon aleaoire. <p>
    *
    * @return le flottant tire (entre 0.0 inclu et 1.0 exclu)
    */
  public static float tirerFloat()
  {
    return Math.abs(generateur.nextFloat());
  }
  
  /** Le generateur de nombres aleatoires. <p> */
  protected static Random generateur = new Random();
}
