package fr.lifl.Aquarium.Ihm;
import javax.swing.*;
import java.awt.FileDialog;
import java.awt.Label;
import java.awt.Frame;
import java.awt.Color;
import java.awt.Point;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.io.File;
import java.awt.event.ItemEvent;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.AquariumGraphique;
import fr.lifl.Aquarium.Simulation.Aquarium;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.Ver;
import fr.lifl.Aquarium.Simulation.ListeVer;

/**
  * Cette <i>classe</i> represente la fenetre principale. <p>
  *
  * Elle apparait quand on lance le logiciel. <p>
  *
  * C'est elle qui gere toutes les actions et qui decide de l'ouverture
  * des autres fenetres. <p>
  *
  * Derniere modification 16 Mars 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V2.++)
  * </ul>
  *
  * @version 2.0
  */
public class FenetrePrincipale extends SuperFenetre
{
  
  /**
    * Methode qui sauve sous une simulation. <p>
    */
  public void sauverSous()
  {
    if(aquarium != null)
    {
      String nom = aquarium.getNomFichier();
      Frame f = new Frame();
      FileDialog fD = new FileDialog(this, Langage.getString("sauver") + " " + Langage.getString("aquarium"), FileDialog.SAVE);
      fD.setVisible(true);
      if(fD.getFile() != null)
        nom = fD.getDirectory() + fD.getFile();
      fD.dispose();
      f.dispose();
      synchronized(aquarium)
      {
        if(!aquarium.sauver(nom))
          panneauInformation.append(Erreur.getString("erreur_fenetreprincipale_sauver"));
      }
    }
  }
  
  /**
    * Sauvegarde le panneau d'information. <p>
    */
  public void sauverPanneau()
  {
    String nomFichier = null;
    FileDialog fD = new FileDialog(this, Langage.getString("sauver"), FileDialog.SAVE);
    fD.setVisible(true);
    if(fD.getFile() != null)
    {
      nomFichier = fD.getDirectory() + fD.getFile();
      fD.dispose();
      if(!panneauInformation.sauver(nomFichier))
        FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("impossible_de_sauver"), FenetreDialog.OK);
    }
    else
      fD.dispose();
  }
  
  /**
    * Methode qui sauve une simulation. <p>
    */
  public void sauver()
  {
    if(aquarium != null)
    {
      String nom = aquarium.getNomFichier();
      if(nom == null)
      {
        Frame f = new Frame();
        FileDialog fD = new FileDialog(this, Langage.getString("sauver") + " " + Langage.getString("aquarium"), FileDialog.SAVE);
        fD.setVisible(true);
        if(fD.getFile() != null)
          nom = fD.getDirectory() + fD.getFile();
        fD.dispose();
        f.dispose();
      }
      synchronized(aquarium)
      {
        if(!aquarium.sauver(nom))
          panneauInformation.append(Erreur.getString("erreur_fenetreprincipale_sauver"));
      }
    }
  }
  
  /**
    * Methode qui donne acces a la barre d'outils. <p>
    *
    * @return la barre d'outils
    */
  public BarreOutilsPrincipale getBarre()
  {
    return barre;
  }
  
  /**
    * Fabrique l'aquarium en fonction du choix dans le menu experience. <p>
    */
  public void creerAquarium()
  {
    if(isVisible())
    {
      if(aquarium != null)
      {
        if(!(parametres.getTaillePiste().equals(aquarium.getPisteGraphique().getTaille())))
        {
          jScrollPane2.getViewport().remove(dessin);
          dessin = new PisteGraphique(parametres.getTaillePiste());
          jScrollPane2.getViewport().add(dessin);
          aquarium.setPisteGraphique(dessin);
          pack();
        }
      }
      else
      {
        dessin = new PisteGraphique(parametres.getTaillePiste());
        jScrollPane2.getViewport().add(dessin);
        aquarium = new AquariumGraphique(parametres, dessin);
        pack();
        centrer();
      }
      panneauInformation.effacer();
      if(aquarium.getNomFichier() == null)
        panneauInformation.append(aquarium.experienceType(menu.getExperienceNb()));
    }
  }
  
  /**
    * Methode qui lance la simulation. <p>
    */
  public void accelerer()
  {
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER)
    {
      menu.accelerer();
      barre.accelerer();
      if(aquarium != null)
      {
        aquarium.getPisteGraphique().initGraphique();
        aquarium.getPisteGraphique().repaint();
      }
      GestionSimulation.ETAT_COURANT = GestionSimulation.ACCELERER;
    }
  }
  
  /**
    * Methode qui ouvre la fenetre d'aide. <p>
    */
  public void aide()
  {
    ;
  }
  
  /**
    * Methode qui arrete la simulation. <p>
    *
    * Il n'est pas utile de faire <tt>thread.stop()</tt>, car, quand
    * <tt>GestionSimulation.ETAT_COURANT</tt> passe a 
    * <tt>GestionSimulation.ARRETER</tt>, la thread s'arretera d'elle meme,
    * certe, elle terminera les <i>deplacements</i> en cours, mais elle
    * s'arretera toute seule. <p>
    */
  public void arreter()
  {
    menu.arreter();
    barre.arreter();
    GestionSimulation.ETAT_COURANT = GestionSimulation.ARRETER;
    
    // Si on etait en pause, il faut redemarer la thread
    if(thread != null)
      thread.resume();
    aquarium.setNomFichier(null);
  }
  
  /**
    * Methode qui ferme l'application. <p>
    */
  public void quitter()
  {
    GestionSimulation.ETAT_COURANT = GestionSimulation.ARRETER;
    fermerFenetre();
  }
  
  /**
    * Constructeur d'une fenetre principale. <p>
    *
    * @param p les parametres de la simulation.
    */
  public FenetrePrincipale(Parametres p) 
  {
    super();
    setTitle(Langage.getString("titre_fenetre_principale"));
    setIcone(NomIcones.NOM_IMG_PRICIPALE_I);
    if(p != null)
      this.parametres = p;
    else
      this.parametres = new Parametres();
    panneauInformation = new Panneau();
    panneauInformation.setEditable(false);
    menu = new MenuFenetrePrincipale(this);
    barre = new BarreOutilsPrincipale(this);
    jScrollPane1 = new JScrollPane();
    jScrollPane2 = new JScrollPane();
    setJMenuBar(menu);
    contentPane.add(barre, BorderLayout.NORTH);
    contentPane.add(new Label(), BorderLayout.EAST);
    contentPane.add(new Label(), BorderLayout.WEST);
    
    // Panneau d'information
    BoiteEntouree be = new BoiteEntouree(Langage.getString("information"));
    be.setLayout(new GridLayout(1, 1));
    jScrollPane1.setOpaque(true);
    jScrollPane1.getViewport().add(panneauInformation);
    
    // jScrollPane.setVerticalScrollBar(new JScrollBar());        
    be.add(jScrollPane1); //, BorderLayout.CENTER);
    contentPane.add(be, BorderLayout.SOUTH);
    contentPane.add(jScrollPane2, BorderLayout.CENTER);
    setSize(NORMAL);
    centrer();
    setVisible(true);
  }
  
  /**
    * Methode qui place la simulation en pause. <p>
    */
  public void pause()
  {
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER)
    {
      menu.pause();
      barre.pause();
      if(thread != null)
        thread.suspend();
      GestionSimulation.ETAT_COURANT = GestionSimulation.PAUSE;
    }
  }
  
  /**
    * Methode qui affiche la fenetre des parametres. <p>
    */
  public void afficheParametre()
  {
    FenetreParametre fP = new FenetreParametre(this);
  }
  
  /**
    * Affiche tous les vers. <p>
    */
  public void lister()
  {
    if(aquarium != null)
    {
      if(GestionSimulation.ETAT_COURANT != GestionSimulation.ARRETER)
      {
        int i;
        if(aquarium.getListeVer() == null)
          return ;
        panneauInformation.append(aquarium.getListeVer().afficherVers());
      }
    }
  }
  
  /**
    * Methode qui ouvre la fenetre d'a propos. <p>
    */
  public void aPropos()
  {
    FenetreAPropos ap = new FenetreAPropos(this);
    ap.setVisible(true);
  }
  
  /**
    * Methode qui lance la simulation. <p>
    */
  public void lancer()
  {
    int i;
    menu.lancer();
    barre.lancer();
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.PAUSE)
    {
      if(thread != null)
        thread.resume();
    }
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
    {
      creerAquarium();
      GestionSimulation.ETAT_COURANT = GestionSimulation.LANCER;
      thread = new Thread(aquarium);
      thread.start();
      thread.setPriority((Thread.MAX_PRIORITY - Thread.MIN_PRIORITY) / 2);
    }
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.ACCELERER)
    {
      GestionSimulation.ETAT_COURANT = GestionSimulation.LANCER;
      aquarium.getPisteGraphique().affichePiste(parametres.getTableNourriture(), aquarium.getListeVer());
    }
    GestionSimulation.ETAT_COURANT = GestionSimulation.LANCER;
  }
  
  /**
    * Methode qui donne acces au menu. <p>
    *
    * @return le menu de la fenetre principale.
    */
  public MenuFenetrePrincipale getMenu()
  {
    return menu;
  }
  
  /**
    * Affiche l'indice de convergence. <p>
    */
  public void informer()
  {
    if(aquarium != null)
    {
      if(GestionSimulation.ETAT_COURANT != GestionSimulation.ARRETER)
      {
        if(aquarium.getListeVer() == null)
          return ;
        panneauInformation.append(aquarium.getListeVer().informer());
      }
    }
  }
  
  /**
    * Charge le panneau d'information. <p>
    */
  public void chargerPanneau()
  {
    String nomFichier = null;
    FileDialog fD = new FileDialog(this, Langage.getString("charger"), FileDialog.LOAD);
    fD.setVisible(true);
    if(fD.getFile() != null)
    {
      nomFichier = fD.getDirectory() + fD.getFile();
      fD.dispose();
      if(!(panneauInformation.charger(nomFichier)))
        FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("impossible_de_charger"), FenetreDialog.OK);
    }
    else
      fD.dispose();
  }
  
  /**
    * Constructeur d'une fenetre principale. <p>
    *
    * Les parametres sont ceux par defaut.
    *
    * @see Simulation.Parametres
    */
  public FenetrePrincipale() 
  {
    this(new Parametres());
  }
  
  /**
    * Efface le panneau d'information. <p>
    */
  public void effacer()
  {
    panneauInformation.effacer();
  }
  
  /**
    * Constructeur d'une fenetre principale. <p>
    *
    * Le lancement se fait avec les arguments suivant :
    * <ul>
    * 	<li>args[2] : parametres = nom fichier d'un objet Parametres serialise
    * 	<li>args[3] : place = nom fichier d'un objet PisteGraphique serialise
    * 	<li>args[4] : list = nom fichier d'un objet ListeVer serialise
    *	</ul>
    */
  public FenetrePrincipale(String args[]) 
  {
    this();
    String args2 = null;
    String args3 = null;
    String args4 = null;
    if(args != null)
    {
      if(args.length > 2)
        args2 = args[2];
      if(args.length > 3)
        args3 = args[3];
      if(args.length > 4)
        args4 = args[4];
    }
    charger(args2, args3, args4);
  }
  
  /**
    * Methode qui charge une simulation. <p>
    */
  public void charger()
  {
    Frame f = new Frame();
    FileDialog fD = new FileDialog(this, Langage.getString("charger") + " " + Langage.getString("aquarium"), FileDialog.LOAD);
    fD.setVisible(true);
    String nom = null;
    if(fD.getFile() != null)
      nom = fD.getDirectory() + fD.getFile();
    fD.dispose();
    f.dispose();
    if(nom == null)
      return ;
    if(nom.trim().equals(""))
      return ;
    Aquarium a = null;
    if(aquarium == null)
    {
      parametres = Parametres.charger(nom + ".par");
      dessin = new PisteGraphique(parametres.getTaillePiste());
      jScrollPane2.getViewport().add(dessin);
      aquarium = new AquariumGraphique(parametres, dessin);
    }
    a = Aquarium.charger(nom);
    if(a == null)
      return ;
    aquarium.setAquarium(a);
    aquarium.setNomFichier(nom);
    setParametres(a.getParametres());
  }
  
  /**
    * Modifie les parametres associes. <p>
    * 
    * @param p les nouveaux parametres associes
    *
    * @return
    * <ul>
    *   <li>true si les parametres ont change
    *   <li>false sinon
    * </ul>
    */
  public final boolean setParametres(Parametres p)
  {
    if(p == null)
      return false;
    parametres = p;
    barre.remplirComboNourriture(p.getTableNourriture());
    if(aquarium != null)
      aquarium.setParametres(parametres);
    return true;
  }
  
  /**
    * Methode qui retourne les parametres associes. <p>
    * 
    * @return les parametres associes
    */
  public final Parametres getParametres()
  {
    return parametres;
  }
  
  /**
    * Demarre une simulation en mode graphique. <p>
    *
    * Le lancement ce fait avec les arguments suivant :
    * <ul>
    * 	<li>args[2] : parametres = nom fichier d'un objet Parametres serialise
    * 	<li>args[3] : place = nom fichier d'un objet PisteGraphique serialise
    * 	<li>args[4] : list = nom fichier d'un objet ListeVer serialise
    *	</ul>
    */
  public static void main(String[] args)
  {
    FenetrePrincipale fp = new FenetrePrincipale(args);
    fp.setVisible(true);
  }
  
  /**
    * Methode qui charge une simulation. <p>
    *
    * <b>ATTENTION</b> : IL EST TRES IMPORTANT QUE LA PISTE ET LA LISTE DES 
    *	VERS SOIENT EN HARMONIE AVEC LES PARAMETRES, sinon, ......... houlalalalalala.... <p>
    *
    * @param nomParametre le nom du fichier d'ou charger les <tt>Parametres</tt> de l'aquarium
    * @param nomPiste le nom du fichier d'ou charger la <tt>Piste</tt> de l'aquarium
    * @param nomListeVer le nom du fichier d'ou charger la <tt>ListeVer</tt> de l'aquarium
    */
  protected void charger(String nomParametre, String nomPiste, String nomListeVer)
  {
    Aquarium a = null;
    if(aquarium == null)
    {
      parametres = Parametres.charger(nomParametre);
      dessin = new PisteGraphique(parametres.getTaillePiste());
      jScrollPane2.getViewport().add(dessin);
      aquarium = new AquariumGraphique(parametres, dessin);
    }
    a = Aquarium.charger(nomPiste, nomListeVer);
    if(a == null)
      return ;
    aquarium.setAquarium(a);
    aquarium.setNomFichier(null);
    setParametres(a.getParametres());
  }
  
  /** Les parametres de la simulation. </p> */
  protected Parametres parametres = null;
  private JScrollPane jScrollPane1 = null;
  private MenuFenetrePrincipale menu = null;
  private JScrollPane jScrollPane2 = null;
  private AquariumGraphique aquarium = null;
  private Panneau panneauInformation = null;
  private BarreOutilsPrincipale barre = null;
  private Thread thread = null;
  private PisteGraphique dessin = null;
}
