package fr.lifl.Aquarium.Ihm;
import java.awt.TextField;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Button;
import java.awt.Panel;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente la fenetre qui contient tous les parametres
  * d'une simulation. <p>
  *
  * Elle apparait quand on clique sur le bouton des parametres 
  * (clef anglaise) ou quand on choisit Parametres dans le menu de la
  * fenetre principale. </p>
  *
  * Derniere modification 07 Mars 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Simulation.Parametres
  * @see fr.lifl.Aquarium.Ihm.PanneauParametres
  * @see fr.lifl.Aquarium.Ihm.FenetreConfigurerAlgoGenetic
  * @see fr.lifl.Aquarium.Ihm.FenetreConfigurerHalo
  * @see fr.lifl.Aquarium.Ihm.FenetreConfigurerTableNourriture
  *
  * @version 1.2
  */
public class FenetreParametre extends SuperDialog
{
  
  /**
    * Methode qui modifie la table des nourritures actuelle. <p>
    *
    * @param la nouvelle table de nourriture <b>actuelle</b> de la fenetre
    */
  public void setTableNourriture(TableNourriture tn)
  {
    newParametres.setTableNourriture(tn);
    panneauParametres.setCas(newParametres.getCas());
  }
  
  /**
    * Methode qui sauve les parametres contenus dans la fenetre. <P>
    *
    * @return
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  public boolean sauver()
  {
    int i = 0;
    String nomFichier = null;
    Frame f = new Frame();
    FileDialog fD = new FileDialog(f, Langage.getString("sauver") + " " + Langage.getString("parametres"), FileDialog.SAVE);
    fD.setVisible(true);
    if(fD.getFile() != null)
    {
      nomFichier = fD.getDirectory() + fD.getFile();
      fD.dispose();
      f.dispose();
    }
    else
    {
      fD.dispose();
      f.dispose();
      return false;
    }
    if(nomFichier == null)
      return false;
    if(nomFichier.trim().equals(""))
      return false;
    
    // Ici, je ne fais que sauver les parametres qui sont representes
    
    // par le panneau de parametres.
    
    // Je ne modifie en rien les parametres de la fenetreMere, qui,
    
    // je le rappelle, ne sont modifies que quand on appuie sur le bouton ok.
    if(panneauParametres.accepterParametres(newParametres))
      return newParametres.sauver(nomFichier);
    return false;
  }
  
  /**
    * Methode qui retourne la ,table des nourritures actuelle. <p>
    *
    * @return la table de nourriture <b>actuelle</b> de la fenetre
    */
  public TableNourriture getTableNourriture()
  {
    return newParametres.getTableNourriture();
  }
  
  /**
    * Constructeur d'une fenetre Parametre. <p>
    *
    * @param fM la fenetre mere.
    */
  public FenetreParametre(FenetrePrincipale fM) 
  {
    super(fM);
    fenetreMere = fM;
    setTitle(Langage.getString("titre_fenetre_parametre"));
    contentPane.setLayout(new BorderLayout());
    
    // copie des parametres courants
    oldParametres = (Parametres)fM.getParametres().clone();
    
    // Les 'nouveaux'
    newParametres = (Parametres)fM.getParametres().clone();
    panneauParametres = new PanneauParametres(this);
    
    // Intenciation
    buttonAnnuler = new Button(Langage.getString("annuler"));
    buttonDefaut = new Button(Langage.getString("defaut"));
    buttonOk = new Button(Langage.getString("ok"));
    buttonCharger = new Button(Langage.getString("charger"));
    buttonSauver = new Button(Langage.getString("enregistrer"));
    
    // Gestions evenements
    buttonAnnuler.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionAnnuler();
      }
    });
    buttonOk.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    buttonCharger.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionCharger();
      }
    });
    buttonSauver.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionSauver();
      }
    });
    buttonDefaut.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionDefaut();
      }
    });
    
    // Construction
    Panel pSud = new Panel();
    pSud.setLayout(new GridLayout(1, 3, 5, 5));
    pSud.add(buttonAnnuler);
    pSud.add(buttonDefaut);
    pSud.add(buttonOk);
    contentPane.add(pSud, BorderLayout.SOUTH);
    Panel pNord = new Panel();
    pNord.setLayout(new GridLayout(1, 3));
    pNord.add(buttonCharger);
    pNord.add(new Label(""));
    pNord.add(buttonSauver);
    contentPane.add(pNord, BorderLayout.NORTH);
    contentPane.add(panneauParametres, BorderLayout.CENTER);
    pack();
    centrer();
    setVisible(true);
  }
  
  /**
    * Methode qui retourne les parametres actuels. <p>
    *
    * @return les parametres <b>actuels</b> de la fenetre
    */
  public Parametres getParametres()
  {
    return newParametres;
  }
  
  /**
    * Methode appelee lorsque l'on appuie sur le bouton Ok. <p>
    *
    * Les modifications effectuees sont prises en compte immediatement.
    */
  protected void actionOk()
  {
    if(panneauParametres.accepterParametres(newParametres))
    {
      fenetreMere.setParametres(newParametres);
      fermerFenetre();
    }
    else
      FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
  }
  
  /**
    * Methode appelee lorsque l'on appuie sur le bouton Defaut. <p>
    *
    * Remet les parametres par defaut. <p>
    *
    * @see Simulation.Parametres
    */
  protected void actionDefaut()
  {
    newParametres = new Parametres();
    panneauParametres.setParametre(newParametres);
  }
  
  /**
    * Methode appelee lorsque l'on appuie sur le bouton Charger. <p>
    *
    * Les changements ne sont pris en compte que si on appuie sur Ok.
    */
  protected void actionCharger()
  {
    if(!(this.charger()))
      FenetreDialog.afficher(fenetreMere, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
  }
  
  /**
    * Methode appelee lorsque l'on appuie sur le bouton Sauver. <p>
    *
    * Les changements prendront effet des que l'utilisateur aura clique sur Ok.
    */
  protected void actionSauver()
  {
    if(!(this.sauver()))
      FenetreDialog.afficher(fenetreMere, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
  }
  
  /**
    * Methode appelee lorsque l'on appuie sur le bouton Annuler. <p>
    *
    * Toutes les modifications effectuees ne sont PAS prises en compte.
    */
  protected void actionAnnuler()
  {
    fenetreMere.setParametres(oldParametres);
    fermerFenetre();
  }
  
  /**
    * Charge les parametres. <P>
    *
    * @return
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  private boolean charger()
  {
    String pas = null;
    String nomFichier = null;
    Frame f = new Frame();
    FileDialog fD = new FileDialog(f, Langage.getString("charger") + " " + Langage.getString("parametres"), FileDialog.LOAD);
    fD.setVisible(true);
    if(fD.getFile() != null)
    {
      nomFichier = fD.getDirectory() + fD.getFile();
      fD.dispose();
      f.dispose();
    }
    else
    {
      fD.dispose();
      f.dispose();
      return false;
    }
    if(nomFichier == null)
      return false;
    if(nomFichier.trim().equals(""))
      return false;
    
    // Rappel : les parametres de la fenetre mere ne sont
    
    // modifies que si l'on appuie sur le bouton ok.
    
    // Je ne fais ici que les charger sur le panneau parametres, et c'est
    
    // tout
    newParametres = Parametres.charger(nomFichier);
    if(newParametres != null)
    {
      panneauParametres.setParametre(newParametres);
      return true;
    }
    return false;
  }
  
  /** Pour le bouton annuler. <p> 
    * Permet de ne pas tenir compte des modifications. <p>
    */
  private Parametres oldParametres = null;
  
  // !! ici fenetreMere est une fentre principale, car
  
  // il me faut acceder a sa barre.
  
  // Voir actionOk
  private FenetrePrincipale fenetreMere = null;
  private PanneauParametres panneauParametres = null;
  private Parametres newParametres = null;
  private Button buttonSauver = null;
  private Button buttonCharger = null;
  private Button buttonOk = null;
  private Button buttonDefaut = null;
  private Button buttonAnnuler = null;
}
