package fr.lifl.Aquarium.Ihm;
import java.awt.*;
import javax.swing.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener; // Pour les boutons
import java.awt.event.ActionEvent;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <I>classe</I> represente une fenetre de dialogue. <P>
  *
  * Celle-ci peut apparaitre pour diverse raisons et sont toujours 
  * <i>modales</i>. <P>
  *
  * <b>ATTENTION !</b> Sous certains systemes, HP, SunSolaris vieux modeles,
  * les fenetres de type <i>modale</i> plantent le programme. <p>
  *
  * Derniere modification 18 Decembre 1999 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @version 1.0
  */
public class FenetreDialog extends SuperDialog
{
  
  /**
    * Methode qui retourne l'action effectuee. <p>
    *
    * @return le bouton sur lequel on a clique.
    */
  public int getAction()
  {
    return action;
  }
  
  /**
    * Le constructeur d'une fenetre de dialogue. <P>
    *
    * Une fenetre de Dilaog sera modale par rapport a sa fenetre
    * mere. <p>
    *
    * @param fM la fenetre qui a cree et ouverte cette fenetre (sa fenetre Mere).
    * @param titre le titre de la fenetre de dialogue.
    * @param message le message d'erreur a afficher.
    */
  public FenetreDialog(Frame fM, String titre, String message, int b) 
  {
    super(fM, true);
    setTitle(titre);
    this.setTitle(titre);
    contentPane.setLayout(new BorderLayout());
    label = new JLabel(message, MesIcones.IMG_DIALOG_I, JLabel.CENTER);
    boutonOui = new JButton(Langage.getString("oui"));
    boutonNon = new JButton(Langage.getString("non"));
    boutonOk = new JButton(Langage.getString("ok"));
    boutonOk.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    boutonOui.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOui();
      }
    });
    boutonNon.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionNon();
      }
    });
    
    // Panel Sud
    Panel pSud = new Panel();
    pSud.setLayout(new GridLayout(1, 3, 4, 4));
    if(b == OUI)
    {
      pSud.add(new Label());
      pSud.add(boutonOui);
      pSud.add(new Label());
    }
    if(b == NON)
    {
      pSud.add(new Label());
      pSud.add(boutonNon);
      pSud.add(new Label());
    }
    if(b == OK)
    {
      pSud.add(new Label());
      pSud.add(boutonOk);
      pSud.add(new Label());
    }
    if(b == (OUI + NON))
    {
      pSud.add(boutonOui);
      pSud.add(new Label());
      pSud.add(boutonNon);
    }
    JPanel pCentre = new JPanel();
    pCentre.setLayout(new GridLayout(3, 1, 2, 2));
    pCentre.add(new Label());
    pCentre.add(label);
    pCentre.add(new Label());
    contentPane.add(pSud, BorderLayout.SOUTH);
    contentPane.add(pCentre, BorderLayout.CENTER);
    this.pack();
    centrer();
  }
  
  /**
    * Le constructeur d'une fenetre de dialogue. <P>
    *
    * Une fenetre de Dilaog sera modale par rapport a sa fenetre
    * mere. <p>
    *
    * @param fd la fenetre qui a cree et ouverte cette fenetre (sa fenetre Mere).
    * @param titre le titre de la fenetre de dialogue.
    * @param message le message d'erreur a afficher.
    */
  public FenetreDialog(Dialog fd, String titre, String message, int b) 
  {
    super(fd, true);
    setTitle(titre);
    this.setTitle(titre);
    contentPane.setLayout(new BorderLayout());
    label = new JLabel(message, MesIcones.IMG_DIALOG_I, JLabel.CENTER);
    boutonOui = new JButton(Langage.getString("oui"));
    boutonNon = new JButton(Langage.getString("non"));
    boutonOk = new JButton(Langage.getString("ok"));
    boutonOk.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    boutonOui.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOui();
      }
    });
    boutonNon.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionNon();
      }
    });
    
    // Panel Sud
    Panel pSud = new Panel();
    pSud.setLayout(new GridLayout(1, 3, 4, 4));
    if(b == OUI)
    {
      pSud.add(new Label());
      pSud.add(boutonOui);
      pSud.add(new Label());
    }
    if(b == NON)
    {
      pSud.add(new Label());
      pSud.add(boutonNon);
      pSud.add(new Label());
    }
    if(b == OK)
    {
      pSud.add(new Label());
      pSud.add(boutonOk);
      pSud.add(new Label());
    }
    if(b == (OUI + NON))
    {
      pSud.add(boutonOui);
      pSud.add(new Label());
      pSud.add(boutonNon);
    }
    JPanel pCentre = new JPanel();
    pCentre.setLayout(new GridLayout(3, 1, 2, 2));
    pCentre.add(new Label());
    pCentre.add(label);
    pCentre.add(new Label());
    contentPane.add(pSud, BorderLayout.SOUTH);
    contentPane.add(pCentre, BorderLayout.CENTER);
    this.pack();
    centrer();
  }
  
  /**
    * Methode qui affiche une fenetre de dialogue. <p>
    *
    * @param fM la fenetre qui a cree et ouverte cette fenetre (sa fenetre Mere).
    * @param titre le titre de la fenetre de dialogue.
    * @param message le message d'erreur a afficher.
    */
  public static int afficher(Frame fM, String titre, String message, int b)
  {
    FenetreDialog fd = new FenetreDialog(fM, titre, message, b);
    fd.setVisible(true);
    return fd.getAction();
  }
  
  /**
    * Methode qui affiche une fenetre de dialogue. <p>
    *
    * @param fd la fenetre qui a cree et ouverte cette fenetre (sa fenetre Mere).
    * @param titre le titre de la fenetre de dialogue.
    * @param message le message d'erreur a afficher.
    */
  public static int afficher(Dialog fD, String titre, String message, int b)
  {
    FenetreDialog fd = new FenetreDialog(fD, titre, message, b);
    fd.setVisible(true);
    return fd.getAction();
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Ok. <p>
    */
  protected void actionOk()
  {
    action = OK;
    fermerFenetre();
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Oui. <p>
    */
  protected void actionOui()
  {
    action = OUI;
    fermerFenetre();
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Non. <p>
    */
  protected void actionNon()
  {
    action = NON;
    fermerFenetre();
  }
  public final static int OUI = 1;
  public final static int NON = 3;
  public final static int OK = 5;
  protected int action = -1;
  protected JLabel label = null;
  protected JButton boutonOk = null;
  protected JButton boutonNon = null;
  protected JButton boutonOui = null;
}
