package fr.lifl.Aquarium.Ihm;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente la fenetre qui permet de
  * <i>fabriquer</i> une table de nourritures. <p>
  *
  * On peut sauver/charger/creer une table. <p>
  *
  * <b>ATTENTION</b> la <tt>TableNourriture</tt> est sauvee
  * via la <i>serialisation</i> Java, donc, si on change la classe
  * <tt>TableNourriture.java</tt>, toutes les anciennes 
  * <tt>TableNourriture</tt> anciennement sauvegargees deviendront
  * <b>inutilisables</b>. Ceci est vrai, meme si on ne fait que rajouter une
  * methode a la dite classe. <p>
  * 
  * Derniere modification 22 Decembre 1999 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Simulation.TableNourriture
  * @see fr.lifl.Aquarium.Ihm.FenetreParametre
  *
  * @version 1.0
  */
public class FenetreConfigurerTableNourriture extends SuperDialog
{
  
  /**
    * Constructeur d'une <tt>FenetreConfigurerTableNourriture</tt> .<p>
    *
    * @param fM la fenetre mere.
    */
  public FenetreConfigurerTableNourriture(FenetreParametre fM) 
  {
    super(fM);
    setTitle(Langage.getString("titre_fenetre_conf_table"));
    fenetreMere = fM;
    contentPane.setLayout(new BorderLayout());
    buttonAnnuler = new Button(Langage.getString("annuler"));
    buttonOk = new Button(Langage.getString("ok"));
    buttonCharger = new Button(Langage.getString("charger"));
    buttonSauver = new Button(Langage.getString("sauver"));
    buttonAjouter = new Button(Langage.getString("ajouter"));
    buttonRetirer = new Button(Langage.getString("retirer"));
    tfValeur = new TextField("");
    tfValeur.setBackground(Color.white);
    listType = new List();
    listType.setBackground(Color.white);
    listTableFaite = new List();
    listTableFaite.setBackground(Color.white);
    listCouleur = new List();
    listCouleur.setBackground(Color.white);
    init(); // Remplir les listes
    buttonOk.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    buttonAnnuler.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionAnnuler();
      }
    });
    buttonCharger.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionCharger();
      }
    });
    buttonSauver.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionSauver();
      }
    });
    buttonAjouter.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionAjouter();
      }
    });
    buttonRetirer.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionRetirer();
      }
    });
    Panel pNord = new Panel();
    pNord.setLayout(new GridLayout(1, 3, 4, 4));
    pNord.add(buttonCharger);
    pNord.add(new Label(""));
    pNord.add(buttonSauver);
    Panel pSud = new Panel();
    pSud.setLayout(new GridLayout(1, 3, 4, 4));
    pSud.add(buttonAnnuler);
    pSud.add(new Label(""));
    pSud.add(buttonOk);
    Panel pCentre = new Panel();
    pCentre.setLayout(new GridLayout(2, 1, 2, 2));
    BoiteEntouree beH = new BoiteEntouree(Langage.getString("construisez_votre_nourriture"));
    beH.setLayout(new GridLayout(2, 3, 2, 2));
    beH.add(listType);
    beH.add(listCouleur);
    Panel pas1 = new Panel();
    pas1.setLayout(new GridLayout(3, 1));
    pas1.add(new Label(Langage.getString("valeur")));
    pas1.add(tfValeur);
    pas1.add(new Label(""));
    beH.add(pas1);
    beH.add(new Label(""));
    Panel pas2 = new Panel();
    pas2.setLayout(new GridLayout(3, 1));
    pas2.add(new Label(""));
    pas2.add(buttonAjouter);
    pas2.add(new Label(""));
    beH.add(pas2);
    pCentre.add(beH);
    BoiteEntouree beB = new BoiteEntouree(Langage.getString("la_table_nourriture"));
    beB.setLayout(new GridLayout(2, 1, 2, 2));
    beB.add(listTableFaite);
    Panel pas3 = new Panel();
    pas3.setLayout(new GridLayout(3, 3));
    pas3.add(new Label(""));
    pas3.add(new Label(""));
    pas3.add(new Label(""));
    pas3.add(new Label(""));
    pas3.add(buttonRetirer);
    pas3.add(new Label(""));
    pas3.add(new Label(""));
    pas3.add(new Label(""));
    pas3.add(new Label(""));
    beB.add(pas3);
    pCentre.add(beB);
    contentPane.add(pCentre, BorderLayout.CENTER);
    contentPane.add(pNord, BorderLayout.NORTH);
    contentPane.add(pSud, BorderLayout.SOUTH);
    setTableNourritureToList(fenetreMere.getParametres().getTableNourriture());
    pack();
    centrer();
    setVisible(true);
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Sauver. <p>
    */
  protected void actionSauver()
  {
    if(!sauver())
    {
      Frame f = new Frame();
      FenetreDialog.afficher(f, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
    }
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Retirer. <p>
    */
  protected void actionRetirer()
  {
    int i = 0;
    String s = null;
    try
    {
      s = listTableFaite.getSelectedItem();
      listTableFaite.remove(s);
      while(s.charAt(i) != '\'')
        i++;
      i = i + 1;
      listType.add(s.substring(i, i + 1));
    }
    catch(Exception e)
    {
      return ;
    }
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Ok. <p>
    */
  protected void actionOk()
  {
    if(listTableFaite.getItemCount() != 0)
    {
      fenetreMere.setTableNourriture(setListToTableNourriture());
      fermerFenetre();
    }
    else
      FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Charger. <p>
    */
  protected void actionCharger()
  {
    if(!charger())
    {
      Frame f = new Frame();
      FenetreDialog.afficher(f, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
    }
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Annuler. <p>
    */
  protected void actionAnnuler()
  {
    fermerFenetre();
  }
  
  /**
    * Methode appelee quand on clique sur le bouton Ajouter. <p>
    */
  protected void actionAjouter()
  {
    String couleur = null;
    float valeur = Float.MAX_VALUE;
    String type = null;
    try
    {
      type = listType.getSelectedItem();
      couleur = listCouleur.getSelectedItem();
      valeur = Float.parseFloat(tfValeur.getText());
      if((type != null) && (couleur != null) && (valeur != Float.MAX_VALUE))
      {
        listTableFaite.add("('" + type + "'," + valeur + "," + couleur + ")");
        listType.remove(type);
      }
    }
    catch(Exception e)
    {
      return ;
    }
  }
  
  /**
    * Methode qui s'occupe de sauver une <tt>TableNourriture</tt>. <p>
    *
    * La table sauver est celle representee par la liste 
    * <tt>listTableFaite</tt>. <p>
    *
    * @return 
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  private boolean sauver()
  {
    int i = 0;
    String nomFichier = null;
    Frame f = new Frame();
    FileDialog fD = new FileDialog(f, Langage.getString("sauver") + " " + Langage.getString("table_nourriture"), FileDialog.SAVE);
    fD.setVisible(true);
    if(fD.getFile() != null)
    {
      nomFichier = fD.getDirectory() + fD.getFile();
      fD.dispose();
      f.dispose();
    }
    else
    {
      fD.dispose();
      f.dispose();
      return false;
    }
    if(nomFichier == null)
      return false;
    if(nomFichier.trim().equals(""))
      return false;
    TableNourriture newTableN = setListToTableNourriture();
    if(newTableN.sauver(nomFichier))
      return true;
    return false;
  }
  
  /**
    * Methode qui initialise les <tt>List</tt>. <p>
    */
  private void init()
  {
    int i;
    listType.removeAll();
    listCouleur.removeAll();
    listTableFaite.removeAll();
    for(i = 0;i < TableNourriture.tableType.length;i++)
      listType.add("" + TableNourriture.tableType[i]);
    for(i = 0;i < TableNourriture.tableCouleur.length;i++)
      listCouleur.add(Nourriture.colorToString(TableNourriture.tableCouleur[i]));
  }
  
  /**
    * Methode qui s'occupe de charger une <tt>TableNourriture</tt>. <p>
    *
    * @return 
    * <ul>
    *   <li>true si tout c'est bien passe
    *   <li>false sinon
    * </ul>
    */
  private boolean charger()
  {
    int i;
    String pas = null;
    String nomFichier = null;
    Frame f = new Frame();
    FileDialog fD = new FileDialog(f, Langage.getString("charger") + " " + Langage.getString("table_nourriture"), FileDialog.LOAD);
    fD.setVisible(true);
    if(fD.getFile() != null)
    {
      nomFichier = fD.getDirectory() + fD.getFile();
      fD.dispose();
      f.dispose();
    }
    else
    {
      fD.dispose();
      f.dispose();
      return false;
    }
    if(nomFichier == null)
      return false;
    if(nomFichier.trim().equals(""))
      return false;
    TableNourriture newTableN = null;
    if((newTableN = TableNourriture.charger(nomFichier)) == null)
      return false;
    setTableNourritureToList(newTableN);
    return true;
  }
  
  /**
    * Methode qui transcrit le contenu de <tt>listTableFaite</tt>
    * en <tt>TableNourriture</tt>. <p>
    *
    * @return la table nourriture represente par l'ecran
    */
  private TableNourriture setListToTableNourriture()
  {
    int i, j;
    TableNourriture newTableN = new TableNourriture();
    for(i = 0;i < listTableFaite.getItemCount();i++)
    {
      j = 5;
      String s = listTableFaite.getItem(i);
      while(s.charAt(j) != ',')
        j++; // recherche de la seconde ,
      
      // Construction de l'objet Nourriture
      Nourriture n = new Nourriture(s.substring(2, 3).charAt(0),  /* ('E',0.2555,green)*/ /* 01234567*/Float.parseFloat(s.substring(5, j)));
      n.setCouleur(Nourriture.stringToColor(s.substring(j + 1, s.length() - 1)));
      
      // Ajout de celui ci
      newTableN.putNourriture(n);
    }
    return newTableN;
  }
  ;
  
  /**
    * Methode qui transcrit une <tt>TableNourriture</tt>
    * en <tt>listTableFaite</tt>. <p>
    * 
    * @param tn la <tt>TableNourriture</tt> a transcrire
    */
  private void setTableNourritureToList(TableNourriture tn)
  {
    if(tn == null)
      return ;
    int i;
    Nourriture tab[] = tn.lister();
    try
    {
      init();
      for(i = 0;i < tab.length;i++)
      {
        listTableFaite.add("('" + tab[i].getType() + "'," + tab[i].getValeur() + "," + Nourriture.colorToString(tab[i].getCouleur()) + ")");
        listType.remove("" + tab[i].getType());
      }
    }
    catch(Exception e)
    {
      init();
    }
  }
  private TextField tfValeur = null;
  private Button buttonAnnuler = null;
  private List listType = null;
  private Button buttonOk = null;
  private Button buttonCharger = null;
  private FenetreParametre fenetreMere = null;
  private List listCouleur = null;
  private List listTableFaite = null;
  private Button buttonSauver = null;
  private Button buttonRetirer = null;
  private Button buttonAjouter = null;
}
