package fr.lifl.Aquarium.Ihm;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente la fenetre qui permet de
  * <i>configurer</i> les types de halo. <p>
  *
  * Derniere modification 04 Mars 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Ihm.FenetreParametre
  *
  * @version 1.0
  */
public class FenetreConfigurerHalo extends SuperDialog
{
  
  /**
    * Insert the method's description here.
    * Creation date: (04/03/00 11:32:29)
    */
  public void newMethod()
  {
    
  }
  
  /**
    * FenetreConfigurerHalo constructor comment.
    * @param fd java.awt.Dialog
    */
  public FenetreConfigurerHalo(FenetreParametre fp) 
  {
    super(fp);
    fenetreMere = fp;
    contentPane.setLayout(new BorderLayout());
    setTitle(Langage.getString("bouton_halo"));
    tfMinHalo = new TextField();
    tfMaxHalo = new TextField();
    tfCoeffHalo = new TextField();
    tfNbHaloFixe = new TextField();
    cheDiagonaleOui = new Checkbox(Langage.getString("oui"));
    cheDiagonaleNon = new Checkbox(Langage.getString("non"));
    cheCouleurOui = new Checkbox(Langage.getString("oui"));
    cheCouleurNon = new Checkbox(Langage.getString("non"));
    cheGCouleur = new CheckboxGroup();
    cheGDiagonale = new CheckboxGroup();
    cheCouleurNon.setCheckboxGroup(cheGCouleur);
    cheCouleurOui.setCheckboxGroup(cheGCouleur);
    cheDiagonaleNon.setCheckboxGroup(cheGDiagonale);
    cheDiagonaleOui.setCheckboxGroup(cheGDiagonale);
    bOk = new Button(Langage.getString("ok"));
    bAnnuler = new Button(Langage.getString("annuler"));
    
    // Boutons
    Panel pNord = new Panel();
    pNord.setLayout(new GridLayout(1, 3));
    pNord.add(bAnnuler);
    pNord.add(new Label());
    pNord.add(bOk);
    
    // Diagonale
    BoiteEntouree b1 = new BoiteEntouree(Langage.getString("compter_diagonale"));
    b1.setLayout(new GridLayout(2, 1));
    b1.add(cheDiagonaleOui);
    b1.add(cheDiagonaleNon);
    
    // Couleur
    BoiteEntouree b2 = new BoiteEntouree(Langage.getString("couleur_halo"));
    b2.setLayout(new GridLayout(2, 1));
    b2.add(cheCouleurOui);
    b2.add(cheCouleurNon);
    Panel pSud = new Panel();
    pSud.setLayout(new GridLayout(2, 1));
    pSud.add(b1);
    pSud.add(b2);
    
    // Parametre
    Panel pCentre = new Panel();
    pCentre.setLayout(new GridLayout(4, 2));
    pCentre.add(new Label(Langage.getString("min_halo"), Label.RIGHT));
    pCentre.add(tfMinHalo);
    pCentre.add(new Label(Langage.getString("max_halo"), Label.RIGHT));
    pCentre.add(tfMaxHalo);
    pCentre.add(new Label(Langage.getString("coeff_ajustement_halo"), Label.RIGHT));
    pCentre.add(tfCoeffHalo);
    pCentre.add(new Label(Langage.getString("nb_halo_fixe"), Label.RIGHT));
    pCentre.add(tfNbHaloFixe);
    contentPane.add(pSud, BorderLayout.NORTH);
    contentPane.add(pCentre, BorderLayout.CENTER);
    contentPane.add(pNord, BorderLayout.SOUTH);
    
    // Action
    bOk.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    bAnnuler.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionAnnuler();
      }
    });
    pack();
    centrer();
    setParametres(fp.getParametres());
    setVisible(true);
  }
  
  /**
    * Action activee lorsque l'on clique sur le bouton annuler. <p>
    */
  protected void actionAnnuler()
  {
    fermerFenetre();
  }
  
  /**
    * Methode qui teste si les parametres contenus dans la fenetre sont viables. <p>
    *
    * @return
    * <ul>
    *		<li>true si c'est le cas
    *		<li>false sinon
    *	</ul>
    */
  protected boolean acceptParametres()
  {
    float pas;
    try
    {
      pas = Float.parseFloat(tfCoeffHalo.getText());
      pas = Integer.parseInt(tfNbHaloFixe.getText());
      pas = Integer.parseInt(tfMinHalo.getText());
      pas = Integer.parseInt(tfMaxHalo.getText());
    }
    catch(NumberFormatException nb)
    {
      return false;
    }
    return true;
  }
  
  /**
    * Action activee lorsque l'on clique sur le bouton annuler. <p>
    *
    * C'est a ce moment l, et uniquement si les parametres de la fenetre
    * sont viables, que les parametres vont etres modifies. 
    */
  protected void actionOk()
  {
    if(acceptParametres())
    {
      validerParametres();
      fermerFenetre();
    }
    else
      FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
  }
  
  /**
    * Affiche dans la fenetre uune representation de p. <p>
    *
    * @param p le parametre a representer dans la fenetre
    */
  protected void setParametres(Parametres p)
  {
    if(p != null)
    {
      tfCoeffHalo.setText(String.valueOf(p.getCoeffAjustementHalo()));
      tfMinHalo.setText(String.valueOf(p.getMinHalo()));
      tfMaxHalo.setText(String.valueOf(p.getMaxHalo()));
      tfNbHaloFixe.setText(String.valueOf(p.getNbHaloFixe()));
      if(p.getDiagonal())
      {
        cheDiagonaleOui.setState(true);
        cheDiagonaleNon.setState(false);
      }
      else
      {
        cheDiagonaleNon.setState(true);
        cheDiagonaleOui.setState(false);
      }
      if(p.getCouleurTypeHalo())
      {
        cheCouleurOui.setState(true);
        cheCouleurNon.setState(false);
      }
      else
      {
        cheCouleurNon.setState(true);
        cheCouleurOui.setState(false);
      }
    }
  }
  
  /**
    * Modifie les parametres de la fenetre mere. <p> 
    */
  protected void validerParametres()
  {
    fenetreMere.getParametres().setCoeffAjustementHalo(Float.parseFloat(tfCoeffHalo.getText()));
    fenetreMere.getParametres().setNbHaloFixe(Integer.parseInt(tfNbHaloFixe.getText()));
    fenetreMere.getParametres().setMinHalo(Integer.parseInt(tfMinHalo.getText()));
    fenetreMere.getParametres().setMaxHalo(Integer.parseInt(tfMaxHalo.getText()));
    fenetreMere.getParametres().setDiagonal(cheDiagonaleOui.getState());
    fenetreMere.getParametres().setCouleurTypeHalo(cheCouleurOui.getState());
  }
  private Checkbox cheCouleurOui = null;
  private Checkbox cheDiagonaleOui = null;
  private Button bOk = null;
  private TextField tfMinHalo = null;
  private Button bAnnuler = null;
  private TextField tfNbHaloFixe = null;
  private TextField tfCoeffHalo = null;
  private TextField tfMaxHalo = null;
  private CheckboxGroup cheGDiagonale = null;
  private Checkbox cheDiagonaleNon = null;
  private FenetreParametre fenetreMere = null;
  private Checkbox cheCouleurNon = null;
  private CheckboxGroup cheGCouleur = null;
}
