package fr.lifl.Aquarium.Ihm;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente la fenetre qui permet de
  * <i>composer</i> l'algorithme genetique que l'on desire
  * utiliser. <p>
  *
  * Derniere modification 26 Fevrier 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Ihm.FenetreParametre
  *
  * @version 1.0
  */
public class FenetreConfigurerAlgoGenetic extends SuperDialog
{
  
  /**
    * Constructeur d'une <tt>FenetreConfigurerAlgoGenetic</tt>. <p>
    *
    * @param fp la fenetre parametre mere.
    */
  public FenetreConfigurerAlgoGenetic(FenetreParametre fp) 
  {
    super(fp);
    fenetreMere = fp;
    setTitle(Langage.getString("titre_fenetre_conf_algo"));
    contentPane.setLayout(new BorderLayout());
    
    // Constructeur
    tfTauxMutation = new TextField();
    tfNbMutation = new TextField();
    tfTauxCrossingOver = new TextField();
    tfTailleTranche = new TextField();
    cbgDeuxFils = new CheckboxGroup();
    cbgCrossEtMute = new CheckboxGroup();
    cbDeuxFils = new Checkbox(Langage.getString("deux_fils"));
    cbUnFils = new Checkbox(Langage.getString("un_fils"));
    cbUnFils.setCheckboxGroup(cbgDeuxFils);
    cbDeuxFils.setCheckboxGroup(cbgDeuxFils);
    cbCroosEtMute = new Checkbox(Langage.getString("cross_et_mute"));
    cbNonCroosEtMute = new Checkbox(Langage.getString("cross_non_mute"));
    cbCroosEtMute.setCheckboxGroup(cbgCrossEtMute);
    cbNonCroosEtMute.setCheckboxGroup(cbgCrossEtMute);
    buttonOk = new Button(Langage.getString("ok"));
    buttonAnnuler = new Button(Langage.getString("annuler"));
    
    // Action
    buttonOk.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    buttonAnnuler.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionAnnuler();
      }
    });
    
    // BoiBoites
    BoiteEntouree b1 = new BoiteEntouree(Langage.getString("titre_boite_taux"));
    b1.setLayout(new GridLayout(4, 2, 5, 5));
    b1.add(new Label(Langage.getString("taux_mutation"), Label.RIGHT));
    b1.add(tfTauxMutation);
    b1.add(new Label(Langage.getString("nb_mutation"), Label.RIGHT));
    b1.add(tfNbMutation);
    b1.add(new Label(Langage.getString("taux_crossingOver"), Label.RIGHT));
    b1.add(tfTauxCrossingOver);
    b1.add(new Label(Langage.getString("taille_tranche"), Label.RIGHT));
    b1.add(tfTailleTranche);
    BoiteEntouree b2 = new BoiteEntouree(Langage.getString("titre_boite_enfant"));
    b2.setLayout(new GridLayout(2, 1, 5, 5));
    b2.add(cbUnFils);
    b2.add(cbDeuxFils);
    BoiteEntouree b3 = new BoiteEntouree(Langage.getString("titre_boite_algo"));
    b3.setLayout(new GridLayout(2, 1, 5, 5));
    b3.add(cbCroosEtMute);
    b3.add(cbNonCroosEtMute);
    
    // Panneau central
    Panel pCentre = new Panel();
    pCentre.setLayout(new GridLayout(2, 1, 5, 5));
    Panel pas = new Panel();
    pas.setLayout(new GridLayout(1, 2, 5, 5));
    pas.add(b2);
    pas.add(b3);
    pCentre.add(pas);
    pCentre.add(b1);
    
    // Panneau Sud
    Panel pSud = new Panel();
    pSud.setLayout(new GridLayout(1, 3, 5, 5));
    pSud.add(buttonAnnuler);
    pSud.add(new Label());
    pSud.add(buttonOk);
    
    // Ok
    contentPane.add(pCentre, BorderLayout.CENTER);
    contentPane.add(pSud, BorderLayout.SOUTH);
    setParametres(fenetreMere.getParametres());
    pack();
    centrer();
    setVisible(true);
  }
  
  /**
    * Methode qui teste si les parametres contenus dans la fenetre sont viables. <p>
    *
    * @return
    * <ul>
    *		<li>true si c'est le cas
    *		<li>false sinon
    *	</ul>
    */
  protected boolean acceptParametres()
  {
    int pas;
    try
    {
      pas = Integer.parseInt(tfTailleTranche.getText());
      pas = Integer.parseInt(tfTauxCrossingOver.getText());
      pas = Integer.parseInt(tfTauxMutation.getText());
      pas = Integer.parseInt(tfNbMutation.getText());
    }
    catch(NumberFormatException nb)
    {
      return false;
    }
    return true;
  }
  
  /**
    * Action activee lorsque l'on clique sur le bouton annuler. <p>
    */
  protected void actionAnnuler()
  {
    fermerFenetre();
  }
  
  /**
    * Modifie les parametres de la fenetre mere. <p> 
    */
  protected void validerParametres()
  {
    fenetreMere.getParametres().setTailleTrancheCrossingOver(Integer.parseInt(tfTailleTranche.getText()));
    fenetreMere.getParametres().setTauxCrossingOver(Integer.parseInt(tfTauxCrossingOver.getText()));
    fenetreMere.getParametres().setTauxMutation(Integer.parseInt(tfTauxMutation.getText()));
    fenetreMere.getParametres().setNbMutation(Integer.parseInt(tfNbMutation.getText()));
    fenetreMere.getParametres().setDeuxFils(cbDeuxFils.getState());
    fenetreMere.getParametres().setCrossEtMute(cbCroosEtMute.getState());
  }
  
  /**
    * Action activee lorsque l'on clique sur le bouton annuler. <p>
    *
    * C'est a ce moment l, et uniquement si les parametres de la fenetre
    * sont viables, que les parametres vont etres modifies. 
    */
  protected void actionOk()
  {
    if(acceptParametres())
    {
      validerParametres();
      fermerFenetre();
    }
    else
      FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("format_numerique"), FenetreDialog.OK);
  }
  
  /**
    * Affiche dans la fenetre uune representation de p. <p>
    *
    * @param p le parametre a representer dans la fenetre
    */
  protected void setParametres(Parametres p)
  {
    if(p != null)
    {
      tfTailleTranche.setText(String.valueOf(p.getTailleTrancheCrossingOver()));
      tfTauxCrossingOver.setText(String.valueOf(p.getTauxCrossingOver()));
      tfTauxMutation.setText(String.valueOf(p.getTauxMutation()));
      tfNbMutation.setText(String.valueOf(p.getNbMutation()));
      if(p.getDeuxFils())
      {
        cbDeuxFils.setState(true);
        cbUnFils.setState(false);
      }
      else
      {
        cbUnFils.setState(true);
        cbDeuxFils.setState(false);
      }
      if(p.getCrossEtMute())
      {
        cbCroosEtMute.setState(true);
        cbNonCroosEtMute.setState(false);
      }
      else
      {
        cbNonCroosEtMute.setState(true);
        cbCroosEtMute.setState(false);
      }
    }
  }
  private Checkbox cbCroosEtMute = null;
  private Checkbox cbDeuxFils = null;
  private TextField tfTailleTranche = null;
  
  // Gadgets
  private TextField tfTauxMutation = null;
  private Checkbox cbUnFils = null;
  private Button buttonAnnuler = null;
  private TextField tfTauxCrossingOver = null;
  private TextField tfNbMutation = null;
  private CheckboxGroup cbgCrossEtMute = null;
  private Button buttonOk = null;
  private Checkbox cbNonCroosEtMute = null;
  private FenetreParametre fenetreMere = null;
  private CheckboxGroup cbgDeuxFils = null;
}
