package fr.lifl.Aquarium.Ihm;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Erreur;
import java.awt.*;
import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
  * Cette <i>classe</i> represente la fenetre d'information sur les auteurs de ce logiciel. <p>
  *
  * Derniere modification 16 Mars 2000 <br>
  *
  * @author
  * <ul>
  *   <li>Hiblot Sebastien
  *   <li><a href="mailto:muriel_vidonne@yahoo.fr">Vidonne Muriel</a>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a>
  * </ul>
  */
public class FenetreAPropos extends SuperDialog
{
  
  /**
    * FenetreAPropos constructor comment.
    * @param fM java.awt.Frame
    */
  public FenetreAPropos(Frame fM) 
  {
    super(fM);
    setTitle(Langage.getString("a_propos"));
    contentPane.setLayout(new BorderLayout());
    texte = new TextArea(8, 45);
    texte.setEditable(false);
    texte.append("Authors/Auteurs :\n");
    texte.append("\tFerret Renaud - renaud91@hotmail.com\n");
    texte.append("\tVidonne Muriel - muriel_vidonne@yahoo.fr\n");
    texte.append("\tHiblot Sebastien\n");
    texte.append("Aide par/helped by :\n");
    texte.append("\tPhillipe Mathieu - mathieu@lifl.fr\n");
    texte.append("\tBeaufils Bruno - beaufils@lifl.fr");
    ok = new Button(Langage.getString("ok"));
    ok.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOk();
      }
    });
    Panel p = new Panel(new GridLayout(1, 3));
    p.add(new Label(""));
    p.add(ok);
    p.add(new Label(""));
    contentPane.add(texte, BorderLayout.CENTER);
    contentPane.add(p, BorderLayout.SOUTH);
    pack();
    centrer();
  }
  
  /**
    * Action qui se declenche quand on clique sur le bouton Ok. <p>
    */
  protected void actionOk()
  {
    fermerFenetre();
  }
  private Button ok = null;
  private TextArea texte = null;
}
