package fr.lifl.Aquarium.Simulation;
import java.io.Serializable;

/**
  * La <i>classe</i> compteur. <P>
  *
  * Derniere modification 22 Janvier 2000
  *
  * @author
  *   <ul>  
  *     <li>Hiblot Sebastien (V1.0)
  *     <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  *   </ul>
  *
  * @version 1.1
  */
public class Compteur implements Serializable,Cloneable
{
  
  /**
    * Constructeur d'un objet <tt>Compteur</tt>. <P>
    *
    * La valeur initiale du compteur est <b>zero</b>
    */
  public Compteur() 
  {
    val = 0;
  }
  
  /**
    * Constructeur d'un objet <tt>Compteur</tt>. <P>
    *
    * @param a la valeur initiale du compteur
    */
  public Compteur(int a) 
  {
    val = a;
  }
  
  /**
    * Methode qui retourne une copie de l'objet. <p>
    *
    * @return une copie de l'objet.
    */
  public Object clone()
  {
    return new Compteur(this.val);
  }
  
  /**
    * Methode qui initialise la valeur du <tt>Compteur</tt>. <P>
    */
  public void init()
  {
    val = 0;
  }
  
  /**
    * Methode qui incremente le <tt>Compteur</tt> et retourne la valeur de
    * celui ci. <P>
    *
    * @return la valeur courante du <tt>Compteur</tt> apres incrementation
    */
  public int inc()
  {
    val++;
    return val;
  }
  
  /**
    * Methode qui transforme un <tt>Compteur</tt> en une
    * <tt>String</tt>. <p>
    *
    * @return une <tt>String</tt> representant un <tt>Compteur</tt>
    */
  public String toString()
  {
    return new String("[" + val + "]");
  }
  
  /**
    * Methode qui retourne la valeur du <tt>Compteur</tt>. <P>
    *
    * @return la valeur courante du <tt>Compteur</tt>
    */
  public final int getValeur()
  {
    return val;
  }
  
  /** La valeur du <tt>Compteur</tt>. <p> */
  protected int val;
}
