package fr.lifl.Aquarium.Ihm;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import java.awt.Dimension;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente une <i>JComboBox</i> qui va se charger 
  * d'afficher la <code>TableNourriture</code>. <p>
  *
  * Le mode d'affichage est defini dans la class Ihm.CelluleNourriture. <p>
  *
  * Derniere modification 20 Decembre 1999 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Ihm.CelluleNourriture
  *
  * @version 1.0
  */
public class ComboNourriture extends JComboBox
{
  
  /**
    * Constructeur d'une ComboNourriture. <p>
    *
    * @param tN la <code>TableNourriture</code> qui sera affichee.
    */
  public ComboNourriture(TableNourriture tN) 
  {
    this();
    addTableNourriture(tN);
  }
  
  /**
    * Methode qui ajoute une <code>TableNourriture</code>. <P>
    *
    * @param tN la <code>TableNourriture</code> a ajouter.
    */
  public void addTableNourriture(TableNourriture tN)
  {
    if(tN == null)
      return ;
    int i;
    Nourriture tab[] = tN.lister();
    if(this.getItemCount() != 0)
      this.removeAllItems();
    if(tab.length >= 2)
      addItem(Langage.getString("melange"));
    
    // Ajout dans le sens inverse, a cause de la Hashtable.
    for(i = tab.length - 1;i >= 0;i--)
      addItem(tab[i]);
  }
  
  /**
    * Constructeur d'une ComboNourriture. <p>
    */
  public ComboNourriture() 
  {
    super();
    setRenderer(new CelluleNourriture());
  }
}
