package fr.lifl.Aquarium.Ihm;
import javax.swing.event.*;
import javax.swing.*;
import java.awt.*;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Nourriture;

/**
  * Cette <i>classe</i> explicite comment doit etre affiche le
  * contenu d'une <code>ComboNourriture</code>. <p>
  *
  * Derniere modification 20 Decembre 1999 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  * @see fr.lifl.Aquarium.Ihm.ComboNourriture
  *
  * @version 1.0
  */
public class CelluleNourriture extends JLabel implements ListCellRenderer
{
  
  /**
    * Rendu d'une cellule. <p>
    */
  public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
  {
    if(value == null)
      return this;
    Nourriture t = new Nourriture('=');
    if(value.getClass().getName().equals(t.getClass().getName()))
    {
      Nourriture n = (Nourriture)value;
      setText("'" + n.getType() + "', " + n.getValeur());
      setIcon(MesIcones.getCouleur(n.getCouleur()));
    }
    else
      if((value.getClass().getName().equals("java.lang.String")) && (value.toString().equals(Langage.getString("melange"))))
      {
        setText(value.toString());
        setIcon(MesIcones.IMG_COULEURS[13]);
      }
      else
      {
        setText(value.toString());
        setIcon(MesIcones.IMG_AIDE);
      }
    setBackground(isSelected ? Color.gray : Color.lightGray);
    setForeground(isSelected ? Color.white : Color.black);
    return this;
  }
  
  /**
    * Constructeur d'une <code>CelluleNourriture</code>. <p>
    */
  public CelluleNourriture() 
  {
    setOpaque(true);
  }
}
