package fr.lifl.Aquarium.Ihm;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

/**
  * Cette <I>classe</I> represente les boites entourees par un trait. <P>
  *
  * Derniere modification 01 juin 1999 <br>
  *
  * @author
  *	<ul>
  *		<li><A HREF="mailto:renaud91@hotmail.com">Ferret Renaud</A>
  *	</ul>
  * 
  * @version V1.0
  */
public class BoiteEntouree extends JPanel
{
  
  /**
    * Constructeur d'une boite entouree. <P>
    *
    * @param titre le titre de la boite.
    * @param couleurTexte la couleur du titre.
    */
  public BoiteEntouree(String titre, Color couleurTexte) 
  {
    super();
    if(couleurTexte == null)
      couleurTexte = Color.black;
    maBordure = new EtchedBorder();
    maBordureTitree = new TitledBorder(maBordure, " " + titre + " ", TitledBorder.LEFT, TitledBorder.TOP, null, couleurTexte);
    this.setBorder(maBordureTitree);
    this.setOpaque(true);
  }
  
  /**
    * Constructeur d'une boite entouree. <P>
    *
    * La couleur par defaut est le noir. <P>
    *
    * Il est preferable de donner un titre aux boites. <P>
    */
  public BoiteEntouree() 
  {
    this("");
  }
  
  /**
    * Le constructeur d'une boite entouree. <P>
    *
    * La couleur par defaut est le noir. <p>
    *
    * @param titre le titre de la boite.
    */
  public BoiteEntouree(String titre) 
  {
    this(titre, Color.black);
  }
  
  /**
    * Methode qui donne un titre a la boite. <P>
    *
    * @param titre le nouveau titre de la boite.
    */
  public void setLabel(String titre)
  {
    if(titre != null)
      maBordureTitree.setTitle(titre);
  }
  private TitledBorder maBordureTitree = null;
  private EtchedBorder maBordure = null;
}
