package fr.lifl.Aquarium.Ihm;
import javax.swing.JToolBar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import java.io.Serializable;
import java.io.File;
import java.awt.event.ActionListener; // Pour les boutons
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import java.awt.Checkbox;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.Langage;

/**
  * Cette <i>classe</i> represente la barre d'outils de la
  * <tt>FenetrePrincipale</tt>. <p>
  *
  * Il est <b>tres</b> important de comprendre la gestion des evenements
  * ici, c'est la <tt>fenetreMere</tt> (c.a.d la <tt>FenetrePrincipale</tt>)
  * qui <b>execute</b> les actions, la barre d'outils ne fait que 
  * <b>signaler</b> a la <tt>FenetrePrincipale</tt> qu'une action a ete
  * levee. <p>
  * 
  * Derniere modification 23 Janvier 2000 <br>
  *
  * @author
  * <ul>
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V1.++)
  * </ul>
  *
  *
  * @see fr.lifl.Aquarium.Ihm.FenetrePrincipale
  *
  * @version 1.2
  */
public class BarreOutilsPrincipale extends JToolBar
{
  
  /**
    * Methode qui remplit la combo contenant la nourriture. <p>
    *
    * @param tn la table des nourritures.
    */
  public void remplirComboNourriture(TableNourriture tn)
  {
    if(tn != null)
      cNourriture.addTableNourriture(tn);
  }
  
  /**
    * Methode qui place la simulation en pause. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void pause()
  {
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER)
    {
      boutonLancer.setEnabled(true);
      boutonOuvrir.setEnabled(false);
      boutonEnregistrer.setEnabled(true);
      boutonLancer.setToolTipText(Langage.getString("continuer"));
      boutonAccelerer.setEnabled(false);
      boutonPause.setEnabled(false);
      boutonArreter.setEnabled(true);
    }
  }
  
  /**
    * Methode qui lance la simulation. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void lancer()
  {
    boutonLancer.setEnabled(false);
    boutonOuvrir.setEnabled(false);
    boutonEnregistrer.setEnabled(false);
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.PAUSE)
    {
      boutonLancer.setToolTipText(Langage.getString("lancer"));
      boutonAccelerer.setEnabled(true);
      boutonPause.setEnabled(true);
      boutonArreter.setEnabled(true);
    }
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
    {
      boutonAccelerer.setEnabled(true);
      boutonPause.setEnabled(true);
      boutonArreter.setEnabled(true);
    }
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.ACCELERER)
    {
      boutonLancer.setToolTipText(Langage.getString("lancer"));
      boutonAccelerer.setEnabled(true);
      boutonPause.setEnabled(true);
      boutonArreter.setEnabled(true);
    }
  }
  
  /**
    * Retourne la taille du pinceau choisie. <p>
    *
    * @return la taille du pinceau choisie, dans le cas d'uniforme
    * l'entier retourne sera -1.
    */
  public int getTaillePinceau()
  {
    int resu = -1; // pour Uniforme
    String quoi = cTaillePinceau.getSelectedItem().toString();
    if(quoi.startsWith(Langage.getString("uniforme")))
      return resu;
    try
    {
      resu = Integer.parseInt(quoi.substring(0, quoi.length() - 4));
    }
    catch(NumberFormatException n)
    {
      resu = -1;
    }
    return resu;
  }
  
  /**
    * Retourne la quantite de nourriture choisie. <p>
    *
    * @return la quantite de nourriture choisie.
    */
  public int getQuantiteNourriture()
  {
    int resu = 100;
    Object o = cQuantiteNourriture.getSelectedItem();
    if(o == null)
      return resu;
    String quoi = o.toString();
    if(quoi == null)
      return resu;
    try
    {
      resu = Integer.parseInt(quoi);
    }
    catch(NumberFormatException ne)
    {
      ;
    }
    return resu;
  }
  
  /**
    * Retourne le type de nourriture choisi. <p>
    *
    * @return le type de la nourriture choisi, dans le cas du melange
    * le charactere retourne sera '*'.
    */
  public char getNourriture()
  {
    char resu = '*'; // pour melange
    Object o = cNourriture.getSelectedItem();
    if(o == null)
      return resu;
    String quoi = o.toString();
    if(quoi == null)
      return resu;
    if(quoi.startsWith(Langage.getString("melange")))
      return resu;
    return quoi.charAt(2);
  }
  
  /**
    * Methode qui arrete la simulation. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void arreter()
  {
    if((GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER) || (GestionSimulation.ETAT_COURANT == GestionSimulation.PAUSE) || (GestionSimulation.ETAT_COURANT == GestionSimulation.ACCELERER))
    {
      boutonLancer.setToolTipText(Langage.getString("lancer"));
      boutonLancer.setEnabled(true);
      boutonOuvrir.setEnabled(true);
      boutonEnregistrer.setEnabled(false);
      boutonAccelerer.setEnabled(false);
      boutonPause.setEnabled(false);
      boutonArreter.setEnabled(false);
    }
  }
  
  /**
    * Constructeur d'une barre d'outils principale. <P>
    *
    * @param fM la fenetre principale a laquelle elle va appartenir.
    */
  public BarreOutilsPrincipale(FenetrePrincipale fM) 
  {
    super();
    fenetreMere = fM;
    boutonOuvrir = new JButton(MesIcones.IMG_OUVRIR);
    boutonOuvrir.setToolTipText(Langage.getString("charger"));
    boutonEnregistrer = new JButton(MesIcones.IMG_SAUVER);
    boutonEnregistrer.setToolTipText(Langage.getString("enregistrer"));
    boutonLancer = new JButton(MesIcones.IMG_LANCER);
    boutonLancer.setToolTipText(Langage.getString("lancer"));
    boutonAccelerer = new JButton(MesIcones.IMG_ACCELERER);
    boutonAccelerer.setToolTipText(Langage.getString("accelerer"));
    boutonPause = new JButton(MesIcones.IMG_PAUSE);
    boutonPause.setToolTipText(Langage.getString("pause"));
    boutonArreter = new JButton(MesIcones.IMG_ARRETER);
    boutonArreter.setToolTipText(Langage.getString("arreter"));
    boutonParametre = new JButton(MesIcones.IMG_PARAMETRE);
    boutonParametre.setToolTipText(Langage.getString("parametres"));
    boutonInformation = new JButton(MesIcones.IMG_AIDE);
    boutonInformation.setToolTipText(Langage.getString("information"));
    cNourriture = new ComboNourriture(fenetreMere.getParametres().getTableNourriture());
    cNourriture.setToolTipText(Langage.getString("nourrire_avec"));
    cTaillePinceau = new JComboBox();
    cTaillePinceau.addItem(Langage.getString("uniforme"));
    int i;
    for(i = 0;i < valeursPinceaux.length;i++)
      cTaillePinceau.addItem(String.valueOf(valeursPinceaux[i]) + " pts");
    cTaillePinceau.setToolTipText(Langage.getString("pinceau"));
    cQuantiteNourriture = new JComboBox();
    for(i = 0;i < quantiteNourriture.length;i++)
      cQuantiteNourriture.addItem(String.valueOf(quantiteNourriture[i]));
    cQuantiteNourriture.setToolTipText(Langage.getString("quantite_nourriture"));
    cQuantiteNourriture.setSelectedItem("200");
    chkNourrire = new Checkbox(Langage.getString("nourrire_automatiquement"), true);
    chkNourrire.setBackground(this.getBackground());
    chkNourrire.addItemListener(new ItemListener() 
    {
      public void itemStateChanged(ItemEvent e)
      {
        GestionSimulation.NOURRIRE_MANUELLEMENT = chkNourrire.getState();
      }
    });
    
    // Evenements
    boutonOuvrir.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionOuvrir();
      }
    });
    boutonEnregistrer.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionEnregistrer();
      }
    });
    boutonLancer.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionLancer();
      }
    });
    boutonAccelerer.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionAccelerer();
      }
    });
    boutonPause.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionPause();
      }
    });
    boutonArreter.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionArreter();
      }
    });
    boutonParametre.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionParametre();
      }
    });
    boutonInformation.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionInformation();
      }
    });
    cNourriture.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionNourriture();
      }
    });
    cTaillePinceau.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionNourriture();
      }
    });
    cQuantiteNourriture.addActionListener(new ActionListener() 
    {
      public void actionPerformed(ActionEvent e)
      {
        actionNourriture();
      }
    });
    setFloatable(false);
    add(boutonOuvrir);
    add(boutonEnregistrer);
    addSeparator();
    add(boutonLancer);
    add(boutonAccelerer);
    add(boutonPause);
    add(boutonArreter);
    addSeparator();
    add(boutonParametre);
    addSeparator();
    add(boutonInformation);
    addSeparator();
    add(cTaillePinceau);
    add(cNourriture);
    add(cQuantiteNourriture);
    addSeparator();
    add(chkNourrire);
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    addSeparator();
    boutonAccelerer.setEnabled(false);
    boutonPause.setEnabled(false);
    boutonArreter.setEnabled(false);
    boutonEnregistrer.setEnabled(false);
    setPreferredSize(null);
  }
  
  /**
    * Methode qui accelere la simulation en desactivant l'affichage. <p>
    *
    * <b>Attention !</b> : Cette methode est appellee <u>exclusivement</u>
    * par la fenetre mere. <p>
    */
  public void accelerer()
  {
    if(GestionSimulation.ETAT_COURANT == GestionSimulation.LANCER)
    {
      boutonLancer.setEnabled(true);
      boutonOuvrir.setEnabled(false);
      boutonEnregistrer.setEnabled(false);
      boutonLancer.setToolTipText(Langage.getString("vitesse_normal"));
      boutonAccelerer.setEnabled(false);
      boutonPause.setEnabled(false);
      boutonArreter.setEnabled(true);
    }
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Pause. <p>
    */
  protected void actionPause()
  {
    fenetreMere.pause();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Parametre. <p>
    */
  protected void actionParametre()
  {
    fenetreMere.afficheParametre();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Ouvrir. <p>
    */
  protected void actionOuvrir()
  {
    fenetreMere.charger();
  }
  
  /**
    * Methode lancee lorsque l'on choisit une Nourriture
    * ou une taille de pinceau. <p>
    */
  protected void actionNourriture()
  {
    PisteGraphique.TAILLE_PINCEAU = getTaillePinceau();
    PisteGraphique.TYPE_NOURRITURE = getNourriture();
    PisteGraphique.QUANTITE_NOURRITURE = getQuantiteNourriture();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Lancer. <p>
    */
  protected void actionLancer()
  {
    fenetreMere.lancer();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Enregistrer. <p>
    */
  protected void actionEnregistrer()
  {
    fenetreMere.sauver();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Arreter. <p>
    */
  protected void actionArreter()
  {
    fenetreMere.arreter();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Accelerer. <p>
    */
  protected void actionAccelerer()
  {
    fenetreMere.accelerer();
  }
  
  /**
    * Methode lancee lorsque l'on choisit le bouton Fonctionnement. <p>
    */
  protected void actionInformation()
  {
    fenetreMere.informer();
  }
  
  /** La fenetre mere de la barre d'outils principale. <p> */
  protected FenetrePrincipale fenetreMere = null;
  private ComboNourriture cNourriture = null;
  private JComboBox cTaillePinceau = null;
  private JButton boutonInformation = null;
  private JButton boutonParametre = null;
  private JButton boutonPause = null;
  private JButton boutonLancer = null;
  private JButton boutonOuvrir = null;
  private JButton boutonEnregistrer = null;
  private JButton boutonArreter = null;
  private Checkbox chkNourrire = null;
  private JButton boutonAccelerer = null;
  private JComboBox cQuantiteNourriture = null;
  private final int quantiteNourriture[] = 
  {
    50, 100, 150, 200, 500, 1000
  };
  private final int valeursPinceaux[] = 
  {
    1, 5, 10, 15, 20, 25
  };
  
  /** Valeur en pixel d'un espace. <p> */
  private final static int espace = 20;
}
