package fr.lifl.Aquarium.Simulation;
import javax.swing.*;
import java.util.*;
import java.awt.*;

/**
  *
  * Cette <i>classe</i> permet de definir l'objet <tt>Aquarium</tt> 
  * qui va gerer les vers. <P>
  *
  * L'<tt>Aquarium</tt> contient aussi le <tt>PisteGraphique</tt> qui va montrer a
  * l'utilisateur ce qui ce passe. <p>
  *
  * C'est aussi l'<tt>Aquarium</tt> qui se charge de deplacer les <tt>Ver</tt> et de les faire evoluer. <p>
  *
  * Derniere modification 10 Mars 2000. <p>
  *
  * @author
  * <ul>
  *   <li>Hiblot Sebastien (V1.0)
  *   <li><a href="mailto:muriel_vidonne@yahoo.fr">Vidonne Muriel</a> (V1.5) (V2.5)
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V2.6)
  * </ul>
  *
  * @version 2.6
  *
  * @see fr.lifl.Aquarium.Simulation.Ver
  * @see fr.lifl.Aquarium.Simulation.ListeVer
  * @see fr.lifl.Aquarium.Simulation.Parametres
  * @see fr.lifl.Aquarium.Simulation.PisteGraphique
  * @see fr.lifl.Aquarium.Simulation.Piste
  * @see fr.lifl.Aquarium.Ihm.FenetrePrincipale
  */
public class AquariumGraphique extends Aquarium implements Runnable
{
  
  /**
    * Constructeur de la classe Aquarium. <P>
    */
  public AquariumGraphique() 
  {
    super();
  }
  
  /**
    * Constructeur de la classe Aquarium. <P>
    *
    * @param p les parametres.
    */
  public AquariumGraphique(Parametres p) 
  {
    this(p, new PisteGraphique(p.getTaillePiste()));
  }
  
  /**
    * Constructeur de la classe Aquarium. <P>
    *
    * @param piste la <tt>PisteGraphique</tt>  de l'aquarium
    * @param p les parametres.
    */
  public AquariumGraphique(Parametres p, PisteGraphique piste) 
  {
    
    // Pas de copie ici
    generation = 0;
    parametres = p;
    pisteGraphique = piste;
    this.piste = piste.getPiste();
    pisteGraphique.entourrer();
    pisteGraphique.lierTableNourriture(p.getTableNourriture());
  }
  
  /**
    * Methode qui fabrique une liste de <tt>Ver</tt>. <p>
    *
    * Les <tt>Ver</tt> sont generes aleatoirement. <p>
    *
    * Par defaut le nombre de <tt>Ver</tt> a generer est
    * celui contenu dans <tt>parametres</tt>. <p>
    */
  public void creerVers()
  {
    creerVers(parametres.getNbVer());
  }
  
  /**
    * Methode qui fabrique une liste de <tt>Ver</tt>. <p>
    *
    * Les <tt>Ver</tt> sont generes aleatoirement. <p>
    *
    * @param combien le nombre de <tt>Ver</tt> a generer.
    */
  public void creerVers(int combien)
  {
    int i;
    Ver v;
    if(listeVer == null)
      listeVer = new ListeVer(combien);
    if(parametres.getNbHaloFixe() < 0)
    { // on cre des vers avec un type de halo tir de facon alatoire :
      for(i = 0;i < combien;i++)
      {
        v = new Ver(pisteGraphique, parametres.getCas(), parametres.getTailleVer());
        listeVer.addVer(v);
      }
    }
    else
    {
      
      // on cre un certain nb de vers avec un halo fixe :	    
      int c = (combien * parametres.getNbHaloFixe()) / 100;
      creerVers(c, Genotype.HALO_FIXE);
      
      // et les autres avec un halo proportionnel :
      creerVers(combien - c, Genotype.HALO_PROPORTIONNEL);
    }
  }
  
  /**
    * Methode indique que la <i>vie</i> peut demarrer dans
    * l'aquarium . <P>
    */
  public void run()
  {
    jeu(parametres.getDeuxFils(), parametres.getCrossEtMute());
  }
  
  /**
    * Fonction permettant de jouer. <P>
    *
    * Le gestion des deplacements, de mutations et crossing over se
    * fait ici.  Cette version permet d'utiliser diffrents algorithmes gntiques. <p>
    *
    * @param deuxFils 
    * <ul>
    *		<li>vrai si le crossing over engendre 2 fils
    *		<li>faux s'il n'en engendre qu'un.
    *	</ul>
    * @param crossEtMute
    *	<ul>
    *		<li>vrai si on applique  la fois la mutation et le crossing over sur les nouveaux vers.
    *		<li>faux si l'on applique la mutation sur certains vers et le crossing sur d'autres.
    *	</ul>
    */
  public void jeu(boolean deuxFils, boolean crossEtMute)
  {
    int i, j;
    int nbVer, aTuer;
    if(listeVer == null)
      return ;
    pisteGraphique.affichePiste(parametres.getTableNourriture(), listeVer);
    while(GestionSimulation.ETAT_COURANT != GestionSimulation.ARRETER)
    {
      System.out.println("|-----> Generation " + generation);
      if(((generation % parametres.getPeriodeSevrage()) == 0) && (GestionSimulation.NOURRIRE_MANUELLEMENT))
        pisteGraphique.mousePressed(null);
      synchronized(pisteGraphique)
      {
        pisteGraphique.repaint();
      }
      listeVer.incAllGeneration();
      i = parametres.getPeriodeEvolution();
      if(i != 0)
      {
        while(i >= 0)
        {
          if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
            break;
          for(j = 0;j < listeVer.getSize();j++)
          {
            if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
              break;
            listeVer.getVer(j).deplacer(parametres.getTableNourriture(), pisteGraphique, parametres.getCoutDeplacement(), parametres.getCoeffAjustementHalo());
          }
          pisteGraphique.repaint();
          try
          {
            Thread.sleep(parametres.vitesse);
          }
          catch(Exception alo)
          {
            System.err.println(Erreur.getString("erreur_aquariumgraphique_jeu"));
          }
          i--;
        }
      }
      
      // Cas de la periode infinie => parametres.getPeriodeEvolution() = 0
      else
      {
        if(i == 0)
        {
          while(i == 0)
          {
            if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
              break;
            for(j = 0;j < listeVer.getSize();j++)
            {
              if(GestionSimulation.ETAT_COURANT == GestionSimulation.ARRETER)
                break;
              listeVer.getVer(j).deplacer(parametres.getTableNourriture(), pisteGraphique, parametres.getCoutDeplacement(), parametres.getCoeffAjustementHalo());
            }
            pisteGraphique.repaint();
            try
            {
              Thread.sleep(parametres.vitesse);
            }
            catch(Exception alo)
            {
              System.err.println(Erreur.getString("erreur_aquariumgraphique_jeu"));
            }
          }
        }
      }
      
      // Tuons les vers "mauvais"
      nbVer = listeVer.getSize();
      aTuer = (nbVer * parametres.getNbVerTue()) / 100;
      if(listeVer.getSize() >= 2)
      {
        synchronized(listeVer)
        {
          listeVer.quickSort();
        }
        synchronized(listeVer)
        {
          listeVer.tuerVers(aTuer, pisteGraphique);
        }
        
        // Effectuons les mutations et le crossing over :
        synchronized(listeVer)
        {
          listeVer.evolution(parametres, pisteGraphique, aTuer, deuxFils, crossEtMute);
        }
      }
      
      // Si on est en mode texte :
      if(GestionSimulation.TEXT)
      {
        
        // Affichons les informations
        synchronized(listeVer)
        {
          System.out.println(listeVer.informer());
        }
        
        // il faut afficher l'etat de ma liste
        synchronized(listeVer)
        {
          System.out.println(listeVer);
        }
      }
      
      // a chaque generation on reinitialise le niveau de vie
      synchronized(listeVer)
      {
        listeVer.initVie();
      }
      generation++;
    }
    init();
  }
  
  /**
    * Initialise un <tt>Aquarium</tt>. <p>
    */
  public void init()
  {
    if(listeVer != null)
      listeVer.tuerTous(pisteGraphique);
    pisteGraphique.initAll();
    pisteGraphique.entourrer();
    generation = 0;
  }
  
  /** 
    * Methode qui fabrique une liste de combien <tt>Ver</tt> avec pour
    * type de halo typeHalo. <p>
    *
    * Les <tt>Ver</tt> sont generes aleatoirement, sauf leur halo. <p>
    *
    * @param combien le nombre de <tt>Ver</tt> a generer.
    * @param typeHalo le type de halo des vers crs
    */
  public void creerVers(int combien, char typeHalo)
  {
    int i;
    if(listeVer == null)
      listeVer = new ListeVer(combien);
    for(i = 0;i < combien;i++)
    {
      Ver v = new Ver(pisteGraphique, parametres.getCas(), parametres.getTailleVer(), typeHalo);
      listeVer.addVer(v);
    }
  }
  
  /**
    * Methode qui selectionne une experience. <p>
    *
    * @param t le numero de l'experience.
    *
    * @return un descriptif de l'experience.
    */
  public final String experienceType(int t)
  {
    this.init();
    Ver v = null;
    StringBuffer info = new StringBuffer();
    int n = Generateur.tirerIntEntre(100);
    int nbHaloFixe = parametres.getNbHaloFixe();
    int i;
    switch(t)
    {
      
      // Cas normal
      case 0:
        creerVers(parametres.getNbVer());
        pisteGraphique.placerNourriture(100, parametres.getTableNourriture());
        info.append(Langage.getString("tout_hazard"));
        break;
      
      
      // Experience 1
      case 1:
        this.creerVers(parametres.getNbVer() - 1);
        
        // Si l'on veut un ver parfait
        v = new Ver(pisteGraphique, null, parametres.getCas(), parametres.getTailleVer(), true, parametres.getTableNourriture());
        if(nbHaloFixe != -1)
        {
          if(n < nbHaloFixe)
            v.getGenotype().setTypeHalo(Genotype.HALO_FIXE);
          else
            v.getGenotype().setTypeHalo(Genotype.HALO_PROPORTIONNEL);
        }
        v.setColor(Color.red);
        listeVer.addVer(v);
        
        // Placons la bouf
        pisteGraphique.placerNourriture(100, parametres.getTableNourriture());
        info.append(Langage.getString("tout_un_malin_tous_betes"));
        break;
      
      
      // Experience 2
      case 2:
        
        // Si l'on veut un ver parfait
        v = new Ver(pisteGraphique, null, parametres.getCas(), parametres.getTailleVer(), true, parametres.getTableNourriture());
        if(nbHaloFixe != -1)
        {
          if(n < nbHaloFixe)
            v.getGenotype().setTypeHalo(Genotype.HALO_FIXE);
          else
            v.getGenotype().setTypeHalo(Genotype.HALO_PROPORTIONNEL);
        }
        v.setColor(Color.red);
        listeVer.addVer(v);
        info.append(Langage.getString("un_malin_tout_seul"));
        break;
      
      case 3:
        int nbP, nbF;
        nbF = parametres.getNbVer() / 2;
        nbP = parametres.getNbVer() - nbF;
        creerVers(nbF, Genotype.HALO_FIXE);
        creerVers(nbP, Genotype.HALO_PROPORTIONNEL);
        info.append("????");
        break;
      
      case 4:
        
        /*for (i = 0; i < parametres.getNbVer(); i++)
        {
        v = new Ver(pisteGraphique, null, parametres.getCas(), parametres.getTailleVer(), true, parametres.getTableNourriture());
        if (nbHaloFixe != -1)
        {
        if (n < nbHaloFixe)
        v.getGenotype().setTypeHalo(Genotype.HALO_FIXE);
        else
        v.getGenotype().setTypeHalo(Genotype.HALO_PROPORTIONNEL);
        }
        listeVer.addVer(v);
        }*/
        n = (nbHaloFixe * parametres.getNbVer()) / 100;
        for(i = 0;i < n;i++)
        {
          v = new Ver(pisteGraphique, null, parametres.getCas(), parametres.getTailleVer(), Genotype.HALO_FIXE, true, parametres.getTableNourriture());
          listeVer.addVer(v);
        }
        for(i = n;i < parametres.getNbVer();i++)
        {
          v = new Ver(pisteGraphique, null, parametres.getCas(), parametres.getTailleVer(), Genotype.HALO_PROPORTIONNEL, true, parametres.getTableNourriture());
          listeVer.addVer(v);
        }
        info.append(Langage.getString("tous_intelligent"));
        break;
      
      case 5:
        int rX = 2;
        int rY = 10;
        Nourriture best = parametres.getTableNourriture().getBestNourriture();
        Point tete = new Point(piste.getTailleX() / 4, piste.getTailleY() / 4);
        v = new Ver(pisteGraphique, tete, parametres.getCas(), 5, true, parametres.getTableNourriture());
        v.getGenotype().setTailleHalo(Genotype.MAX_TAILLE_HALO);
        v.getGenotype().setTypeHalo(Genotype.HALO_PROPORTIONNEL);
        
        // Retirer le corps de la piste
        for(i = 0;i < 5;i++)
          pisteGraphique.setCaseVide((Point)v.getPosition().elementAt(i));
        
        // Fabriquer le nouveau
        Vector position = new Vector();
        position.add(tete);
        position.add(new Point(tete.x, tete.y + 1));
        position.add(new Point(tete.x, tete.y + 2));
        position.add(new Point(tete.x, tete.y + 3));
        position.add(new Point(tete.x, tete.y + 4));
        v.setPosition(position);
        
        // Ajouter le nouveau corps a la piste
        for(i = 0;i < 5;i++)
          pisteGraphique.setCaseVide((Point)position.elementAt(i));
        v.setDirection(Ver.FACE);
        
        // Dessin de l'eprouvette
        
        // socle
        pisteGraphique.creerMur(tete.x - rX, tete.y - rY, tete.x + rX, tete.y - rY);
        
        // bord Gauche
        pisteGraphique.creerMur(tete.x - rX, tete.y - rY, tete.x - rX, tete.y + 30);
        
        // bord droit
        pisteGraphique.creerMur(tete.x + rX, tete.y - rY, tete.x + rX, tete.y + 30);
        
        // Bouffe
        pisteGraphique.placerNourriture(tete.x, tete.y - rY / 2, best);
        listeVer.addVer(v);
        info.append(Langage.getString("eprouvette"));
        break;
    }
    return info.toString();
  }
  
  /**
    * Modifie les parametres associes a l'<tt>Aquarium</tt>. <p>
    * 
    * @param p les nouveaux parametres associes a l'<tt>Aquarium</tt>
    */
  public final void setParametres(Parametres p)
  {
    parametres = p;
    pisteGraphique.lierTableNourriture(p.getTableNourriture());
  }
  
  /**
    *
    */
  public final void setAquarium(Aquarium a)
  {
    if(a != null)
    {
      pisteGraphique.setPiste(a.piste);
      listeVer = a.listeVer;
      parametres = a.parametres;
      generation = a.generation;
    }
  }
  
  /**
    * Methode qui modifie la <tt>PisteGraphique</tt>. <P>
    *
    * @param piste la nouvelle <tt>PisteGraphique</tt> du jeu
    */
  public final void setPisteGraphique(PisteGraphique piste)
  {
    if(listeVer != null)
      listeVer.tuerTous(pisteGraphique);
    pisteGraphique = piste;
    pisteGraphique.entourrer();
    pisteGraphique.lierTableNourriture(parametres.getTableNourriture());
  }
  
  /**
    * Methode qui retourne la <tt>PisteGraphique</tt>. <P>
    *
    * @return la <tt>PisteGraphique</tt> du jeu
    */
  public final PisteGraphique getPisteGraphique()
  {
    return pisteGraphique;
  }
  
  /**
    * Permet de lancer une simulation en mode <b>texte</b> uniquement. <p>
    * 
    * Le lancement ce fait avec les arguments suivant :
    * <ul>
    * 	<li>args[2] : parametres = nom fichier d'un objet Parametres serialise
    * 	<li>args[3] : place = nom fichier d'un objet PisteGraphique serialise
    * 	<li>args[4] : list = nom fichier d'un objet ListeVer serialise
    *	</ul>
    */
  public static void main(String[] args)
  {
    Parametres p = null;
    PisteGraphique pisteGraphique = null;
    ListeVer listeVer = null;
    
    // Cette ligne est tres importante, sinon, la PisteGraphique va
    
    // faire des repaint() sur quelque chose qui n'existe pas !
    GestionSimulation.ETAT_COURANT = GestionSimulation.ACCELERER;
    GestionSimulation.TEXT = true;
    if(args != null)
    {
      
      // Parametres
      if(args.length > 2)
        p = Parametres.charger(args[2]);
      else
        p = new Parametres();
      pisteGraphique = new PisteGraphique(p.getTaillePiste());
      
      // Piste
      if(args.length > 3)
      {
        Piste piste = Piste.charger(args[3]);
        if(piste != null)
          pisteGraphique.setPiste(piste);
      }
      
      // Liste ver
      if(args.length > 4)
        listeVer = ListeVer.charger(args[4]);
      AquariumGraphique a = new AquariumGraphique(p, pisteGraphique);
      if(listeVer != null)
        a.setListeVer(listeVer);
      else
        a.creerVers();
      a.jeu(true, true);
    }
  }
  
  /** L'aire de jeu. <p> */
  protected PisteGraphique pisteGraphique = null;
}
