package fr.lifl.Aquarium.Simulation;
import java.util.*;
import java.io.*;

/**
  *
  * Cette <i>classe</i> permet de definir l'objet <tt>Aquarium</tt>. <P>
  *
  * Derniere modification 02 Mars 2000. <p>
  *
  * @author
  * <ul>
  *   <li>Hiblot Sebastien (V1.0)
  *   <li><a href="mailto:muriel_vidonne@yahoo.fr">Vidonne Muriel</a> (V1.5) (V2.4)
  *   <li><a href="mailto:renaud91@hotmail.com">Ferret Renaud</a> (V2.5)
  * </ul>
  *
  * @version 2.5
  *
  * @see fr.lifl.Aquarium.Simulation.Ver
  * @see fr.lifl.Aquarium.Simulation.ListeVer
  * @see fr.lifl.Aquarium.Simulation.Parametres
  * @see fr.lifl.Aquarium.Simulation.PisteGraphique
  * @see fr.lifl.Aquarium.Simulation.Piste
  * @see fr.lifl.Aquarium.Ihm.FenetrePrincipale
  */
public class Aquarium implements Serializable
{
  
  /**
    * Transforme un objet <tt>Aquarium</tt> en une <tt>String</tt>. <p>
    *
    * @return une <tt>String</tt> representant un <tt>Aquarium</tt>.
    */
  public String toString()
  {
    StringBuffer s = new StringBuffer();
    s.append('\n');
    s.append(listeVer);
    s.append('\n');
    s.append(parametres);
    s.append('\n');
    s.append(piste);
    return s.toString();
  }
  
  /**
    * Sauve le contenu de l'aquarium. <p>
    *
    * @param nom le nom du fichier qui va contenir l'aquarium serialise
    *
    * @return
    *	<ul>
    *		<li>true si tout c'est bien passe
    *		<li>false sinon
    *	</ul>
    */
  public boolean sauver(String nom)
  {
    int i = 0;
    if((nom == null) && (nomFichier == null))
      return false;
    if(nom.trim().equals(""))
      return false;
    if((nom != null) && (nomFichier == null))
      nomFichier = nom;
    try
    {
      boolean ok = true;
      ok = ok && parametres.sauver(nomFichier + ".par");
      ok = ok && piste.sauver(nomFichier + ".pis");
      ok = ok && listeVer.sauver(nomFichier + ".lis");
      ok = ok && sauverGeneration(nomFichier);
      if(!ok)
        System.err.println(Erreur.getString("erreur_aquarium_sauver"));
    }
    catch(Exception e)
    {
      e.printStackTrace();
      System.err.println(Erreur.getString("erreur_aquarium_sauver"));
      return false;
    }
    return true;
  }
  
  /**
    * Constructeur d'un objet <tt>Aquarium</tt>. <p>
    */
  public Aquarium() 
  {
    super();
  }
  
  /**
    * Methode qui modifie la <tt>ListeVer</tt> de l'<tt>Aquarium</tt>. <p>
    *
    * Attention : aucune copie n'est realisee. <p>
    *
    * @param la nouvelle liste des <tt>Ver</tt> contenus dans l'<tt>Aquarium</tt>
    */
  public final void setListeVer(ListeVer l)
  {
    listeVer = l;
  }
  
  /**
    * Modifie le nom sous lequel l'aquarium sera sauve. <p>
    * 
    * @param nom le nouveau nom du fichier qui contiendra l'aquarium serialise.
    */
  public final void setNomFichier(String nom)
  {
    nomFichier = nom;
  }
  
  /**
    * Methode qui retourne la piste de l'<tt>Aquarium</tt>. <p>
    * 
    * @return la piste associee a l'<tt>Aquarium</tt>
    */
  public final Piste getPiste()
  {
    return piste;
  }
  
  /**
    * Methode qui retourne les parametres associes a l'<tt>Aquarium</tt>. <p>
    * 
    * @return les parametres associes a l'<tt>Aquarium</tt>
    */
  public final Parametres getParametres()
  {
    return parametres;
  }
  
  /**
    * Retourne le nom de fichier qui contient l'aquarium serialise. <p>
    * 
    * @return le nom de fichier qui contient l'aquarium serialise
    */
  public final String getNomFichier()
  {
    return nomFichier;
  }
  
  /**
    * Methode qui retourne la <tt>ListeVer</tt> de l'<tt>Aquarium</tt>. <p>
    *
    * @return la liste des <tt>Ver</tt> contenus dans l'<tt>Aquarium</tt>
    */
  public final ListeVer getListeVer()
  {
    if(listeVer == null)
      listeVer = new ListeVer();
    return listeVer;
  }
  
  /**
    * Charge un <tt>Aquarium</tt> serialise. <P>
    *
    *	La methode tente de charger :
    *	<ul>
    *		<li>un fichier <tt>nomFichier.par</tt> qui contient les parametres
    *		<li>un fichier <tt>nomFichier.pis</tt> qui contient la piste
    *		<li>un fichier <tt>nomFichier.lis</tt> qui contient la liste des vers
    *		<li>un fichier <tt>nomFichier</tt> qui contient le numero de la generation
    *	</ul>
    *
    * @param nomFichier le nom du fichier d'ou charger l'aquarium
    *
    * @return
    * <ul>
    *   <li>l'<tt>Aquarium</tt> contenu dans le fichier
    *   <li>null sinon
    * </ul>
    */
  public static Aquarium charger(String nomFichier)
  {
    if(nomFichier == null)
      return null;
    if(nomFichier.trim().equals(""))
      return null;
    Aquarium a = null;
    try
    {
      a = new Aquarium();
      a.listeVer = ListeVer.charger(nomFichier + ".lis");
      a.piste = Piste.charger(nomFichier + ".pis");
      a.parametres = Parametres.charger(nomFichier + ".par");
      a.generation = Aquarium.chargerGeneration(nomFichier);
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_aquarium_charger"));
      return null;
    }
    return a;
  }
  
  /**
    * Charge un <tt>Aquarium</tt> serialise. <P>
    *
    * @param nomPiste le nom du fichier d'ou charger la <tt>Piste</tt> de l'aquarium
    * @param nomListeVer le nom du fichier d'ou charger la <tt>ListeVer</tt> de l'aquarium
    *
    * @return
    * <ul>
    *   <li>l'<tt>Aquarium</tt> constuit  partir des deux fichiers
    *   <li>null si aucun <b>des deux</b> fichiers n'a ete trouve
    * </ul>
    */
  public static Aquarium charger(String nomPiste, String nomListeVer)
  {
    if((nomPiste == null) && (nomListeVer == null))
      return null;
    if((nomPiste.trim().equals("")) && (nomListeVer.trim().equals("")))
      return null;
    if((nomPiste.trim().equals("Default")) || (nomListeVer.trim().equals("Default")))
      return null;
    Aquarium a = null;
    try
    {
      a = new Aquarium();
      a.listeVer = ListeVer.charger(nomListeVer);
      a.piste = Piste.charger(nomPiste);
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_aquarium_charger"));
      return null;
    }
    return a;
  }
  
  /**
    * Sauve le numero de la generation. <p>
    *
    * @param nom le nom du fichier qui va contenir le numero de la generation
    *
    * @return
    *	<ul>
    *		<li>true si tout c'est bien passe
    *		<li>false sinon
    *	</ul>
    */
  private final boolean sauverGeneration(String nom)
  {
    int i = 0;
    if(nom == null)
      return false;
    if(nom.trim().equals(""))
      return false;
    try
    {
      FileOutputStream fichierOuvert = new FileOutputStream(nom);
      ObjectOutputStream out = new ObjectOutputStream(fichierOuvert);
      out.writeObject(new Integer(generation));
      out.flush();
      out.close();
      fichierOuvert.close();
    }
    catch(Exception e)
    {
      e.printStackTrace();
      System.err.println(Erreur.getString("erreur_aquarium_sauver"));
      return false;
    }
    return true;
  }
  
  /**
    * Charge le numero de la generation. <p>
    *
    * @param nom le nom du fichier qui contient le numero de la generation
    *
    * @return le numero de la generation
    */
  private final static int chargerGeneration(String nom)
  {
    if(nom == null)
      return 0;
    if(nom.trim().equals(""))
      return 0;
    try
    {
      FileInputStream fichierOuvert = new FileInputStream(nom);
      ObjectInputStream in = new ObjectInputStream(fichierOuvert);
      Integer i = (Integer)in.readObject();
      in.close();
      fichierOuvert.close();
      if(i != null)
        return i.intValue();
    }
    catch(Exception e)
    {
      System.err.println(Erreur.getString("erreur_aquarium_sauver"));
    }
    return 0;
  }
  
  /** Contient les <tt>Ver</tt> qui <i>vivront</i> sur l'aire de jeu. <p> */
  protected ListeVer listeVer = null;
  
  /** La derniere generation. <p> */
  protected int generation;
  
  /** Les parametres du jeu. <p> */
  protected Parametres parametres = null;
  
  /** L'aire de jeu. <p> */
  protected Piste piste = null;
  
  /** Le nom de fichier qui contiendra l'aquarium serialise. <p> */
  protected String nomFichier = null;
}
