/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Generateur;
import fr.lifl.Aquarium.Simulation.Genotype;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Piste;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import fr.lifl.Aquarium.Simulation.TableCompteur;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;

public class Ver
implements Serializable,
Cloneable {
    public static boolean DIAGONALE = false;
    public static final char BAS = 'B';
    public static final char FACE = 'F';
    public static final char GAUCHE = 'G';
    public static final int VIE_PAR_DEFAUT = 150;
    public static final char DROITE = 'D';
    protected int nbGeneration = 0;
    protected Genotype genotype = null;
    protected char direction;
    protected TableCompteur tableCompteur = null;
    protected Vector position = null;
    protected float vie = 0.0f;

    /*
     * Enabled aggressive block sorting
     */
    public void deplacer(TableNourriture tableNourriture, PisteGraphique pisteGraphique, float f, float f2) {
        String string = null;
        string = this.vision(DIAGONALE, tableNourriture, pisteGraphique.getPiste(), f2);
        String string2 = this.genotype.getAdn().getValeurGene(string);
        if (string2 == null) {
            System.err.println(Erreur.getString("erreur_ver_deplacer"));
            return;
        }
        Point point = this.getTete();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            block0 : switch (c) {
                case 'F': {
                    switch (this.direction) {
                        case 'F': {
                            if (!this.bouger(point.x, point.y - 1, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)70;
                            return;
                        }
                        case 'B': {
                            if (!this.bouger(point.x, point.y + 1, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)66;
                            return;
                        }
                        case 'D': {
                            if (!this.bouger(point.x + 1, point.y, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)68;
                            return;
                        }
                        case 'G': {
                            if (!this.bouger(point.x - 1, point.y, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)71;
                            return;
                        }
                    }
                    break;
                }
                case 'D': {
                    switch (this.direction) {
                        case 'F': {
                            if (!this.bouger(point.x + 1, point.y, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)68;
                            return;
                        }
                        case 'B': {
                            if (!this.bouger(point.x - 1, point.y, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)71;
                            return;
                        }
                        case 'D': {
                            if (!this.bouger(point.x, point.y + 1, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)66;
                            return;
                        }
                        case 'G': {
                            if (!this.bouger(point.x, point.y - 1, tableNourriture, f, pisteGraphique)) break block0;
                            this.direction = (char)70;
                            return;
                        }
                    }
                    break;
                }
                case 'G': {
                    switch (this.direction) {
                        case 'F': {
                            if (!this.bouger(point.x - 1, point.y, tableNourriture, f, pisteGraphique)) break;
                            this.direction = (char)71;
                            return;
                        }
                        case 'B': {
                            if (!this.bouger(point.x + 1, point.y, tableNourriture, f, pisteGraphique)) break;
                            this.direction = (char)68;
                            return;
                        }
                        case 'D': {
                            if (!this.bouger(point.x, point.y - 1, tableNourriture, f, pisteGraphique)) break;
                            this.direction = (char)70;
                            return;
                        }
                        case 'G': {
                            if (!this.bouger(point.x, point.y + 1, tableNourriture, f, pisteGraphique)) break;
                            this.direction = (char)66;
                            return;
                        }
                    }
                    break;
                }
            }
            ++n;
        }
    }

    public void tuerVer(PisteGraphique pisteGraphique) {
        Point point = null;
        int n = 0;
        while (n < this.position.size()) {
            point = (Point)this.position.elementAt(n);
            pisteGraphique.setCaseVide(point);
            ++n;
        }
        this.position.removeAllElements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n[ ");
        stringBuffer.append(Langage.getString("vie"));
        stringBuffer.append("=");
        stringBuffer.append(this.vie);
        stringBuffer.append(", ");
        stringBuffer.append(Langage.getString("generation"));
        stringBuffer.append("=");
        stringBuffer.append(this.nbGeneration);
        stringBuffer.append(",\n");
        if (this.getTete() != null) {
            stringBuffer.append(Langage.getString("tete"));
            stringBuffer.append("=(");
            stringBuffer.append(this.getTete().x);
            stringBuffer.append(", ");
            stringBuffer.append(this.getTete().y);
            stringBuffer.append("),\n");
        }
        stringBuffer.append(Langage.getString("genotype"));
        stringBuffer.append("=");
        stringBuffer.append(this.genotype);
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public Ver(PisteGraphique pisteGraphique, String string, int n) {
        this(pisteGraphique, null, string, n, false, null);
    }

    public Ver(PisteGraphique pisteGraphique, Point point, String string, int n, boolean bl, TableNourriture tableNourriture) {
        this.position = new Vector(n);
        this.genotype = new Genotype(n, string);
        this.vie = 150.0f;
        this.tableCompteur = new TableCompteur(string);
        if (tableNourriture != null && bl) {
            this.genotype.getAdn().rendreAdnParfait(tableNourriture);
        }
        if (point != null) {
            this.position.add(point);
        }
        this.creerCorpsVer(pisteGraphique);
    }

    public void setTaille(int n) {
        this.genotype.setTailleVer(n);
    }

    public Ver(String string, int n) {
        this.position = new Vector(n);
        this.genotype = new Genotype(n, string);
        this.vie = 150.0f;
        this.tableCompteur = new TableCompteur(string);
    }

    public Ver(PisteGraphique pisteGraphique, String string, int n, char c) {
        this(pisteGraphique, null, string, n, c, false, null);
    }

    public Object clone() {
        Ver ver = new Ver();
        ver.position = (Vector)this.position.clone();
        ver.vie = this.vie;
        ver.nbGeneration = this.nbGeneration;
        ver.genotype = (Genotype)this.genotype.clone();
        ver.direction = this.direction;
        ver.tableCompteur = (TableCompteur)this.tableCompteur.clone();
        return ver;
    }

    public Ver(PisteGraphique pisteGraphique, Point point, String string, int n, char c, boolean bl, TableNourriture tableNourriture) {
        this.position = new Vector(n);
        this.genotype = new Genotype(n, c, string);
        this.vie = 150.0f;
        this.tableCompteur = new TableCompteur(string);
        if (tableNourriture != null && bl) {
            this.genotype.getAdn().rendreAdnParfait(tableNourriture);
        }
        if (point != null) {
            this.position.add(point);
        }
        this.creerCorpsVer(pisteGraphique);
    }

    public void setTaille(int n, PisteGraphique pisteGraphique) {
        this.genotype.setTailleVer(n);
        if (this.position != null) {
            if (n >= this.position.size()) {
                int n2 = n - this.position.size();
                int n3 = n;
                while (n3 != 0) {
                    Point point = this.getQueue();
                    if (pisteGraphique.caseEstTraversable(point.x + 1, point.y)) {
                        this.position.addElement(new Point(point.x + 1, point.y));
                        --n3;
                        continue;
                    }
                    if (pisteGraphique.caseEstTraversable(point.x, point.y + 1)) {
                        this.position.addElement(new Point(point.x + 1, point.y + 1));
                        --n3;
                        continue;
                    }
                    if (pisteGraphique.caseEstTraversable(point.x, point.y - 1)) {
                        this.position.addElement(new Point(point.x, point.y - 1));
                        --n3;
                        continue;
                    }
                    if (!pisteGraphique.caseEstTraversable(point.x - 1, point.y)) continue;
                    this.position.addElement(new Point(point.x - 1, point.y));
                    --n3;
                }
                return;
            }
            if (n < this.position.size()) {
                int n4 = this.position.size() - n;
                while (n4 != 0) {
                    Point point = this.getQueue();
                    pisteGraphique.setCaseVide(point);
                    this.position.remove(this.getQueue());
                    --n4;
                }
            }
        }
    }

    public Ver(PisteGraphique pisteGraphique, Point point, String string, int n) {
        this(pisteGraphique, point, string, n, false, null);
    }

    public final Color getColor() {
        return this.genotype.getCouleur();
    }

    public final void incGeneration() {
        ++this.nbGeneration;
    }

    public final void setColor(Color color) {
        if (this.genotype != null) {
            this.genotype.setCouleur(color);
        }
    }

    public final void setVie(float f) {
        this.vie = f;
    }

    public final Point getQueue() {
        Point point = null;
        try {
            point = (Point)this.position.lastElement();
        }
        catch (Exception exception) {
            return null;
        }
        return point;
    }

    public final char getDirection() {
        return this.direction;
    }

    public final float getVie() {
        return this.vie;
    }

    public final int getTaille() {
        return this.genotype.getTailleVer();
    }

    public final void setDirection(char c) {
        this.direction = c;
    }

    public final Vector getPosition() {
        return this.position;
    }

    public final void setGenotype(Genotype genotype) {
        this.genotype = genotype;
    }

    public final void updateVie(float f) {
        this.vie += f;
    }

    public final void setPosition(Vector vector) {
        if (this.position != null) {
            this.position.removeAllElements();
        }
        this.position = vector;
        this.setTaille(vector.size());
    }

    public final Point getTete() {
        Point point = null;
        try {
            point = (Point)this.position.firstElement();
        }
        catch (Exception exception) {
            return null;
        }
        return point;
    }

    public final Genotype getGenotype() {
        return this.genotype;
    }

    protected String voirGauche(boolean bl, Piste piste) {
        int n = this.genotype.getTailleHalo();
        Point point = this.getTete();
        this.tableCompteur.initAll();
        switch (this.direction) {
            case 'F': {
                int n2 = 1;
                while (n2 <= n) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.compterCas(point.x - n2, point.y - n3, piste);
                        ++n3;
                    }
                    ++n2;
                }
                if (!bl) break;
                n2 = 1;
                while (n2 <= n) {
                    this.compterCas(point.x - n2, point.y - n2, piste);
                    ++n2;
                }
                break;
            }
            case 'D': {
                int n4 = 1;
                while (n4 <= n) {
                    int n5 = 0;
                    while (n5 < n4) {
                        this.compterCas(point.x + n5, point.y - n4, piste);
                        ++n5;
                    }
                    ++n4;
                }
                if (!bl) break;
                n4 = 1;
                while (n4 <= n) {
                    this.compterCas(point.x + n4, point.y - n4, piste);
                    ++n4;
                }
                break;
            }
            case 'B': {
                int n6 = 1;
                while (n6 <= n) {
                    int n7 = 0;
                    while (n7 < n6) {
                        this.compterCas(point.x + n6, point.y + n7, piste);
                        ++n7;
                    }
                    ++n6;
                }
                if (!bl) break;
                n6 = 1;
                while (n6 <= n) {
                    this.compterCas(point.x + n6, point.y + n6, piste);
                    ++n6;
                }
                break;
            }
            case 'G': {
                int n8 = 1;
                while (n8 <= n) {
                    int n9 = 0;
                    while (n9 < n8) {
                        this.compterCas(point.x - n9, point.y + n8, piste);
                        ++n9;
                    }
                    ++n8;
                }
                if (!bl) break;
                n8 = 1;
                while (n8 <= n) {
                    this.compterCas(point.x - n8, point.y + n8, piste);
                    ++n8;
                }
                break;
            }
        }
        if (this.tableCompteur.tousAZeroSaufI()) {
            return "I";
        }
        return this.tableCompteur.getMax();
    }

    protected String voirDroite(boolean bl, Piste piste) {
        int n = this.genotype.getTailleHalo();
        Point point = this.getTete();
        this.tableCompteur.initAll();
        switch (this.direction) {
            case 'F': {
                int n2 = 1;
                while (n2 <= n) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.compterCas(point.x + n2, point.y - n3, piste);
                        ++n3;
                    }
                    ++n2;
                }
                if (!bl) break;
                n2 = 1;
                while (n2 <= n) {
                    this.compterCas(point.x + n2, point.y - n2, piste);
                    ++n2;
                }
                break;
            }
            case 'D': {
                int n4 = 1;
                while (n4 <= n) {
                    int n5 = 0;
                    while (n5 < n4) {
                        this.compterCas(point.x + n5, point.y + n4, piste);
                        ++n5;
                    }
                    ++n4;
                }
                if (!bl) break;
                n4 = 1;
                while (n4 <= n) {
                    this.compterCas(point.x + n4, point.y + n4, piste);
                    ++n4;
                }
                break;
            }
            case 'B': {
                int n6 = 1;
                while (n6 <= n) {
                    int n7 = 0;
                    while (n7 < n6) {
                        this.compterCas(point.x - n6, point.y + n7, piste);
                        ++n7;
                    }
                    ++n6;
                }
                if (!bl) break;
                n6 = 1;
                while (n6 <= n) {
                    this.compterCas(point.x - n6, point.y + n6, piste);
                    ++n6;
                }
                break;
            }
            case 'G': {
                int n8 = 1;
                while (n8 <= n) {
                    int n9 = 0;
                    while (n9 < n8) {
                        this.compterCas(point.x - n9, point.y - n8, piste);
                        ++n9;
                    }
                    ++n8;
                }
                if (!bl) break;
                n8 = 1;
                while (n8 <= n) {
                    this.compterCas(point.x - n8, point.y - n8, piste);
                    ++n8;
                }
                break;
            }
        }
        if (this.tableCompteur.tousAZeroSaufI()) {
            return "I";
        }
        return this.tableCompteur.getMax();
    }

    protected char trouverDirection() {
        if (this.position == null) {
            return this.tirerDirection();
        }
        if (this.position.size() < 2) {
            return this.tirerDirection();
        }
        Point point = this.getTete();
        Point point2 = (Point)this.position.elementAt(1);
        if (point2.x == point.x) {
            if (point2.y > point.y) {
                return 'F';
            }
            return 'B';
        }
        if (point2.y == point.y) {
            if (point2.x > point.x) {
                return 'G';
            }
            return 'D';
        }
        return this.tirerDirection();
    }

    protected void manger(Point point, TableNourriture tableNourriture, Piste piste) {
        this.manger(point.x, point.y, tableNourriture, piste);
    }

    protected char tirerDirection() {
        int n = Generateur.tirerIntEntre(4);
        switch (n) {
            case 0: {
                return 'D';
            }
            case 1: {
                return 'G';
            }
            case 2: {
                return 'F';
            }
            case 3: {
                return 'B';
            }
        }
        return 'D';
    }

    protected String voirFace(Piste piste) {
        int n = this.genotype.getTailleHalo();
        Point point = this.getTete();
        this.tableCompteur.initAll();
        switch (this.direction) {
            case 'F': {
                int n2 = 1;
                while (n2 <= n) {
                    this.compterCas(point.x, point.y - n2, piste);
                    ++n2;
                }
                n2 = 1;
                while (n2 <= n) {
                    int n3 = n2;
                    while (n3 <= n) {
                        this.compterCas(point.x + n2, point.y - n3, piste);
                        this.compterCas(point.x - n2, point.y - n3, piste);
                        ++n3;
                    }
                    ++n2;
                }
                break;
            }
            case 'D': {
                int n4 = 1;
                while (n4 <= n) {
                    this.compterCas(point.x + n4, point.y, piste);
                    ++n4;
                }
                n4 = 1;
                while (n4 <= n) {
                    int n5 = n4;
                    while (n5 <= n) {
                        this.compterCas(point.x + n5, point.y + n4, piste);
                        this.compterCas(point.x + n5, point.y - n4, piste);
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 'B': {
                int n6 = 1;
                while (n6 <= n) {
                    this.compterCas(point.x, point.y + n6, piste);
                    ++n6;
                }
                n6 = 1;
                while (n6 <= n) {
                    int n7 = n6;
                    while (n7 <= n) {
                        this.compterCas(point.x + n6, point.y + n7, piste);
                        this.compterCas(point.x - n6, point.y + n7, piste);
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 'G': {
                int n8 = 1;
                while (n8 <= n) {
                    this.compterCas(point.x - n8, point.y, piste);
                    ++n8;
                }
                n8 = 1;
                while (n8 <= n) {
                    int n9 = n8;
                    while (n9 <= n) {
                        this.compterCas(point.x - n9, point.y + n8, piste);
                        this.compterCas(point.x - n9, point.y - n8, piste);
                        ++n9;
                    }
                    ++n8;
                }
                break;
            }
        }
        if (this.tableCompteur.tousAZeroSaufI()) {
            return "I";
        }
        return this.tableCompteur.getMax();
    }

    protected void creerCorpsVer(PisteGraphique pisteGraphique) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        Point point = null;
        if (this.position.size() != 0) {
            point = this.getTete();
        }
        if (point == null) {
            while (!bl) {
                n = Generateur.tirerIntEntre(pisteGraphique.getTailleX());
                n2 = Generateur.tirerIntEntre(pisteGraphique.getTailleY());
                bl = pisteGraphique.caseEstTraversable(n, n2);
            }
            point = new Point(n, n2);
            this.position.add(point);
        }
        pisteGraphique.setCaseVer(point.x, point.y, this.genotype.getCouleur());
        this.direction = this.tirerDirection();
        int n4 = this.direction;
        int n5 = 0;
        while (n3 != this.getTaille() && n3 != 0) {
            Point point2 = this.getQueue();
            switch (n4) {
                case 68: {
                    if (pisteGraphique.caseEstTraversable(point2.x + 1, point2.y)) {
                        this.position.add(new Point(point2.x + 1, point2.y));
                        pisteGraphique.setCaseVer(point2.x + 1, point2.y, this.genotype.getCouleur());
                        ++n3;
                        break;
                    }
                    if (n5 >= 4) {
                        this.retirerNouvelleTete(pisteGraphique);
                        return;
                    }
                    n4 = 71;
                    ++n5;
                    break;
                }
                case 71: {
                    if (pisteGraphique.caseEstTraversable(point2.x - 1, point2.y)) {
                        this.position.add(new Point(point2.x - 1, point2.y));
                        pisteGraphique.setCaseVer(point2.x - 1, point2.y, this.genotype.getCouleur());
                        ++n3;
                        break;
                    }
                    if (n5 >= 4) {
                        this.retirerNouvelleTete(pisteGraphique);
                        return;
                    }
                    n4 = 70;
                    ++n5;
                    break;
                }
                case 70: {
                    if (pisteGraphique.caseEstTraversable(point2.x, point2.y - 1)) {
                        this.position.add(new Point(point2.x, point2.y - 1));
                        pisteGraphique.setCaseVer(point2.x, point2.y - 1, this.genotype.getCouleur());
                        ++n3;
                        break;
                    }
                    if (n5 >= 4) {
                        this.retirerNouvelleTete(pisteGraphique);
                        return;
                    }
                    n4 = 66;
                    ++n5;
                    break;
                }
                case 66: {
                    if (pisteGraphique.caseEstTraversable(point2.x, point2.y + 1)) {
                        this.position.add(new Point(point2.x, point2.y + 1));
                        pisteGraphique.setCaseVer(point2.x, point2.y + 1, this.genotype.getCouleur());
                        ++n3;
                        break;
                    }
                    if (n5 >= 4) {
                        this.retirerNouvelleTete(pisteGraphique);
                        return;
                    }
                    n4 = 68;
                    ++n5;
                }
            }
        }
        this.direction = this.trouverDirection();
    }

    protected void manger(int n, int n2, TableNourriture tableNourriture, Piste piste) {
        char c = piste.getCase(n, n2);
        float f = tableNourriture.getValeurNourriture(c);
        this.updateVie(f);
    }

    protected boolean bouger(Point point, TableNourriture tableNourriture, float f, PisteGraphique pisteGraphique) {
        return this.bouger(point.x, point.y, tableNourriture, f, pisteGraphique);
    }

    protected String voirDroite(int n, boolean bl, Piste piste) {
        Point point = this.getTete();
        this.tableCompteur.initAll();
        switch (this.direction) {
            case 'F': {
                int n2 = 0;
                while (n2 < n) {
                    this.compterCas(point.x + n, point.y - n2, piste);
                    ++n2;
                }
                if (!bl) break;
                this.compterCas(point.x + n, point.y - n, piste);
                break;
            }
            case 'D': {
                int n3 = 0;
                while (n3 < n) {
                    this.compterCas(point.x + n3, point.y + n, piste);
                    ++n3;
                }
                if (!bl) break;
                this.compterCas(point.x + n, point.y + n, piste);
                break;
            }
            case 'B': {
                int n4 = 0;
                while (n4 < n) {
                    this.compterCas(point.x - n, point.y + n4, piste);
                    ++n4;
                }
                if (!bl) break;
                this.compterCas(point.x - n, point.y + n, piste);
                break;
            }
            case 'G': {
                int n5 = 0;
                while (n5 < n) {
                    this.compterCas(point.x - n5, point.y - n, piste);
                    ++n5;
                }
                if (!bl) break;
                this.compterCas(point.x - n, point.y - n, piste);
            }
        }
        if (this.tableCompteur.tousAZeroSaufI()) {
            return "I";
        }
        return this.tableCompteur.getMax();
    }

    protected boolean bouger(int n, int n2, TableNourriture tableNourriture, float f, PisteGraphique pisteGraphique) {
        if (pisteGraphique.caseEstTraversable(n, n2)) {
            Point point = new Point(n, n2);
            this.position.add(0, point);
            pisteGraphique.setCaseVide(this.getQueue());
            this.position.remove(this.getQueue());
            if (pisteGraphique.caseEstNourriture(n, n2)) {
                this.manger(n, n2, tableNourriture, pisteGraphique.getPiste());
            }
            pisteGraphique.setCaseVer(point, this.genotype.getCouleur());
            this.updateVie(-f);
            return true;
        }
        return false;
    }

    protected String voirGauche(int n, boolean bl, Piste piste) {
        Point point = this.getTete();
        this.tableCompteur.initAll();
        switch (this.direction) {
            case 'F': {
                int n2 = 0;
                while (n2 < n) {
                    this.compterCas(point.x - n, point.y - n2, piste);
                    ++n2;
                }
                if (!bl) break;
                this.compterCas(point.x - n, point.y - n, piste);
                break;
            }
            case 'D': {
                int n3 = 0;
                while (n3 < n) {
                    this.compterCas(point.x + n3, point.y - n, piste);
                    ++n3;
                }
                if (!bl) break;
                this.compterCas(point.x + n, point.y - n, piste);
                break;
            }
            case 'B': {
                int n4 = 0;
                while (n4 < n) {
                    this.compterCas(point.x + n, point.y + n4, piste);
                    ++n4;
                }
                if (!bl) break;
                this.compterCas(point.x + n, point.y + n, piste);
                break;
            }
            case 'G': {
                int n5 = 0;
                while (n5 < n) {
                    this.compterCas(point.x - n5, point.y + n, piste);
                    ++n5;
                }
                if (!bl) break;
                this.compterCas(point.x - n, point.y + n, piste);
            }
        }
        if (this.tableCompteur.tousAZeroSaufI()) {
            return "I";
        }
        return this.tableCompteur.getMax();
    }

    protected Ver() {
    }

    protected String voirFace(int n, Piste piste) {
        Point point = this.getTete();
        this.tableCompteur.initAll();
        switch (this.direction) {
            case 'F': {
                this.compterCas(point.x, point.y - n, piste);
                int n2 = 1;
                while (n2 <= n) {
                    this.compterCas(point.x + n2, point.y - n, piste);
                    this.compterCas(point.x - n2, point.y - n, piste);
                    ++n2;
                }
                break;
            }
            case 'D': {
                this.compterCas(point.x + n, point.y, piste);
                int n3 = 1;
                while (n3 <= n) {
                    this.compterCas(point.x + n, point.y + n3, piste);
                    this.compterCas(point.x + n, point.y - n3, piste);
                    ++n3;
                }
                break;
            }
            case 'B': {
                this.compterCas(point.x, point.y + n, piste);
                int n4 = 1;
                while (n4 <= n) {
                    this.compterCas(point.x + n4, point.y + n, piste);
                    this.compterCas(point.x - n4, point.y + n, piste);
                    ++n4;
                }
                break;
            }
            case 'G': {
                this.compterCas(point.x - n, point.y, piste);
                int n5 = 1;
                while (n5 <= n) {
                    this.compterCas(point.x - n, point.y + n5, piste);
                    this.compterCas(point.x - n, point.y - n5, piste);
                    ++n5;
                }
                break;
            }
        }
        if (this.tableCompteur.tousAZeroSaufI()) {
            return "I";
        }
        return this.tableCompteur.getMax();
    }

    protected String vision(boolean bl, TableNourriture tableNourriture, Piste piste, float f) {
        int n = this.genotype.getTailleHalo();
        StringBuffer stringBuffer = null;
        if (this.genotype.haloEstProportionnel()) {
            String string = tableNourriture.listerType();
            boolean bl2 = false;
            int n2 = 1;
            while (n2 <= n && !bl2) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.voirGauche(n2, bl, piste));
                stringBuffer.append(this.voirFace(n2, piste));
                stringBuffer.append(this.voirDroite(n2, bl, piste));
                int n3 = 0;
                while (n3 < 3 && !bl2) {
                    if (string.indexOf(stringBuffer.charAt(n3)) != -1) {
                        bl2 = true;
                    }
                    ++n3;
                }
                ++n2;
            }
            float f2 = 0.0f;
            f2 = (float)(n2 - 1) * f;
            this.updateVie(-f2);
            return stringBuffer.toString();
        }
        if (this.genotype.haloEstFixe()) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.voirGauche(bl, piste));
            stringBuffer.append(this.voirFace(piste));
            stringBuffer.append(this.voirDroite(bl, piste));
            this.updateVie((float)(-n) * f);
            return stringBuffer.toString();
        }
        return "III";
    }

    private void compterCas(int n, int n2, Piste piste) {
        if (piste.caseEstNourriture(n, n2)) {
            this.tableCompteur.incCompteur(piste.getCase(n, n2) + "");
        } else {
            this.tableCompteur.incCompteur("I");
        }
    }

    private void compterCas(Point point, Piste piste) {
        this.compterCas(point.x, point.y, piste);
    }

    private final void retirerNouvelleTete(PisteGraphique pisteGraphique) {
        System.out.println("-----------Retirage de tete-----------");
        this.tuerVer(pisteGraphique);
        this.creerCorpsVer(pisteGraphique);
    }
}

