/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Nourriture;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableNourriture
implements Serializable,
Cloneable {
    public static final Color[] tableCouleur = new Color[]{Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.yellow, Color.darkGray, Color.gray, Color.lightGray};
    public static final char[] tableType = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    protected Hashtable tableNourriture = new Hashtable();
    private int indiceCouleur = 0;

    public String toString() {
        Nourriture[] nourritureArray = this.lister();
        if (nourritureArray == null) {
            return "[null]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        int n = 0;
        while (n < nourritureArray.length - 1) {
            stringBuffer.append(nourritureArray[n]);
            stringBuffer.append(", ");
            ++n;
        }
        stringBuffer.append(nourritureArray[n]);
        stringBuffer.append(" ]");
        return String.valueOf(stringBuffer);
    }

    public boolean sauver(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_tablenourriture_sauver"));
            return false;
        }
        return true;
    }

    public boolean removeNourriture(Nourriture nourriture) {
        if (nourriture == null) {
            System.err.println(Erreur.getString("erreur_tablenourriture_removenourriture_n"));
            return false;
        }
        return this.removeNourriture(nourriture.getType());
    }

    public boolean putNourriture() {
        int n = 0;
        n = 0;
        while (n < tableType.length) {
            Nourriture nourriture = new Nourriture(tableType[n]);
            if (this.putNourriture(nourriture)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean putNourriture(Nourriture nourriture) {
        if (nourriture == null) {
            System.err.println(Erreur.getString("erreur_tablenourriture_putnourriture_n"));
            return false;
        }
        if (this.indiceCouleur >= tableCouleur.length) {
            this.indiceCouleur = 0;
        }
        if (nourriture.getCouleur() == null) {
            nourriture.setCouleur(tableCouleur[this.indiceCouleur]);
        }
        if (!this.tableNourriture.containsKey(new Character(nourriture.getType()))) {
            this.tableNourriture.put(new Character(nourriture.getType()), nourriture);
            ++this.indiceCouleur;
            return true;
        }
        return false;
    }

    public Nourriture[] lister(boolean bl) {
        Serializable serializable;
        int n = 0;
        Nourriture[] nourritureArray = new Nourriture[this.tableNourriture.size()];
        Enumeration enumeration = this.tableNourriture.keys();
        while (enumeration.hasMoreElements()) {
            Nourriture nourriture;
            serializable = (Character)enumeration.nextElement();
            nourritureArray[n] = nourriture = this.getNourriture(serializable.charValue());
            ++n;
        }
        if (bl) {
            serializable = (Nourriture)nourritureArray[0].clone();
            int n2 = 0;
            while (n2 < nourritureArray.length) {
                n = 0;
                while (n < nourritureArray.length) {
                    if (nourritureArray[n2].getValeur() > nourritureArray[n].getValeur()) {
                        Nourriture nourriture = (Nourriture)nourritureArray[n2].clone();
                        nourritureArray[n2] = (Nourriture)nourritureArray[n].clone();
                        nourritureArray[n] = nourriture;
                    }
                    ++n;
                }
                ++n2;
            }
        }
        return nourritureArray;
    }

    public Nourriture[] lister() {
        return this.lister(false);
    }

    public Object clone() {
        TableNourriture tableNourriture = new TableNourriture();
        tableNourriture.tableNourriture = (Hashtable)this.tableNourriture.clone();
        return tableNourriture;
    }

    public TableNourriture() {
        this(0);
    }

    public String listerType() {
        String string = "";
        Enumeration enumeration = this.tableNourriture.keys();
        while (enumeration.hasMoreElements()) {
            Character c = (Character)enumeration.nextElement();
            string = string + c.charValue();
        }
        return string;
    }

    public TableNourriture(int n) {
        if (n > 0) {
            this.putNourriture(n);
        }
    }

    public boolean putNourriture(String string) {
        int n = 0;
        boolean bl = true;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        n = 0;
        while (n < string.length()) {
            bl = bl && this.putNourriture(new Nourriture(string.charAt(n)));
            ++n;
        }
        return bl;
    }

    public TableNourriture(String string) {
        this(0);
        this.putNourriture(string);
    }

    public boolean removeNourriture(char c) {
        return this.tableNourriture.remove(new Character(c)) != null;
    }

    public boolean putNourriture(int n) {
        int n2 = 0;
        boolean bl = true;
        if (n == 0) {
            return true;
        }
        if (n < 0) {
            return false;
        }
        n2 = 0;
        while (n2 < n) {
            boolean bl2 = bl = bl && this.putNourriture();
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final int getSize() {
        return this.tableNourriture.size();
    }

    public final Nourriture getNourriture(char c) {
        Nourriture nourriture = null;
        nourriture = (Nourriture)this.tableNourriture.get(new Character(c));
        return nourriture;
    }

    public final Nourriture getWorstNourriture() {
        if (this.tableNourriture == null) {
            return null;
        }
        Nourriture nourriture = new Nourriture('!', Float.MAX_VALUE);
        Nourriture nourriture2 = null;
        Character c = null;
        Enumeration enumeration = this.tableNourriture.keys();
        while (enumeration.hasMoreElements()) {
            c = (Character)enumeration.nextElement();
            nourriture2 = this.getNourriture(c.charValue());
            if (!(nourriture2.getValeur() < nourriture.getValeur())) continue;
            nourriture = nourriture2;
        }
        return nourriture;
    }

    public final Nourriture getBestNourriture() {
        if (this.tableNourriture == null) {
            return null;
        }
        Nourriture nourriture = new Nourriture('!', Float.MIN_VALUE);
        Nourriture nourriture2 = null;
        Character c = null;
        Enumeration enumeration = this.tableNourriture.keys();
        while (enumeration.hasMoreElements()) {
            c = (Character)enumeration.nextElement();
            nourriture2 = this.getNourriture(c.charValue());
            if (!(nourriture2.getValeur() > nourriture.getValeur())) continue;
            nourriture = nourriture2;
        }
        return nourriture;
    }

    public final Color getCouleurNourriture(char c) {
        Nourriture nourriture = null;
        Color color = null;
        nourriture = (Nourriture)this.tableNourriture.get(new Character(c));
        if (nourriture != null) {
            color = nourriture.getCouleur();
        }
        return color;
    }

    public final float getValeurNourriture(char c) {
        Nourriture nourriture = null;
        float f = 0.0f;
        nourriture = (Nourriture)this.tableNourriture.get(new Character(c));
        if (nourriture != null) {
            f = nourriture.getValeur();
        }
        return f;
    }

    public static TableNourriture charger(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            TableNourriture tableNourriture = (TableNourriture)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            return tableNourriture;
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_tablenourriture_charger"));
            return null;
        }
    }
}

