/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Generateur;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.ListeVer;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.Piste;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Ver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class PisteGraphique
extends JComponent
implements Serializable,
Cloneable,
MouseListener {
    public static int TAILLE_PINCEAU = -1;
    public static int QUANTITE_NOURRITURE = 100;
    public static char TYPE_NOURRITURE = (char)42;
    public static final Color COULEUR_MUR = Color.black;
    public static final Color COULEUR_VIDE = Color.blue;
    protected Dimension taillePix = null;
    protected Piste piste = null;
    protected int mult = 3;
    private Graphics og = null;
    private TableNourriture tableN = null;
    private Image oi = null;

    public void setTaille(Dimension dimension) {
        this.setTaille(dimension.height, dimension.width);
    }

    public void setTaille(int n, int n2) {
        this.piste = null;
        this.piste = new Piste(n, n2);
        this.taillePix = new Dimension(n * this.mult, n2 * this.mult);
        this.setPreferredSize(this.taillePix);
    }

    public void setTaille(int n) {
        this.setTaille(n, n);
    }

    public void placerNourriture(int n, int n2, int n3, TableNourriture tableNourriture) {
        this.placerNourriture(n, n2, n3, QUANTITE_NOURRITURE, tableNourriture);
    }

    public synchronized void paint(Graphics graphics) {
        if (GestionSimulation.ETAT_COURANT != 3) {
            if (this.oi != null) {
                graphics.drawImage(this.oi, 0, 0, this);
            } else {
                this.initGraphique();
            }
        }
    }

    public boolean caseEstTraversable(Point point) {
        return this.piste.caseEstTraversable(point.x, point.y);
    }

    public boolean caseEstVide(Point point) {
        return this.piste.caseEstVide(point.x, point.y);
    }

    public void placerNourriture(Nourriture nourriture) {
        this.placerNourriture(QUANTITE_NOURRITURE, nourriture);
    }

    public void setPiste(Piste piste) {
        this.piste = piste;
        this.taillePix = new Dimension(piste.getTailleX() * this.mult, piste.getTailleY() * this.mult);
        this.setPreferredSize(this.taillePix);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void setCaseVide(Point point) {
        if (point != null) {
            this.setCaseVide(point.x, point.y);
        }
    }

    public boolean caseEstVer(Point point) {
        return this.piste.caseEstVer(point.x, point.y);
    }

    public void setCaseVide(int n, int n2) {
        this.piste.setCaseVide(n, n2);
        this.affichePoint(n, n2, COULEUR_VIDE);
    }

    public Object clone() {
        PisteGraphique pisteGraphique = new PisteGraphique(this.getTaille());
        pisteGraphique.piste = (Piste)this.piste.clone();
        return pisteGraphique;
    }

    public void setCaseVer(Point point, Color color) {
        if (point != null) {
            this.setCaseVer(point.x, point.y, color);
        }
    }

    public char getCase(Point point) {
        return this.piste.getCase(point.x, point.y);
    }

    public void setCaseVer(int n, int n2, Color color) {
        this.piste.setCaseVer(n, n2);
        this.affichePoint(n, n2, color);
    }

    public void placerNourriture(int n, int n2, int n3, int n4, TableNourriture tableNourriture) {
        if (tableNourriture != null) {
            Nourriture[] nourritureArray = tableNourriture.lister();
            int n5 = 0;
            while (n5 < nourritureArray.length) {
                this.placerNourriture(n, n2, n3, n4, nourritureArray[n5]);
                ++n5;
            }
        }
    }

    public void setCaseMur(Point point) {
        if (point != null) {
            this.setCaseMur(point.x, point.y);
        }
    }

    public void lierTableNourriture(TableNourriture tableNourriture) {
        this.tableN = tableNourriture;
    }

    public void setCaseMur(int n, int n2) {
        this.piste.setCaseMur(n, n2);
        this.affichePoint(n, n2, COULEUR_MUR);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.tableN != null) {
            if (TAILLE_PINCEAU == -1 && TYPE_NOURRITURE == '*') {
                this.placerNourriture(QUANTITE_NOURRITURE, this.tableN);
            }
            if (TAILLE_PINCEAU == -1 && TYPE_NOURRITURE != '*') {
                this.placerNourriture(QUANTITE_NOURRITURE, this.tableN.getNourriture(TYPE_NOURRITURE));
            }
            if (mouseEvent != null) {
                if (TAILLE_PINCEAU != -1 && TYPE_NOURRITURE == '*') {
                    this.placerNourriture(mouseEvent.getX() / this.mult, mouseEvent.getY() / this.mult, TAILLE_PINCEAU, QUANTITE_NOURRITURE, this.tableN);
                }
                if (TAILLE_PINCEAU != -1 && TYPE_NOURRITURE != '*') {
                    this.placerNourriture(mouseEvent.getX() / this.mult, mouseEvent.getY() / this.mult, TAILLE_PINCEAU, QUANTITE_NOURRITURE, this.tableN.getNourriture(TYPE_NOURRITURE));
                }
            }
        } else {
            System.err.println(Erreur.getString("erreur_pistegraphique_mousepressed"));
        }
        if (mouseEvent != null) {
            mouseEvent.consume();
        }
    }

    public PisteGraphique(int n) {
        this(n, n);
    }

    public boolean caseEstVer(int n, int n2) {
        return this.piste.caseEstVer(n, n2);
    }

    public PisteGraphique(int n, int n2) {
        this.addMouseListener(this);
        this.taillePix = new Dimension(n * this.mult, n2 * this.mult);
        this.piste = new Piste(n, n2);
        this.setPreferredSize(this.taillePix);
    }

    public void placerNourriture(int n, Nourriture nourriture) {
        int n2 = n;
        double d = this.piste.getTailleX() * this.piste.getTailleY() - 1;
        int n3 = 0;
        while (n3 <= n && d > 0.0) {
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            while (!bl) {
                n4 = Generateur.tirerIntEntre(this.piste.getTailleX());
                n5 = Generateur.tirerIntEntre(this.piste.getTailleY());
                bl = this.piste.caseEstTraversable(n4, n5);
            }
            d -= 1.0;
            this.piste.setCase(n4, n5, nourriture.getType());
            this.affichePoint(n4, n5, nourriture.getCouleur());
            ++n3;
        }
        this.repaint();
    }

    public PisteGraphique(Piste piste) {
        this(piste.getTailleX(), piste.getTailleY());
        this.piste = piste;
    }

    public void placerNourriture(int n, int n2, Nourriture nourriture) {
        if (this.piste.caseEstTraversable(n, n2)) {
            this.piste.setCase(n, n2, nourriture.getType());
            this.affichePoint(n, n2, nourriture.getCouleur());
        }
    }

    public PisteGraphique(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public void creerMur(int n, int n2, int n3, int n4) {
        if (n > n3 || n2 > n4) {
            return;
        }
        if (n2 == n4) {
            int n5 = n;
            while (n5 < n3) {
                this.setCaseMur(n5, n2);
                ++n5;
            }
            return;
        }
        if (n == n3) {
            int n6 = n2;
            while (n6 < n4) {
                this.setCaseMur(n, n6);
                ++n6;
            }
            return;
        }
    }

    public void affichePiste(TableNourriture tableNourriture, ListeVer listeVer) {
        if (GestionSimulation.ETAT_COURANT != 3) {
            this.clean();
            int n = 0;
            while (n < this.piste.getTailleX()) {
                int n2 = 0;
                while (n2 < this.piste.getTailleY()) {
                    if (this.piste.caseEstNourriture(n, n2)) {
                        if (tableNourriture != null) {
                            this.affichePoint(n, n2, tableNourriture.getCouleurNourriture(this.piste.getCase(n, n2)));
                        }
                    } else if (this.piste.caseEstMur(n, n2)) {
                        this.affichePoint(n, n2, COULEUR_MUR);
                    }
                    ++n2;
                }
                ++n;
            }
            if (listeVer != null) {
                n = 0;
                while (n < listeVer.getSize()) {
                    this.afficheVer(listeVer.getVer(n));
                    ++n;
                }
            }
            this.repaint();
        }
    }

    public char getCase(int n, int n2) {
        return this.piste.getCase(n, n2);
    }

    public boolean sauver(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_pistegraphique_sauver"));
            return false;
        }
        return true;
    }

    public void placerNourriture(int n, TableNourriture tableNourriture) {
        if (tableNourriture != null) {
            Nourriture[] nourritureArray = tableNourriture.lister();
            int n2 = 0;
            while (n2 < nourritureArray.length) {
                this.placerNourriture(n, nourritureArray[n2]);
                ++n2;
            }
        }
    }

    public void placerNourriture(TableNourriture tableNourriture) {
        this.placerNourriture(QUANTITE_NOURRITURE, tableNourriture);
    }

    public void placerNourriture(int n, int n2, int n3, Nourriture nourriture) {
        this.placerNourriture(n, n2, n3, QUANTITE_NOURRITURE, nourriture);
    }

    public void afficheVer(Ver ver) {
        if (GestionSimulation.ETAT_COURANT != 3 && GestionSimulation.ETAT_COURANT != 0) {
            if (ver == null) {
                System.err.println(Erreur.getString("erreur_pistegraphique_affichever"));
                return;
            }
            Point point = null;
            if (this.og == null) {
                this.initGraphique();
            }
            int n = 0;
            while (n < ver.getTaille()) {
                point = (Point)ver.getPosition().elementAt(n);
                this.piste.setCaseVer(point);
                this.affichePoint(point, ver.getColor());
                ++n;
            }
        }
    }

    public void placerNourriture(int n, int n2, int n3, int n4, Nourriture nourriture) {
        if (n3 <= 1) {
            if (this.piste.caseEstTraversable(n, n2)) {
                this.piste.setCase(n, n2, nourriture.getType());
                this.affichePoint(n, n2, nourriture.getCouleur());
            }
        } else {
            double d = n3 * n3 - 1;
            int n5 = 0;
            while (n5 <= n4 && d > 0.0) {
                boolean bl = false;
                int n6 = 0;
                int n7 = 0;
                while (!bl) {
                    n6 = Generateur.tirerIntEntre(n3) * Generateur.signe() + n * Generateur.signe();
                    n7 = Generateur.tirerIntEntre(n3) * Generateur.signe() + n2 * Generateur.signe();
                    bl = this.piste.caseEstTraversable(n6, n7);
                }
                d -= 1.0;
                this.piste.setCase(n6, n7, nourriture.getType());
                this.affichePoint(n6, n7, nourriture.getCouleur());
                ++n5;
            }
        }
        this.repaint();
    }

    public boolean caseEstMur(int n, int n2) {
        return this.piste.caseEstMur(n, n2);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public boolean caseEstMur(Point point) {
        return this.piste.caseEstMur(point.x, point.y);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public boolean caseEstNourriture(int n, int n2) {
        return this.piste.caseEstNourriture(n, n2);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public boolean caseEstNourriture(Point point) {
        return this.piste.caseEstNourriture(point.x, point.y);
    }

    public boolean caseEstTraversable(int n, int n2) {
        return this.piste.caseEstTraversable(n, n2);
    }

    public boolean caseEstVide(int n, int n2) {
        return this.piste.caseEstVide(n, n2);
    }

    public final void initGraphique() {
        if (GestionSimulation.ETAT_COURANT != 3) {
            this.oi = this.createImage(this.taillePix.width, this.taillePix.height);
            if (this.oi != null) {
                this.og = this.oi.getGraphics();
                this.og.setColor(COULEUR_VIDE);
                this.og.fillRect(0, 0, this.taillePix.width - 1, this.taillePix.height - 1);
            }
            this.repaint();
        }
    }

    public final void initAll() {
        this.initGraphique();
        this.initPiste();
    }

    public final int getTailleY() {
        return this.piste.getTailleY();
    }

    public final int getTailleX() {
        return this.piste.getTailleX();
    }

    public final Dimension getTaille() {
        return new Dimension(this.piste.getTaille());
    }

    public final void clean() {
        if (GestionSimulation.ETAT_COURANT != 3) {
            if (this.oi != null) {
                this.og.setColor(COULEUR_VIDE);
                this.og.fillRect(0, 0, this.taillePix.width - 1, this.taillePix.height - 1);
            } else {
                this.initGraphique();
                this.clean();
            }
        }
    }

    public final void initPiste() {
        this.piste.init();
    }

    public final Piste getPiste() {
        return this.piste;
    }

    protected void entourrer() {
        int n = 0;
        while (n < this.piste.getTailleX()) {
            this.setCaseMur(n, 0);
            this.setCaseMur(n, this.piste.getTailleY() - 1);
            ++n;
        }
        n = 0;
        while (n < this.piste.getTailleY()) {
            this.setCaseMur(0, n);
            this.setCaseMur(this.piste.getTailleX() - 1, n);
            ++n;
        }
    }

    protected void affichePoint(Point point, Color color) {
        this.affichePoint(point.x, point.y, color);
    }

    protected void affichePoint(int n, int n2, Color color) {
        if (GestionSimulation.ETAT_COURANT != 3 && this.verifier(n, n2)) {
            if (this.og != null) {
                this.og.setColor(color);
                this.og.fillRect(n * this.mult, n2 * this.mult, this.mult - 1, this.mult - 1);
            } else {
                this.initGraphique();
                this.affichePoint(n, n2, color);
            }
        }
    }

    protected boolean verifier(int n, int n2) {
        if (n > this.piste.getTailleX() || n < 0) {
            return false;
        }
        return n2 <= this.piste.getTailleY() && n2 >= 0;
    }

    protected boolean verifier(Point point) {
        return this.verifier(point.x, point.y);
    }
}

