/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Piste
implements Serializable,
Cloneable {
    public static final char VER = '1';
    public static final char VIDE = ' ';
    public static final char MUR = 'M';
    public static final int TAILLE_PAR_DEFAUT = 150;
    private Dimension taillePiste = new Dimension(0, 0);
    private char[] piste = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ X=");
        stringBuffer.append(this.taillePiste.width);
        stringBuffer.append(", Y=");
        stringBuffer.append(this.taillePiste.height);
        stringBuffer.append(",\n");
        int n = 0;
        while (n < this.taillePiste.height) {
            int n2 = 0;
            while (n2 < this.taillePiste.width) {
                stringBuffer.append(this.getCase(n2, n));
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setCaseVide(Point point) {
        if (point != null) {
            this.setCaseVide(point.x, point.y);
        }
    }

    public void setCaseVide(int n, int n2) {
        this.setCase(n, n2, ' ');
    }

    public boolean caseEstVide(int n, int n2) {
        return this.getCase(n, n2) == ' ';
    }

    public void setCaseMur(Point point) {
        if (point != null) {
            this.setCaseMur(point.x, point.y);
        }
    }

    public char getCase(Point point) {
        if (point == null) {
            return 'M';
        }
        return this.getCase(point.x, point.y);
    }

    public boolean caseEstTraversable(int n, int n2) {
        return !this.caseEstMur(n, n2) && !this.caseEstVer(n, n2);
    }

    public void setCaseMur(int n, int n2) {
        this.setCase(n, n2, 'M');
    }

    public void setCaseVer(Point point) {
        if (point != null) {
            this.setCaseVer(point.x, point.y);
        }
    }

    public void creerMur(int n, int n2, int n3, int n4) {
        if (n > n3 || n2 > n4) {
            return;
        }
        if (n2 == n4) {
            int n5 = n;
            while (n5 < n3) {
                this.setCaseMur(n5, n2);
                ++n5;
            }
            return;
        }
        if (n == n3) {
            int n6 = n2;
            while (n6 < n4) {
                this.setCaseMur(n, n6);
                ++n6;
            }
            return;
        }
    }

    public void setCaseVer(int n, int n2) {
        this.setCase(n, n2, '1');
    }

    public void setCase(int n, int n2, char c) {
        if (this.verifier(n, n2)) {
            this.piste[n2 * this.taillePiste.width + n] = c;
        }
    }

    public Piste() {
        this(150);
    }

    public boolean caseEstTraversable(Point point) {
        return this.caseEstTraversable(point.x, point.y);
    }

    public Piste(int n) {
        this(n, n);
    }

    public boolean caseEstVer(Point point) {
        if (point == null) {
            return false;
        }
        return this.caseEstVer(point.x, point.y);
    }

    public Piste(int n, int n2) {
        this.piste = new char[n * n2];
        this.taillePiste.height = n2;
        this.taillePiste.width = n;
        this.init();
    }

    public boolean caseEstVide(Point point) {
        if (point == null) {
            return false;
        }
        return this.caseEstVide(point.x, point.y);
    }

    public Piste(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public Object clone() {
        Piste piste = new Piste(this.taillePiste);
        int n = 0;
        while (n < this.taillePiste.width) {
            int n2 = 0;
            while (n2 < this.taillePiste.height) {
                piste.setCase(n, n2, this.getCase(n, n2));
                ++n2;
            }
            ++n;
        }
        return piste;
    }

    public boolean caseEstMur(int n, int n2) {
        return this.getCase(n, n2) == 'M';
    }

    public char getCase(int n, int n2) {
        if (this.verifier(n, n2)) {
            return this.piste[n2 * this.taillePiste.width + n];
        }
        return 'M';
    }

    public boolean caseEstMur(Point point) {
        if (point == null) {
            return true;
        }
        return this.caseEstMur(point.x, point.y);
    }

    public void setCase(Point point, char c) {
        if (point != null) {
            this.setCase(point.x, point.y, c);
        }
    }

    public boolean caseEstNourriture(int n, int n2) {
        try {
            if (!(this.caseEstMur(n, n2) || this.caseEstVide(n, n2) || this.caseEstVer(n, n2))) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public boolean sauver(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_piste_sauver"));
            return false;
        }
        return true;
    }

    public boolean caseEstNourriture(Point point) {
        if (point == null) {
            return false;
        }
        return this.caseEstNourriture(point.x, point.y);
    }

    public boolean caseEstVer(int n, int n2) {
        return this.getCase(n, n2) == '1';
    }

    public final int getTailleY() {
        return this.taillePiste.height;
    }

    public final int getTailleX() {
        return this.taillePiste.width;
    }

    public final Dimension getTaille() {
        return new Dimension(this.taillePiste);
    }

    public final void init() {
        int n = 0;
        while (n < this.taillePiste.width) {
            int n2 = 0;
            while (n2 < this.taillePiste.height) {
                this.setCaseVide(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public static Piste charger(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        if (string.equals("Default")) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Piste piste = (Piste)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            return piste;
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_piste_charger"));
            return null;
        }
    }

    protected final boolean verifier(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        return n < this.taillePiste.width && n2 < this.taillePiste.height;
    }
}

