/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Genotype;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import fr.lifl.Aquarium.Simulation.Ver;
import java.awt.Color;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Parametres
implements Serializable,
Cloneable {
    protected boolean crossEtMute = true;
    protected boolean deuxFils = false;
    protected int periodeEvolution = 0;
    protected int nbMutation = 0;
    protected String cas = null;
    protected int tailleTrancheCrossingOver = 0;
    protected int tailleVer = 0;
    protected boolean couleurTypeHalo = false;
    protected int tauxMutation = 0;
    protected boolean diagonal = true;
    protected int nbHaloFixe = -1;
    protected int maxHalo = 25;
    protected float coeffAjustementHalo = 1.0f;
    protected int minHalo = 1;
    protected int nbVer = 0;
    protected int quantiteNourriture = 0;
    protected int vitesse = 0;
    protected int periodeSevrage = 0;
    protected int tauxCrossingOver = 0;
    protected float coutDeplacement = 0.0f;
    protected int nbVerTue = 0;
    protected Dimension taillePiste = null;
    protected TableNourriture tableNourriture = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n[ ");
        stringBuffer.append(Langage.getString("cas_etudie"));
        stringBuffer.append(this.cas);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("nb_vers_tues"));
        stringBuffer.append(this.nbVerTue);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("taux_mutation"));
        stringBuffer.append(this.tauxMutation);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("taux_crossingOver"));
        stringBuffer.append(this.tauxCrossingOver);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("taille_tranche"));
        stringBuffer.append(this.tailleTrancheCrossingOver);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("nb_mutation"));
        stringBuffer.append(this.nbMutation);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("periode_evolution"));
        stringBuffer.append(this.periodeEvolution);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("nb_vers"));
        stringBuffer.append(this.nbVer);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("taille_ver"));
        stringBuffer.append(this.tailleVer);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("tb_nourriture"));
        stringBuffer.append(this.tableNourriture);
        stringBuffer.append(", ");
        stringBuffer.append(Langage.getString("taille_piste"));
        stringBuffer.append("(");
        stringBuffer.append(this.taillePiste.width);
        stringBuffer.append(", ");
        stringBuffer.append(this.taillePiste.height);
        stringBuffer.append("),\n ");
        stringBuffer.append(Langage.getString("deux_fils"));
        stringBuffer.append(":");
        stringBuffer.append(this.deuxFils);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("cross_et_mute"));
        stringBuffer.append(":");
        stringBuffer.append(this.crossEtMute);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("nb_halo_fixe"));
        stringBuffer.append(":");
        stringBuffer.append(this.nbHaloFixe);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("coeff_ajustement_halo"));
        stringBuffer.append(":");
        stringBuffer.append(this.coeffAjustementHalo);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("couleur_halo"));
        stringBuffer.append(":");
        stringBuffer.append(this.couleurTypeHalo);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("min_halo"));
        stringBuffer.append(":");
        stringBuffer.append(this.minHalo);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("max_halo"));
        stringBuffer.append(":");
        stringBuffer.append(this.maxHalo);
        stringBuffer.append(",\n ");
        stringBuffer.append(Langage.getString("compter_diagonale"));
        stringBuffer.append(":");
        stringBuffer.append(this.diagonal);
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    public boolean sauver(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_parametres_sauver"));
            return false;
        }
        return true;
    }

    public Parametres() {
        this.setDefaut();
    }

    public Object clone() {
        Parametres parametres = new Parametres();
        parametres.cas = new String(this.cas);
        parametres.nbVerTue = this.nbVerTue;
        parametres.tauxMutation = this.tauxMutation;
        parametres.tauxCrossingOver = this.tauxCrossingOver;
        parametres.nbMutation = this.nbMutation;
        parametres.vitesse = this.vitesse;
        parametres.periodeEvolution = this.periodeEvolution;
        parametres.nbVer = this.nbVer;
        parametres.tailleVer = this.tailleVer;
        parametres.tailleTrancheCrossingOver = this.tailleTrancheCrossingOver;
        parametres.tableNourriture = (TableNourriture)this.tableNourriture.clone();
        parametres.taillePiste = new Dimension(this.taillePiste);
        parametres.coutDeplacement = this.coutDeplacement;
        parametres.periodeSevrage = this.periodeSevrage;
        parametres.quantiteNourriture = this.quantiteNourriture;
        parametres.deuxFils = this.deuxFils;
        parametres.crossEtMute = this.crossEtMute;
        parametres.nbHaloFixe = this.nbHaloFixe;
        parametres.coeffAjustementHalo = this.coeffAjustementHalo;
        parametres.minHalo = this.minHalo;
        parametres.maxHalo = this.maxHalo;
        parametres.couleurTypeHalo = this.couleurTypeHalo;
        parametres.diagonal = this.diagonal;
        return parametres;
    }

    public final void setTailleVer(int n) {
        if (n > 0) {
            this.tailleVer = n;
        }
    }

    public final void setTailleTrancheCrossingOver(int n) {
        if (n > 0) {
            this.tailleTrancheCrossingOver = n;
        }
    }

    public final void setTaillePiste(Dimension dimension) {
        if (dimension.height > 0 && dimension.width > 0) {
            this.taillePiste = dimension;
        }
    }

    public final int getPeriodeSevrage() {
        return this.periodeSevrage;
    }

    public final int getTailleTrancheCrossingOver() {
        return this.tailleTrancheCrossingOver;
    }

    public final boolean getCouleurTypeHalo() {
        return this.couleurTypeHalo;
    }

    public final boolean getDiagonal() {
        return this.diagonal;
    }

    public final int getNbMutation() {
        return this.nbMutation;
    }

    public final void setTaillePiste(int n, int n2) {
        this.setTaillePiste(new Dimension(n2, n));
    }

    public final int getVitesse() {
        return this.vitesse;
    }

    public final void setTableNourriture(TableNourriture tableNourriture) {
        this.tableNourriture = tableNourriture;
        this.cas = tableNourriture != null ? "I" + tableNourriture.listerType() : "";
    }

    public final boolean getCrossEtMute() {
        return this.crossEtMute;
    }

    public final void setQuantiteNourriture(int n) {
        this.quantiteNourriture = n;
    }

    public final int getMinHalo() {
        return this.minHalo;
    }

    public final void setPeriodeSevrage(int n) {
        if (n > 0) {
            this.periodeSevrage = n;
        }
    }

    public final void setCouleurTypeHalo(boolean bl) {
        this.couleurTypeHalo = bl;
        Genotype.COULEUR_HALO = bl;
    }

    public final void setPeriodeEvolution(int n) {
        if (n >= 0) {
            this.periodeEvolution = n;
        }
    }

    public final TableNourriture getTableNourriture() {
        return this.tableNourriture;
    }

    public final void setNbVerTue(int n) {
        if (n > 0 || n <= 100) {
            this.nbVerTue = n;
        }
    }

    public final int getTauxCrossingOver() {
        return this.tauxCrossingOver;
    }

    public final void setNbVer(int n) {
        if (n < 0) {
            n = 1;
        }
        this.nbVer = n;
    }

    public final void setCas(String string) {
        if (string != null) {
            this.cas = new String(string);
        }
    }

    public final void setNbMutation(int n) {
        if (n >= 0 || n <= 100) {
            this.nbMutation = n;
        }
    }

    public final float getCoutDeplacement() {
        return this.coutDeplacement;
    }

    public final void setNbHaloFixe(int n) {
        if (n <= 100) {
            this.nbHaloFixe = n;
        }
    }

    public final boolean getDeuxFils() {
        return this.deuxFils;
    }

    public final void setMinHalo(int n) {
        if (this.minHalo > 0 && this.minHalo <= this.maxHalo) {
            Genotype.MIN_TAILLE_HALO = this.minHalo = n;
        }
    }

    public final int getMaxHalo() {
        return this.maxHalo;
    }

    public final void setMaxHalo(int n) {
        if (n > 0 && this.maxHalo >= this.minHalo) {
            Genotype.MAX_TAILLE_HALO = this.maxHalo = n;
        }
    }

    public final int getNbHaloFixe() {
        return this.nbHaloFixe;
    }

    public final void setDiagonal(boolean bl) {
        this.diagonal = bl;
        Ver.DIAGONALE = bl;
    }

    public final int getNbVer() {
        return this.nbVer;
    }

    public final void setDeuxFils(boolean bl) {
        this.deuxFils = bl;
    }

    public final int getPeriodeEvolution() {
        return this.periodeEvolution;
    }

    public final void setDefaut() {
        this.vitesse = 0;
        this.cas = "INP";
        this.crossEtMute = true;
        this.deuxFils = false;
        this.nbVerTue = 50;
        this.tauxMutation = 5;
        this.nbMutation = 5;
        this.tauxCrossingOver = 50;
        this.tailleTrancheCrossingOver = 1;
        this.periodeEvolution = 100;
        this.periodeSevrage = 5;
        this.quantiteNourriture = 200;
        this.coutDeplacement = 0.5f;
        this.coeffAjustementHalo = 0.05f;
        this.nbVer = 25;
        this.tailleVer = 5;
        this.taillePiste = new Dimension(300, 150);
        this.tableNourriture = new TableNourriture();
        Nourriture nourriture = new Nourriture('N', 50.0f);
        Nourriture nourriture2 = new Nourriture('P', 10.0f);
        nourriture.setCouleur(Color.green);
        nourriture2.setCouleur(Color.red);
        this.tableNourriture.putNourriture(nourriture);
        this.tableNourriture.putNourriture(nourriture2);
        this.nbHaloFixe = -1;
        this.setDiagonal(true);
        this.setCouleurTypeHalo(true);
        this.setMinHalo(4);
        this.setMaxHalo(25);
    }

    public final int getQuantiteNourriture() {
        return this.quantiteNourriture;
    }

    public final void setCrossEtMute(boolean bl) {
        this.crossEtMute = bl;
    }

    public final Dimension getTaillePiste() {
        return this.taillePiste;
    }

    public final void setTauxMutation(int n) {
        if (n >= 0 || n <= 100) {
            this.tauxMutation = n;
        }
    }

    public final int getTailleVer() {
        return this.tailleVer;
    }

    public final void setCoutDeplacement(float f) {
        this.coutDeplacement = f;
    }

    public final int getTauxMutation() {
        return this.tauxMutation;
    }

    public final void setCoeffAjustementHalo(float f) {
        this.coeffAjustementHalo = f;
    }

    public final void setVitesse(int n) {
        if (n >= 0) {
            this.vitesse = n;
        }
    }

    public final String getCas() {
        return this.cas;
    }

    public final void setTauxCrossingOver(int n) {
        if (n >= 0 || n <= 100) {
            this.tauxCrossingOver = n;
        }
    }

    public final float getCoeffAjustementHalo() {
        return this.coeffAjustementHalo;
    }

    public final int getNbVerTue() {
        return this.nbVerTue;
    }

    public static Parametres charger(String string) {
        Parametres parametres = null;
        if (string == null) {
            return new Parametres();
        }
        if (string.trim().equals("")) {
            return new Parametres();
        }
        if (string.equals("Default")) {
            return new Parametres();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            parametres = (Parametres)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            parametres.setDiagonal(parametres.diagonal);
            parametres.setCouleurTypeHalo(parametres.couleurTypeHalo);
            parametres.setMinHalo(parametres.minHalo);
            parametres.setMaxHalo(parametres.minHalo);
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_parametres_charger"));
            return new Parametres();
        }
        return parametres;
    }
}

