/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Generateur;
import java.awt.Color;
import java.io.Serializable;

public class Nourriture
implements Serializable,
Cloneable {
    protected Color couleur = null;
    protected float valeurEnergetique = 0.0f;
    protected char type;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("('");
        stringBuffer.append(this.type);
        stringBuffer.append("', ");
        stringBuffer.append(this.valeurEnergetique);
        stringBuffer.append(", ");
        stringBuffer.append(Nourriture.colorToString(this.couleur));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Nourriture(char c, float f, Color color) {
        this.type = c;
        this.valeurEnergetique = f;
        this.couleur = color;
    }

    public Nourriture(char c, float f) {
        this.type = c;
        this.valeurEnergetique = f;
    }

    public Nourriture(char c) {
        this.type = c;
        this.valeurEnergetique = Generateur.tirerFloat();
    }

    public Object clone() {
        Nourriture nourriture = new Nourriture();
        nourriture.type = this.type;
        nourriture.valeurEnergetique = this.valeurEnergetique;
        if (this.couleur != null) {
            nourriture.couleur = new Color(this.couleur.getRed(), this.couleur.getGreen(), this.couleur.getBlue());
        }
        return nourriture;
    }

    public final void setCouleur(Color color) {
        if (color != null) {
            this.couleur = color;
        }
    }

    public final float getValeur() {
        return this.valeurEnergetique;
    }

    public final Color getCouleur() {
        return this.couleur;
    }

    public final char getType() {
        return this.type;
    }

    public static final Color stringToColor(String string) {
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("darkGray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("lightGray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        Color color = Color.white;
        try {
            color = Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return color;
    }

    public static final String colorToString(Color color) {
        if (color.equals(Color.black)) {
            return "black";
        }
        if (color.equals(Color.cyan)) {
            return "cyan";
        }
        if (color.equals(Color.blue)) {
            return "blue";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "gray";
        }
        if (color.equals(Color.green)) {
            return "green";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "magenta";
        }
        if (color.equals(Color.orange)) {
            return "orange";
        }
        if (color.equals(Color.pink)) {
            return "pink";
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.white)) {
            return "white";
        }
        if (color.equals(Color.yellow)) {
            return "yellow";
        }
        return color.toString();
    }

    protected Nourriture() {
    }
}

