/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Generateur;
import fr.lifl.Aquarium.Simulation.Genotype;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import fr.lifl.Aquarium.Simulation.Ver;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class ListeVer
implements Serializable {
    protected Vector listeVer = null;

    public ListeVer() {
        this.listeVer = new Vector();
    }

    public ListeVer(int n) {
        this.listeVer = n <= 0 ? new Vector() : new Vector(n);
    }

    public void quickSort() {
        this.quickSort(0, this.listeVer.size() - 1);
    }

    public int getMaxHalo(char c) {
        int n = this.listeVer.size();
        int n2 = Integer.MIN_VALUE;
        if (n == 0) {
            return 0;
        }
        Ver ver = null;
        int n3 = 0;
        while (n3 < n) {
            ver = this.getVer(n3);
            if (ver.getGenotype().getTypeHalo() == c && ver.getGenotype().getTailleHalo() > n2) {
                n2 = ver.getGenotype().getTailleHalo();
            }
            ++n3;
        }
        if (n2 == Integer.MIN_VALUE) {
            return 0;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ NbVer = ");
        stringBuffer.append(this.listeVer.size());
        stringBuffer.append("\n, ");
        stringBuffer.append(this.listeVer.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getNbHalo(char c) {
        int n = this.listeVer.size();
        int n2 = 0;
        if (n == 0) {
            return 0;
        }
        Ver ver = null;
        int n3 = 0;
        while (n3 < n) {
            ver = this.getVer(n3);
            if (ver.getGenotype().getTypeHalo() == c) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public double degreConvergenceAdn() {
        int n = this.listeVer.size();
        double[] dArray = new double[n];
        double d = 0.0;
        if (n <= 1) {
            return 100.0;
        }
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            Ver ver = this.getVer(n2);
            double d2 = ver.getGenotype().getAdn().getSize();
            int n3 = 0;
            while (n3 < n) {
                if (n3 != n2) {
                    Ver ver2 = this.getVer(n3);
                    double d3 = 0.0;
                    int n4 = 0;
                    while ((double)n4 < d2) {
                        if (ver.getGenotype().getAdn().getValeurGene(n4).equals(ver2.getGenotype().getAdn().getValeurGene(n4))) {
                            d3 += 1.0;
                        }
                        ++n4;
                    }
                    dArray[n2] = dArray[n2] + d3;
                }
                ++n3;
            }
            dArray[n2] = dArray[n2] / ((double)(n - 1) * d2);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            d += dArray[n2];
            ++n2;
        }
        d = d / (double)n * 100.0;
        return d;
    }

    public void trier() {
        int n = this.listeVer.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Ver ver = (Ver)this.getVer(n2).clone();
            int n3 = 0;
            while (n3 < n) {
                Ver ver2 = (Ver)this.getVer(n3).clone();
                if (ver.getVie() > ver2.getVie()) {
                    this.listeVer.setElementAt(ver, n3);
                    this.listeVer.setElementAt(ver2, n2);
                    ver = (Ver)this.getVer(n2).clone();
                }
                ++n3;
            }
            ++n2;
        }
    }

    public String afficherVers() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.listeVer;
        synchronized (vector) {
            int n = this.listeVer.size();
            if (n == 0) {
                String string = new String("");
                return string;
            }
            int n2 = 0;
            while (n2 < n) {
                Ver ver = this.getVer(n2);
                stringBuffer.append(ver.toString());
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public double getMoyenneHalo(char c) {
        int n = 0;
        int n2 = this.listeVer.size();
        double d = 0.0;
        Ver ver = null;
        if (n2 == 0) {
            return 0.0;
        }
        int n3 = 0;
        while (n3 < n2) {
            ver = this.getVer(n3);
            if (ver.getGenotype().getTypeHalo() == c) {
                ++n;
                d += (double)ver.getGenotype().getTailleHalo();
            }
            ++n3;
        }
        if (n != 0) {
            d /= (double)n;
        }
        return d;
    }

    public boolean sauver(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_listever_sauver"));
            return false;
        }
        return true;
    }

    public String informer() {
        double d = 0.0;
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = 0;
        int n6 = 0;
        Vector vector = this.listeVer;
        synchronized (vector) {
            int n7 = this.listeVer.size();
            double[] dArray = new double[n7];
            int n8 = 0;
            while (n8 < n7) {
                dArray[n8] = 0.0;
                Ver ver = this.getVer(n8);
                double d4 = ver.getGenotype().getAdn().getSize();
                if (ver.getGenotype().getTypeHalo() == 'F') {
                    ++n5;
                    if (ver.getGenotype().getTailleHalo() > n) {
                        n = ver.getGenotype().getTailleHalo();
                    }
                    if (ver.getGenotype().getTailleHalo() < n3) {
                        n3 = ver.getGenotype().getTailleHalo();
                    }
                    d2 += (double)ver.getGenotype().getTailleHalo();
                }
                if (ver.getGenotype().getTypeHalo() == 'P') {
                    ++n6;
                    if (ver.getGenotype().getTailleHalo() > n2) {
                        n2 = ver.getGenotype().getTailleHalo();
                    }
                    if (ver.getGenotype().getTailleHalo() < n4) {
                        n4 = ver.getGenotype().getTailleHalo();
                    }
                    d3 += (double)ver.getGenotype().getTailleHalo();
                }
                int n9 = 0;
                while (n9 < n7) {
                    if (n9 != n8) {
                        Ver ver2 = this.getVer(n9);
                        double d5 = 0.0;
                        int n10 = 0;
                        while ((double)n10 < d4) {
                            if (ver.getGenotype().getAdn().getValeurGene(n10).equals(ver2.getGenotype().getAdn().getValeurGene(n10))) {
                                d5 += 1.0;
                            }
                            ++n10;
                        }
                        dArray[n8] = dArray[n8] + d5;
                    }
                    ++n9;
                }
                dArray[n8] = dArray[n8] / ((double)(n7 - 1) * d4);
                ++n8;
            }
            n8 = 0;
            while (n8 < n7) {
                d += dArray[n8];
                ++n8;
            }
            d = d / (double)n7 * 100.0;
            if (n7 <= 1) {
                d = 100.0;
            }
        }
        if (n2 == Integer.MIN_VALUE) {
            n2 = 0;
        }
        if (n4 == Integer.MAX_VALUE) {
            n4 = 0;
        }
        if (n6 != 0) {
            d3 /= (double)n6;
        }
        if (n == Integer.MIN_VALUE) {
            n = 0;
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = 0;
        }
        if (n5 != 0) {
            d2 /= (double)n5;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nAdn = ");
        stringBuffer.append(d);
        stringBuffer.append(" (%)\nTypes Halo=(");
        stringBuffer.append('F');
        stringBuffer.append(" : ");
        stringBuffer.append(n5);
        stringBuffer.append(", ");
        stringBuffer.append('P');
        stringBuffer.append(" : ");
        stringBuffer.append(n6);
        stringBuffer.append(")\n\tFixe : Min = ");
        stringBuffer.append(n3);
        stringBuffer.append(" Max = ");
        stringBuffer.append(n);
        stringBuffer.append(" Moy = ");
        stringBuffer.append(d2);
        stringBuffer.append("\n\tProportionnel : Min = ");
        stringBuffer.append(n4);
        stringBuffer.append(" Max = ");
        stringBuffer.append(n2);
        stringBuffer.append(" Moy = ");
        stringBuffer.append(d3);
        return stringBuffer.toString();
    }

    public int getMinHalo(char c) {
        int n = this.listeVer.size();
        int n2 = Integer.MAX_VALUE;
        if (n == 0) {
            return 0;
        }
        Ver ver = null;
        int n3 = 0;
        while (n3 < n) {
            ver = this.getVer(n3);
            if (ver.getGenotype().getTypeHalo() == c && ver.getGenotype().getTailleHalo() < n2) {
                n2 = ver.getGenotype().getTailleHalo();
            }
            ++n3;
        }
        if (n2 == Integer.MAX_VALUE) {
            return 0;
        }
        return n2;
    }

    public final Ver getVer(int n) {
        if (n >= 0 && n < this.listeVer.size()) {
            return (Ver)this.listeVer.elementAt(n);
        }
        return null;
    }

    public final void incAllGeneration() {
        int n = 0;
        while (n < this.listeVer.size()) {
            this.getVer(n).incGeneration();
            ++n;
        }
    }

    public final void tuerTous(PisteGraphique pisteGraphique) {
        if (this.listeVer == null) {
            return;
        }
        int n = 0;
        while (n < this.listeVer.size()) {
            Ver ver = this.getVer(n);
            ver.tuerVer(pisteGraphique);
            ++n;
        }
        this.listeVer.removeAllElements();
    }

    public final void initVie() {
        int n = 0;
        while (n < this.listeVer.size()) {
            this.getVer(n).setVie(150.0f);
            ++n;
        }
    }

    public final void tuerVers(int n, PisteGraphique pisteGraphique) {
        int n2 = this.listeVer.size() - 1;
        int n3 = 0;
        while (n2 >= 0 && n3 != n) {
            Ver ver = this.getVer(n2);
            ver.tuerVer(pisteGraphique);
            this.listeVer.removeElementAt(n2);
            ++n3;
            --n2;
        }
    }

    public final void addVer(Ver ver) {
        if (ver != null) {
            this.listeVer.add(ver);
        } else {
            System.err.println(Erreur.getString("erreur_listever_addver"));
        }
    }

    public final void removeAll() {
        if (this.listeVer != null) {
            this.listeVer.removeAllElements();
        }
    }

    public final int getSize() {
        return this.listeVer.size();
    }

    public static ListeVer charger(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        if (string.equals("Default")) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            ListeVer listeVer = (ListeVer)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            return listeVer;
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_listever_charger"));
            return null;
        }
    }

    protected ListeVer mutation(Parametres parametres, PisteGraphique pisteGraphique, ListeVer listeVer, int n, boolean bl) {
        Ver ver = null;
        ListeVer listeVer2 = new ListeVer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Generateur.tirerIntEntre(listeVer.getSize());
            Ver ver2 = listeVer.getVer(n3);
            if (bl) {
                ver = new Ver(pisteGraphique, parametres.getCas(), ver2.getTaille());
                ver.setGenotype((Genotype)ver2.getGenotype().clone());
                ver.getGenotype().mute(parametres.getTauxMutation());
                listeVer2.addVer(ver);
            } else {
                ver2.getGenotype().mute(parametres.getTauxMutation());
            }
            ++n2;
        }
        return listeVer2;
    }

    protected void evolution(Parametres parametres, PisteGraphique pisteGraphique, int n, boolean bl, boolean bl2) {
        int n2 = 0;
        ListeVer listeVer = null;
        ListeVer listeVer2 = null;
        n2 = n * parametres.getNbMutation() / 100;
        if (bl2) {
            if (bl && n % 2 != 0) {
                this.tuerVers(1, pisteGraphique);
                ++n;
            }
            listeVer = this.crossing(parametres, pisteGraphique, n, bl);
            this.mutation(parametres, pisteGraphique, listeVer, n2, !bl2);
            int n3 = 0;
            while (n3 < listeVer.getSize()) {
                Ver ver = (Ver)listeVer.getVer(n3).clone();
                this.addVer(ver);
                ++n3;
            }
            listeVer.removeAll();
        } else {
            Ver ver;
            if (bl && (n - n2) % 2 != 0) {
                this.tuerVers(1, pisteGraphique);
                ++n;
            }
            listeVer2 = this.mutation(parametres, pisteGraphique, this, n2, !bl2);
            listeVer = this.crossing(parametres, pisteGraphique, n - n2, bl);
            int n4 = 0;
            while (n4 < listeVer2.getSize()) {
                ver = (Ver)listeVer2.getVer(n4).clone();
                this.addVer(ver);
                ++n4;
            }
            listeVer2.removeAll();
            n4 = 0;
            while (n4 < listeVer.getSize()) {
                ver = (Ver)listeVer.getVer(n4).clone();
                this.addVer(ver);
                ++n4;
            }
            listeVer.removeAll();
        }
    }

    protected ListeVer crossing(Parametres parametres, PisteGraphique pisteGraphique, int n, boolean bl) {
        int n2 = this.listeVer.size();
        int n3 = 0;
        n3 = bl ? n / 2 : n;
        ListeVer listeVer = new ListeVer(n3);
        if (n2 >= 2) {
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                int n6 = n5 = Generateur.tirerIntEntre(n2);
                while (n5 == n6) {
                    n6 = Generateur.tirerIntEntre(n2);
                }
                Ver ver = this.getVer(n5);
                Ver ver2 = this.getVer(n6);
                Ver ver3 = new Ver(pisteGraphique, parametres.getCas(), ver.getTaille());
                ver3.setGenotype((Genotype)ver.getGenotype().clone());
                Ver ver4 = new Ver(pisteGraphique, parametres.getCas(), ver2.getTaille());
                ver4.setGenotype((Genotype)ver2.getGenotype().clone());
                Genotype genotype = ver3.getGenotype().crossingOver(ver2.getGenotype(), parametres.getTailleTrancheCrossingOver(), parametres.getTauxCrossingOver());
                ver4.setGenotype(genotype);
                if (bl) {
                    listeVer.addVer(ver3);
                    listeVer.addVer(ver4);
                } else if (Generateur.tirerIntEntre(2) == 1) {
                    ver4.tuerVer(pisteGraphique);
                    listeVer.addVer(ver3);
                } else {
                    ver3.tuerVer(pisteGraphique);
                    listeVer.addVer(ver4);
                }
                ++n4;
            }
        }
        return listeVer;
    }

    private void quickSort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.listeVer.size();
        boolean bl = true;
        if (n2 > n) {
            Ver ver;
            Ver ver2 = (Ver)this.getVer(n2).clone();
            while (bl) {
                n3 = n;
                while (n3 < n5) {
                    if (this.getVer(n3).getVie() <= ver2.getVie()) break;
                    ++n3;
                }
                n4 = n2;
                while (n4 >= 0) {
                    if (this.getVer(n4).getVie() > ver2.getVie()) break;
                    --n4;
                }
                if (n3 >= n4) break;
                ver = this.getVer(n3);
                this.listeVer.setElementAt(this.getVer(n4), n3);
                this.listeVer.setElementAt(ver, n4);
            }
            ver = this.getVer(n3);
            this.listeVer.setElementAt(this.getVer(n2), n3);
            this.listeVer.setElementAt(ver, n2);
            this.quickSort(n, n3 - 1);
            this.quickSort(n3 + 1, n2);
        }
    }
}

