/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Adn;
import fr.lifl.Aquarium.Simulation.Generateur;
import fr.lifl.Aquarium.Simulation.Langage;
import java.awt.Color;
import java.io.Serializable;

public class Genotype
implements Serializable,
Cloneable {
    public static boolean COULEUR_HALO = true;
    public static int MIN_TAILLE_HALO = 4;
    public static int MAX_TAILLE_HALO = 25;
    public static final char HALO_PROPORTIONNEL = 'P';
    public static final Color COULEUR_HALO_FIXE = Color.white;
    public static final Color COULEUR_HALO_PROPORTIONNEL = Color.orange;
    public static final char HALO_FIXE = 'F';
    protected Color couleur = Color.white;
    protected int tailleVer = 0;
    protected int tailleHalo;
    protected char typeHalo;
    protected Adn adn = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append(Langage.getString("taille_ver"));
        stringBuffer.append(this.tailleVer);
        stringBuffer.append(", ");
        stringBuffer.append(Langage.getString("taille_halo"));
        stringBuffer.append(this.tailleHalo);
        stringBuffer.append(", ");
        stringBuffer.append(Langage.getString("type_halo"));
        stringBuffer.append(this.typeHalo);
        stringBuffer.append(", Adn=");
        stringBuffer.append(this.adn);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        Genotype genotype = new Genotype();
        genotype.adn = (Adn)this.adn.clone();
        genotype.tailleHalo = this.tailleHalo;
        genotype.typeHalo = this.typeHalo;
        genotype.tailleVer = this.tailleVer;
        genotype.couleur = this.couleur;
        return genotype;
    }

    public void afficheAdn() {
        this.adn.affiche();
    }

    public void crossingOver(Genotype genotype) {
        this.crossingOver(genotype, 1, 50);
    }

    public Genotype(int n, String string) {
        this(string);
        this.setTailleVer(n);
    }

    public void mute(int n) {
        int n2 = Generateur.tirerIntEntre(100);
        if (n2 <= n) {
            this.tailleHalo = Genotype.tirerTailleHalo();
        }
        if ((n2 = Generateur.tirerIntEntre(100)) <= n) {
            this.typeHalo = Genotype.tirerTypeHalo();
        }
        this.colorier();
        int n3 = 1;
        while (n3 <= this.adn.getSize()) {
            n2 = Generateur.tirerIntEntre(100);
            if (n2 <= n) {
                this.adn.mute(n3);
            }
            ++n3;
        }
    }

    public Genotype(int n, char c, String string, int n2) {
        this.tailleHalo = n;
        this.typeHalo = c;
        this.adn = new Adn(string);
        this.setTailleVer(n2);
        this.colorier();
    }

    public Genotype(int n, char c, String string) {
        this(Genotype.tirerTailleHalo(), c, string, n);
    }

    public Genotype(String string) {
        this(Genotype.tirerTailleHalo(), Genotype.tirerTypeHalo(), string, 0);
    }

    public Genotype crossingOver(Genotype genotype, int n, int n2) {
        String string;
        int n3;
        int n4 = 1;
        Genotype genotype2 = (Genotype)genotype.clone();
        int n5 = Generateur.tirerIntEntre(100);
        if (n5 < n2) {
            genotype2.tailleHalo = this.tailleHalo;
            this.tailleHalo = genotype.tailleHalo;
        }
        if ((n5 = Generateur.tirerIntEntre(100)) < n2) {
            genotype2.typeHalo = this.typeHalo;
            this.typeHalo = genotype.typeHalo;
        }
        this.colorier();
        genotype2.colorier();
        int n6 = this.adn.getSize() / n;
        int n7 = 0;
        while (n7 < n6) {
            n5 = Generateur.tirerIntEntre(100);
            if (n5 < n2) {
                n3 = 1;
                while (n3 <= n) {
                    n4 = n7 * n + n3;
                    string = this.adn.getValeurGene(n4);
                    this.adn.setValeurGene(n4, genotype.adn.getValeurGene(n4));
                    genotype2.adn.setValeurGene(n4, string);
                    ++n3;
                }
            }
            ++n7;
        }
        n4 = n6 * n;
        if (n4 < this.adn.getSize() && (n5 = Generateur.tirerIntEntre(100)) < n2) {
            n3 = n4 + 1;
            while (n3 <= this.adn.getSize()) {
                string = this.adn.getValeurGene(n3);
                this.adn.setValeurGene(n3, genotype.adn.getValeurGene(n3));
                genotype2.adn.setValeurGene(n3, string);
                ++n3;
            }
        }
        return genotype2;
    }

    public final String getCas() {
        return this.adn.getCas();
    }

    public final Adn getAdn() {
        return this.adn;
    }

    public final boolean haloEstFixe() {
        return this.typeHalo == 'F';
    }

    public final Color getCouleur() {
        return this.couleur;
    }

    public final char getTypeHalo() {
        return this.typeHalo;
    }

    public final void setTailleHalo(int n) {
        if (n > 0) {
            this.tailleHalo = n;
        }
    }

    public final void setTailleVer(int n) {
        if (n > 0) {
            this.tailleVer = n;
        }
    }

    public final void setTypeHalo(char c) {
        this.typeHalo = c;
        this.colorier();
    }

    public final boolean haloEstProportionnel() {
        return this.typeHalo == 'P';
    }

    public final void setCouleur(Color color) {
        this.couleur = color;
    }

    public final int getTailleVer() {
        return this.tailleVer;
    }

    public final int getTailleHalo() {
        return this.tailleHalo;
    }

    protected Genotype() {
    }

    protected final void colorier() {
        if (COULEUR_HALO) {
            if (this.haloEstFixe()) {
                this.setCouleur(COULEUR_HALO_FIXE);
            }
            if (this.haloEstProportionnel()) {
                this.setCouleur(COULEUR_HALO_PROPORTIONNEL);
            }
        }
    }

    protected static char tirerTypeHalo() {
        if (Generateur.tirerIntEntre(2) == 0) {
            return 'F';
        }
        return 'P';
    }

    protected static int tirerTailleHalo() {
        return Generateur.tirerIntEntre(MIN_TAILLE_HALO, MAX_TAILLE_HALO);
    }
}

