/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Aquarium;
import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.Generateur;
import fr.lifl.Aquarium.Simulation.Genotype;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.ListeVer;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.Piste;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import fr.lifl.Aquarium.Simulation.Ver;
import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;

public class AquariumGraphique
extends Aquarium
implements Runnable {
    protected PisteGraphique pisteGraphique = null;

    public AquariumGraphique() {
    }

    public AquariumGraphique(Parametres parametres) {
        this(parametres, new PisteGraphique(parametres.getTaillePiste()));
    }

    public AquariumGraphique(Parametres parametres, PisteGraphique pisteGraphique) {
        this.generation = 0;
        this.parametres = parametres;
        this.pisteGraphique = pisteGraphique;
        this.piste = pisteGraphique.getPiste();
        this.pisteGraphique.entourrer();
        this.pisteGraphique.lierTableNourriture(parametres.getTableNourriture());
    }

    public void creerVers() {
        this.creerVers(this.parametres.getNbVer());
    }

    public void creerVers(int n) {
        if (this.listeVer == null) {
            this.listeVer = new ListeVer(n);
        }
        if (this.parametres.getNbHaloFixe() < 0) {
            int n2 = 0;
            while (n2 < n) {
                Ver ver = new Ver(this.pisteGraphique, this.parametres.getCas(), this.parametres.getTailleVer());
                this.listeVer.addVer(ver);
                ++n2;
            }
        } else {
            int n3 = n * this.parametres.getNbHaloFixe() / 100;
            this.creerVers(n3, 'F');
            this.creerVers(n - n3, 'P');
        }
    }

    public void run() {
        this.jeu(this.parametres.getDeuxFils(), this.parametres.getCrossEtMute());
    }

    public void jeu(boolean bl, boolean bl2) {
        if (this.listeVer == null) {
            return;
        }
        this.pisteGraphique.affichePiste(this.parametres.getTableNourriture(), this.listeVer);
        while (GestionSimulation.ETAT_COURANT != 0) {
            ListeVer listeVer;
            int n;
            System.out.println("|-----> Generation " + this.generation);
            if (this.generation % this.parametres.getPeriodeSevrage() == 0 && GestionSimulation.NOURRIRE_MANUELLEMENT) {
                this.pisteGraphique.mousePressed(null);
            }
            PisteGraphique pisteGraphique = this.pisteGraphique;
            synchronized (pisteGraphique) {
                this.pisteGraphique.repaint();
            }
            this.listeVer.incAllGeneration();
            int n2 = this.parametres.getPeriodeEvolution();
            if (n2 != 0) {
                while (n2 >= 0) {
                    if (GestionSimulation.ETAT_COURANT == 0) break;
                    n = 0;
                    while (n < this.listeVer.getSize()) {
                        if (GestionSimulation.ETAT_COURANT == 0) break;
                        this.listeVer.getVer(n).deplacer(this.parametres.getTableNourriture(), this.pisteGraphique, this.parametres.getCoutDeplacement(), this.parametres.getCoeffAjustementHalo());
                        ++n;
                    }
                    this.pisteGraphique.repaint();
                    try {
                        Thread.sleep(this.parametres.vitesse);
                    }
                    catch (Exception exception) {
                        System.err.println(Erreur.getString("erreur_aquariumgraphique_jeu"));
                    }
                    --n2;
                }
            } else if (n2 == 0) {
                while (n2 == 0) {
                    if (GestionSimulation.ETAT_COURANT != 0) {
                        n = 0;
                        while (n < this.listeVer.getSize()) {
                            if (GestionSimulation.ETAT_COURANT == 0) break;
                            this.listeVer.getVer(n).deplacer(this.parametres.getTableNourriture(), this.pisteGraphique, this.parametres.getCoutDeplacement(), this.parametres.getCoeffAjustementHalo());
                            ++n;
                        }
                        this.pisteGraphique.repaint();
                        try {
                            Thread.sleep(this.parametres.vitesse);
                        }
                        catch (Exception exception) {
                            System.err.println(Erreur.getString("erreur_aquariumgraphique_jeu"));
                        }
                        continue;
                    }
                    break;
                }
            }
            int n3 = this.listeVer.getSize();
            int n4 = n3 * this.parametres.getNbVerTue() / 100;
            if (this.listeVer.getSize() >= 2) {
                listeVer = this.listeVer;
                synchronized (listeVer) {
                    this.listeVer.quickSort();
                }
                ListeVer listeVer2 = this.listeVer;
                synchronized (listeVer2) {
                    this.listeVer.tuerVers(n4, this.pisteGraphique);
                }
                ListeVer listeVer3 = this.listeVer;
                synchronized (listeVer3) {
                    this.listeVer.evolution(this.parametres, this.pisteGraphique, n4, bl, bl2);
                }
            }
            if (GestionSimulation.TEXT) {
                listeVer = this.listeVer;
                synchronized (listeVer) {
                    System.out.println(this.listeVer.informer());
                }
                ListeVer listeVer4 = this.listeVer;
                synchronized (listeVer4) {
                    System.out.println(this.listeVer);
                }
            }
            listeVer = this.listeVer;
            synchronized (listeVer) {
                this.listeVer.initVie();
            }
            ++this.generation;
        }
        this.init();
    }

    public void init() {
        if (this.listeVer != null) {
            this.listeVer.tuerTous(this.pisteGraphique);
        }
        this.pisteGraphique.initAll();
        this.pisteGraphique.entourrer();
        this.generation = 0;
    }

    public void creerVers(int n, char c) {
        if (this.listeVer == null) {
            this.listeVer = new ListeVer(n);
        }
        int n2 = 0;
        while (n2 < n) {
            Ver ver = new Ver(this.pisteGraphique, this.parametres.getCas(), this.parametres.getTailleVer(), c);
            this.listeVer.addVer(ver);
            ++n2;
        }
    }

    public final String experienceType(int n) {
        this.init();
        Ver ver = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Generateur.tirerIntEntre(100);
        int n3 = this.parametres.getNbHaloFixe();
        switch (n) {
            case 0: {
                this.creerVers(this.parametres.getNbVer());
                this.pisteGraphique.placerNourriture(100, this.parametres.getTableNourriture());
                stringBuffer.append(Langage.getString("tout_hazard"));
                break;
            }
            case 1: {
                this.creerVers(this.parametres.getNbVer() - 1);
                ver = new Ver(this.pisteGraphique, null, this.parametres.getCas(), this.parametres.getTailleVer(), true, this.parametres.getTableNourriture());
                if (n3 != -1) {
                    if (n2 < n3) {
                        ver.getGenotype().setTypeHalo('F');
                    } else {
                        ver.getGenotype().setTypeHalo('P');
                    }
                }
                ver.setColor(Color.red);
                this.listeVer.addVer(ver);
                this.pisteGraphique.placerNourriture(100, this.parametres.getTableNourriture());
                stringBuffer.append(Langage.getString("tout_un_malin_tous_betes"));
                break;
            }
            case 2: {
                ver = new Ver(this.pisteGraphique, null, this.parametres.getCas(), this.parametres.getTailleVer(), true, this.parametres.getTableNourriture());
                if (n3 != -1) {
                    if (n2 < n3) {
                        ver.getGenotype().setTypeHalo('F');
                    } else {
                        ver.getGenotype().setTypeHalo('P');
                    }
                }
                ver.setColor(Color.red);
                this.listeVer.addVer(ver);
                stringBuffer.append(Langage.getString("un_malin_tout_seul"));
                break;
            }
            case 3: {
                int n4 = this.parametres.getNbVer() / 2;
                int n5 = this.parametres.getNbVer() - n4;
                this.creerVers(n4, 'F');
                this.creerVers(n5, 'P');
                stringBuffer.append("????");
                break;
            }
            case 4: {
                n2 = n3 * this.parametres.getNbVer() / 100;
                int n6 = 0;
                while (n6 < n2) {
                    ver = new Ver(this.pisteGraphique, null, this.parametres.getCas(), this.parametres.getTailleVer(), 'F', true, this.parametres.getTableNourriture());
                    this.listeVer.addVer(ver);
                    ++n6;
                }
                n6 = n2;
                while (n6 < this.parametres.getNbVer()) {
                    ver = new Ver(this.pisteGraphique, null, this.parametres.getCas(), this.parametres.getTailleVer(), 'P', true, this.parametres.getTableNourriture());
                    this.listeVer.addVer(ver);
                    ++n6;
                }
                stringBuffer.append(Langage.getString("tous_intelligent"));
                break;
            }
            case 5: {
                int n7 = 2;
                int n8 = 10;
                Nourriture nourriture = this.parametres.getTableNourriture().getBestNourriture();
                Point point = new Point(this.piste.getTailleX() / 4, this.piste.getTailleY() / 4);
                ver = new Ver(this.pisteGraphique, point, this.parametres.getCas(), 5, true, this.parametres.getTableNourriture());
                ver.getGenotype().setTailleHalo(Genotype.MAX_TAILLE_HALO);
                ver.getGenotype().setTypeHalo('P');
                int n9 = 0;
                while (n9 < 5) {
                    this.pisteGraphique.setCaseVide((Point)ver.getPosition().elementAt(n9));
                    ++n9;
                }
                Vector<Point> vector = new Vector<Point>();
                vector.add(point);
                vector.add(new Point(point.x, point.y + 1));
                vector.add(new Point(point.x, point.y + 2));
                vector.add(new Point(point.x, point.y + 3));
                vector.add(new Point(point.x, point.y + 4));
                ver.setPosition(vector);
                n9 = 0;
                while (n9 < 5) {
                    this.pisteGraphique.setCaseVide((Point)vector.elementAt(n9));
                    ++n9;
                }
                ver.setDirection('F');
                this.pisteGraphique.creerMur(point.x - n7, point.y - n8, point.x + n7, point.y - n8);
                this.pisteGraphique.creerMur(point.x - n7, point.y - n8, point.x - n7, point.y + 30);
                this.pisteGraphique.creerMur(point.x + n7, point.y - n8, point.x + n7, point.y + 30);
                this.pisteGraphique.placerNourriture(point.x, point.y - n8 / 2, nourriture);
                this.listeVer.addVer(ver);
                stringBuffer.append(Langage.getString("eprouvette"));
            }
        }
        return stringBuffer.toString();
    }

    public final void setParametres(Parametres parametres) {
        this.parametres = parametres;
        this.pisteGraphique.lierTableNourriture(parametres.getTableNourriture());
    }

    public final void setAquarium(Aquarium aquarium) {
        if (aquarium != null) {
            this.pisteGraphique.setPiste(aquarium.piste);
            this.listeVer = aquarium.listeVer;
            this.parametres = aquarium.parametres;
            this.generation = aquarium.generation;
        }
    }

    public final void setPisteGraphique(PisteGraphique pisteGraphique) {
        if (this.listeVer != null) {
            this.listeVer.tuerTous(this.pisteGraphique);
        }
        this.pisteGraphique = pisteGraphique;
        this.pisteGraphique.entourrer();
        this.pisteGraphique.lierTableNourriture(this.parametres.getTableNourriture());
    }

    public final PisteGraphique getPisteGraphique() {
        return this.pisteGraphique;
    }

    public static void main(String[] stringArray) {
        Parametres parametres = null;
        PisteGraphique pisteGraphique = null;
        ListeVer listeVer = null;
        GestionSimulation.ETAT_COURANT = 3;
        GestionSimulation.TEXT = true;
        if (stringArray != null) {
            Serializable serializable;
            parametres = stringArray.length > 2 ? Parametres.charger(stringArray[2]) : new Parametres();
            pisteGraphique = new PisteGraphique(parametres.getTaillePiste());
            if (stringArray.length > 3 && (serializable = Piste.charger(stringArray[3])) != null) {
                pisteGraphique.setPiste((Piste)serializable);
            }
            if (stringArray.length > 4) {
                listeVer = ListeVer.charger(stringArray[4]);
            }
            serializable = new AquariumGraphique(parametres, pisteGraphique);
            if (listeVer != null) {
                ((Aquarium)serializable).setListeVer(listeVer);
            } else {
                ((AquariumGraphique)serializable).creerVers();
            }
            ((AquariumGraphique)serializable).jeu(true, true);
        }
    }
}

