/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Simulation;

import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.ListeVer;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.Piste;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Aquarium
implements Serializable {
    protected ListeVer listeVer = null;
    protected int generation;
    protected Parametres parametres = null;
    protected Piste piste = null;
    protected String nomFichier = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        stringBuffer.append(this.listeVer);
        stringBuffer.append('\n');
        stringBuffer.append(this.parametres);
        stringBuffer.append('\n');
        stringBuffer.append(this.piste);
        return stringBuffer.toString();
    }

    public boolean sauver(String string) {
        boolean bl = false;
        if (string == null && this.nomFichier == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        if (string != null && this.nomFichier == null) {
            this.nomFichier = string;
        }
        try {
            boolean bl2 = true;
            bl2 = bl2 && this.parametres.sauver(this.nomFichier + ".par");
            bl2 = bl2 && this.piste.sauver(this.nomFichier + ".pis");
            bl2 = bl2 && this.listeVer.sauver(this.nomFichier + ".lis");
            boolean bl3 = bl2 = bl2 && this.sauverGeneration(this.nomFichier);
            if (!bl2) {
                System.err.println(Erreur.getString("erreur_aquarium_sauver"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(Erreur.getString("erreur_aquarium_sauver"));
            return false;
        }
        return true;
    }

    public final void setListeVer(ListeVer listeVer) {
        this.listeVer = listeVer;
    }

    public final void setNomFichier(String string) {
        this.nomFichier = string;
    }

    public final Piste getPiste() {
        return this.piste;
    }

    public final Parametres getParametres() {
        return this.parametres;
    }

    public final String getNomFichier() {
        return this.nomFichier;
    }

    public final ListeVer getListeVer() {
        if (this.listeVer == null) {
            this.listeVer = new ListeVer();
        }
        return this.listeVer;
    }

    public static Aquarium charger(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        Aquarium aquarium = null;
        try {
            aquarium = new Aquarium();
            aquarium.listeVer = ListeVer.charger(string + ".lis");
            aquarium.piste = Piste.charger(string + ".pis");
            aquarium.parametres = Parametres.charger(string + ".par");
            aquarium.generation = Aquarium.chargerGeneration(string);
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_aquarium_charger"));
            return null;
        }
        return aquarium;
    }

    public static Aquarium charger(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if (string.trim().equals("") && string2.trim().equals("")) {
            return null;
        }
        if (string.trim().equals("Default") || string2.trim().equals("Default")) {
            return null;
        }
        Aquarium aquarium = null;
        try {
            aquarium = new Aquarium();
            aquarium.listeVer = ListeVer.charger(string2);
            aquarium.piste = Piste.charger(string);
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_aquarium_charger"));
            return null;
        }
        return aquarium;
    }

    private final boolean sauverGeneration(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(new Integer(this.generation));
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(Erreur.getString("erreur_aquarium_sauver"));
            return false;
        }
        return true;
    }

    private static final int chargerGeneration(String string) {
        if (string == null) {
            return 0;
        }
        if (string.trim().equals("")) {
            return 0;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Integer n = (Integer)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            if (n != null) {
                return n;
            }
        }
        catch (Exception exception) {
            System.err.println(Erreur.getString("erreur_aquarium_sauver"));
        }
        return 0;
    }
}

