/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Ihm;

import fr.lifl.Aquarium.Ihm.BarreOutilsPrincipale;
import fr.lifl.Aquarium.Ihm.BoiteEntouree;
import fr.lifl.Aquarium.Ihm.FenetreAPropos;
import fr.lifl.Aquarium.Ihm.FenetreDialog;
import fr.lifl.Aquarium.Ihm.FenetreParametre;
import fr.lifl.Aquarium.Ihm.MenuFenetrePrincipale;
import fr.lifl.Aquarium.Ihm.NomIcones;
import fr.lifl.Aquarium.Ihm.Panneau;
import fr.lifl.Aquarium.Ihm.SuperFenetre;
import fr.lifl.Aquarium.Simulation.Aquarium;
import fr.lifl.Aquarium.Simulation.AquariumGraphique;
import fr.lifl.Aquarium.Simulation.Erreur;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Parametres;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JScrollPane;

public class FenetrePrincipale
extends SuperFenetre {
    protected Parametres parametres = null;
    private JScrollPane jScrollPane1 = null;
    private MenuFenetrePrincipale menu = null;
    private JScrollPane jScrollPane2 = null;
    private AquariumGraphique aquarium = null;
    private Panneau panneauInformation = null;
    private BarreOutilsPrincipale barre = null;
    private Thread thread = null;
    private PisteGraphique dessin = null;

    public void sauverSous() {
        if (this.aquarium != null) {
            String string = this.aquarium.getNomFichier();
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog((Frame)this, Langage.getString("sauver") + " " + Langage.getString("aquarium"), 1);
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() != null) {
                string = fileDialog.getDirectory() + fileDialog.getFile();
            }
            fileDialog.dispose();
            frame.dispose();
            AquariumGraphique aquariumGraphique = this.aquarium;
            synchronized (aquariumGraphique) {
                if (!this.aquarium.sauver(string)) {
                    this.panneauInformation.append(Erreur.getString("erreur_fenetreprincipale_sauver"));
                }
            }
        }
    }

    public void sauverPanneau() {
        String string = null;
        FileDialog fileDialog = new FileDialog((Frame)this, Langage.getString("sauver"), 1);
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            string = fileDialog.getDirectory() + fileDialog.getFile();
            fileDialog.dispose();
            if (!this.panneauInformation.sauver(string)) {
                FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("impossible_de_sauver"), 5);
            }
        } else {
            fileDialog.dispose();
        }
    }

    public void sauver() {
        if (this.aquarium != null) {
            Serializable serializable;
            String string = this.aquarium.getNomFichier();
            if (string == null) {
                serializable = new Frame();
                FileDialog fileDialog = new FileDialog((Frame)this, Langage.getString("sauver") + " " + Langage.getString("aquarium"), 1);
                ((Component)fileDialog).setVisible(true);
                if (fileDialog.getFile() != null) {
                    string = fileDialog.getDirectory() + fileDialog.getFile();
                }
                fileDialog.dispose();
                ((Window)serializable).dispose();
            }
            serializable = this.aquarium;
            synchronized (serializable) {
                if (!this.aquarium.sauver(string)) {
                    this.panneauInformation.append(Erreur.getString("erreur_fenetreprincipale_sauver"));
                }
            }
        }
    }

    public BarreOutilsPrincipale getBarre() {
        return this.barre;
    }

    public void creerAquarium() {
        if (this.isVisible()) {
            if (this.aquarium != null) {
                if (!this.parametres.getTaillePiste().equals(this.aquarium.getPisteGraphique().getTaille())) {
                    this.jScrollPane2.getViewport().remove(this.dessin);
                    this.dessin = new PisteGraphique(this.parametres.getTaillePiste());
                    this.jScrollPane2.getViewport().add(this.dessin);
                    this.aquarium.setPisteGraphique(this.dessin);
                    this.pack();
                }
            } else {
                this.dessin = new PisteGraphique(this.parametres.getTaillePiste());
                this.jScrollPane2.getViewport().add(this.dessin);
                this.aquarium = new AquariumGraphique(this.parametres, this.dessin);
                this.pack();
                this.centrer();
            }
            this.panneauInformation.effacer();
            if (this.aquarium.getNomFichier() == null) {
                this.panneauInformation.append(this.aquarium.experienceType(this.menu.getExperienceNb()));
            }
        }
    }

    public void accelerer() {
        if (GestionSimulation.ETAT_COURANT == 1) {
            this.menu.accelerer();
            this.barre.accelerer();
            if (this.aquarium != null) {
                this.aquarium.getPisteGraphique().initGraphique();
                this.aquarium.getPisteGraphique().repaint();
            }
            GestionSimulation.ETAT_COURANT = 3;
        }
    }

    public void aide() {
    }

    public void arreter() {
        this.menu.arreter();
        this.barre.arreter();
        GestionSimulation.ETAT_COURANT = 0;
        if (this.thread != null) {
            this.thread.resume();
        }
        this.aquarium.setNomFichier(null);
    }

    public void quitter() {
        GestionSimulation.ETAT_COURANT = 0;
        this.fermerFenetre();
    }

    public FenetrePrincipale(Parametres parametres) {
        this.setTitle(Langage.getString("titre_fenetre_principale"));
        this.setIcone(NomIcones.NOM_IMG_PRICIPALE_I);
        this.parametres = parametres != null ? parametres : new Parametres();
        this.panneauInformation = new Panneau();
        this.panneauInformation.setEditable(false);
        this.menu = new MenuFenetrePrincipale(this);
        this.barre = new BarreOutilsPrincipale(this);
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.setJMenuBar(this.menu);
        this.contentPane.add((Component)this.barre, "North");
        this.contentPane.add((Component)new Label(), "East");
        this.contentPane.add((Component)new Label(), "West");
        BoiteEntouree boiteEntouree = new BoiteEntouree(Langage.getString("information"));
        boiteEntouree.setLayout(new GridLayout(1, 1));
        this.jScrollPane1.setOpaque(true);
        this.jScrollPane1.getViewport().add(this.panneauInformation);
        boiteEntouree.add(this.jScrollPane1);
        this.contentPane.add((Component)boiteEntouree, "South");
        this.contentPane.add((Component)this.jScrollPane2, "Center");
        ((Component)this).setSize(SuperFenetre.NORMAL);
        this.centrer();
        ((Component)this).setVisible(true);
    }

    public void pause() {
        if (GestionSimulation.ETAT_COURANT == 1) {
            this.menu.pause();
            this.barre.pause();
            if (this.thread != null) {
                this.thread.suspend();
            }
            GestionSimulation.ETAT_COURANT = 2;
        }
    }

    public void afficheParametre() {
        FenetreParametre fenetreParametre = new FenetreParametre(this);
    }

    public void lister() {
        if (this.aquarium != null && GestionSimulation.ETAT_COURANT != 0) {
            if (this.aquarium.getListeVer() == null) {
                return;
            }
            this.panneauInformation.append(this.aquarium.getListeVer().afficherVers());
        }
    }

    public void aPropos() {
        FenetreAPropos fenetreAPropos = new FenetreAPropos(this);
        ((Component)fenetreAPropos).setVisible(true);
    }

    public void lancer() {
        this.menu.lancer();
        this.barre.lancer();
        if (GestionSimulation.ETAT_COURANT == 2 && this.thread != null) {
            this.thread.resume();
        }
        if (GestionSimulation.ETAT_COURANT == 0) {
            this.creerAquarium();
            GestionSimulation.ETAT_COURANT = 1;
            this.thread = new Thread(this.aquarium);
            this.thread.start();
            this.thread.setPriority(4);
        }
        if (GestionSimulation.ETAT_COURANT == 3) {
            GestionSimulation.ETAT_COURANT = 1;
            this.aquarium.getPisteGraphique().affichePiste(this.parametres.getTableNourriture(), this.aquarium.getListeVer());
        }
        GestionSimulation.ETAT_COURANT = 1;
    }

    public MenuFenetrePrincipale getMenu() {
        return this.menu;
    }

    public void informer() {
        if (this.aquarium != null && GestionSimulation.ETAT_COURANT != 0) {
            if (this.aquarium.getListeVer() == null) {
                return;
            }
            this.panneauInformation.append(this.aquarium.getListeVer().informer());
        }
    }

    public void chargerPanneau() {
        String string = null;
        FileDialog fileDialog = new FileDialog((Frame)this, Langage.getString("charger"), 0);
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            string = fileDialog.getDirectory() + fileDialog.getFile();
            fileDialog.dispose();
            if (!this.panneauInformation.charger(string)) {
                FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("impossible_de_charger"), 5);
            }
        } else {
            fileDialog.dispose();
        }
    }

    public FenetrePrincipale() {
        this(new Parametres());
    }

    public void effacer() {
        this.panneauInformation.effacer();
    }

    public FenetrePrincipale(String[] stringArray) {
        this();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray != null) {
            if (stringArray.length > 2) {
                string = stringArray[2];
            }
            if (stringArray.length > 3) {
                string2 = stringArray[3];
            }
            if (stringArray.length > 4) {
                string3 = stringArray[4];
            }
        }
        this.charger(string, string2, string3);
    }

    public void charger() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog((Frame)this, Langage.getString("charger") + " " + Langage.getString("aquarium"), 0);
        ((Component)fileDialog).setVisible(true);
        String string = null;
        if (fileDialog.getFile() != null) {
            string = fileDialog.getDirectory() + fileDialog.getFile();
        }
        fileDialog.dispose();
        frame.dispose();
        if (string == null) {
            return;
        }
        if (string.trim().equals("")) {
            return;
        }
        Aquarium aquarium = null;
        if (this.aquarium == null) {
            this.parametres = Parametres.charger(string + ".par");
            this.dessin = new PisteGraphique(this.parametres.getTaillePiste());
            this.jScrollPane2.getViewport().add(this.dessin);
            this.aquarium = new AquariumGraphique(this.parametres, this.dessin);
        }
        if ((aquarium = Aquarium.charger(string)) == null) {
            return;
        }
        this.aquarium.setAquarium(aquarium);
        this.aquarium.setNomFichier(string);
        this.setParametres(aquarium.getParametres());
    }

    public final boolean setParametres(Parametres parametres) {
        if (parametres == null) {
            return false;
        }
        this.parametres = parametres;
        this.barre.remplirComboNourriture(parametres.getTableNourriture());
        if (this.aquarium != null) {
            this.aquarium.setParametres(this.parametres);
        }
        return true;
    }

    public final Parametres getParametres() {
        return this.parametres;
    }

    public static void main(String[] stringArray) {
        FenetrePrincipale fenetrePrincipale = new FenetrePrincipale(stringArray);
        ((Component)fenetrePrincipale).setVisible(true);
    }

    protected void charger(String string, String string2, String string3) {
        Aquarium aquarium = null;
        if (this.aquarium == null) {
            this.parametres = Parametres.charger(string);
            this.dessin = new PisteGraphique(this.parametres.getTaillePiste());
            this.jScrollPane2.getViewport().add(this.dessin);
            this.aquarium = new AquariumGraphique(this.parametres, this.dessin);
        }
        if ((aquarium = Aquarium.charger(string2, string3)) == null) {
            return;
        }
        this.aquarium.setAquarium(aquarium);
        this.aquarium.setNomFichier(null);
        this.setParametres(aquarium.getParametres());
    }
}

