/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Ihm;

import fr.lifl.Aquarium.Ihm.BoiteEntouree;
import fr.lifl.Aquarium.Ihm.FenetreDialog;
import fr.lifl.Aquarium.Ihm.FenetreParametre;
import fr.lifl.Aquarium.Ihm.SuperDialog;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Nourriture;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FenetreConfigurerTableNourriture
extends SuperDialog {
    private TextField tfValeur = null;
    private Button buttonAnnuler = null;
    private List listType = null;
    private Button buttonOk = null;
    private Button buttonCharger = null;
    private FenetreParametre fenetreMere = null;
    private List listCouleur = null;
    private List listTableFaite = null;
    private Button buttonSauver = null;
    private Button buttonRetirer = null;
    private Button buttonAjouter = null;

    public FenetreConfigurerTableNourriture(FenetreParametre fenetreParametre) {
        super(fenetreParametre);
        this.setTitle(Langage.getString("titre_fenetre_conf_table"));
        this.fenetreMere = fenetreParametre;
        this.contentPane.setLayout(new BorderLayout());
        this.buttonAnnuler = new Button(Langage.getString("annuler"));
        this.buttonOk = new Button(Langage.getString("ok"));
        this.buttonCharger = new Button(Langage.getString("charger"));
        this.buttonSauver = new Button(Langage.getString("sauver"));
        this.buttonAjouter = new Button(Langage.getString("ajouter"));
        this.buttonRetirer = new Button(Langage.getString("retirer"));
        this.tfValeur = new TextField("");
        this.tfValeur.setBackground(Color.white);
        this.listType = new List();
        this.listType.setBackground(Color.white);
        this.listTableFaite = new List();
        this.listTableFaite.setBackground(Color.white);
        this.listCouleur = new List();
        this.listCouleur.setBackground(Color.white);
        this.init();
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerTableNourriture.this.actionOk();
            }
        });
        this.buttonAnnuler.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerTableNourriture.this.actionAnnuler();
            }
        });
        this.buttonCharger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerTableNourriture.this.actionCharger();
            }
        });
        this.buttonSauver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerTableNourriture.this.actionSauver();
            }
        });
        this.buttonAjouter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerTableNourriture.this.actionAjouter();
            }
        });
        this.buttonRetirer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerTableNourriture.this.actionRetirer();
            }
        });
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 4, 4));
        panel.add(this.buttonCharger);
        panel.add(new Label(""));
        panel.add(this.buttonSauver);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3, 4, 4));
        panel2.add(this.buttonAnnuler);
        panel2.add(new Label(""));
        panel2.add(this.buttonOk);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 1, 2, 2));
        BoiteEntouree boiteEntouree = new BoiteEntouree(Langage.getString("construisez_votre_nourriture"));
        boiteEntouree.setLayout(new GridLayout(2, 3, 2, 2));
        boiteEntouree.add(this.listType);
        boiteEntouree.add(this.listCouleur);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(3, 1));
        panel4.add(new Label(Langage.getString("valeur")));
        panel4.add(this.tfValeur);
        panel4.add(new Label(""));
        boiteEntouree.add(panel4);
        boiteEntouree.add(new Label(""));
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(3, 1));
        panel5.add(new Label(""));
        panel5.add(this.buttonAjouter);
        panel5.add(new Label(""));
        boiteEntouree.add(panel5);
        panel3.add(boiteEntouree);
        BoiteEntouree boiteEntouree2 = new BoiteEntouree(Langage.getString("la_table_nourriture"));
        boiteEntouree2.setLayout(new GridLayout(2, 1, 2, 2));
        boiteEntouree2.add(this.listTableFaite);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(3, 3));
        panel6.add(new Label(""));
        panel6.add(new Label(""));
        panel6.add(new Label(""));
        panel6.add(new Label(""));
        panel6.add(this.buttonRetirer);
        panel6.add(new Label(""));
        panel6.add(new Label(""));
        panel6.add(new Label(""));
        panel6.add(new Label(""));
        boiteEntouree2.add(panel6);
        panel3.add(boiteEntouree2);
        this.contentPane.add((Component)panel3, "Center");
        this.contentPane.add((Component)panel, "North");
        this.contentPane.add((Component)panel2, "South");
        this.setTableNourritureToList(this.fenetreMere.getParametres().getTableNourriture());
        this.pack();
        this.centrer();
        ((Component)this).setVisible(true);
    }

    protected void actionSauver() {
        if (!this.sauver()) {
            Frame frame = new Frame();
            FenetreDialog.afficher(frame, Langage.getString("erreur"), Langage.getString("format_numerique"), 5);
        }
    }

    protected void actionRetirer() {
        int n = 0;
        String string = null;
        try {
            string = this.listTableFaite.getSelectedItem();
            this.listTableFaite.remove(string);
            while (string.charAt(n) != '\'') {
                ++n;
            }
            this.listType.add(string.substring(++n, n + 1));
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void actionOk() {
        if (this.listTableFaite.getItemCount() != 0) {
            this.fenetreMere.setTableNourriture(this.setListToTableNourriture());
            this.fermerFenetre();
        } else {
            FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("format_numerique"), 5);
        }
    }

    protected void actionCharger() {
        if (!this.charger()) {
            Frame frame = new Frame();
            FenetreDialog.afficher(frame, Langage.getString("erreur"), Langage.getString("format_numerique"), 5);
        }
    }

    protected void actionAnnuler() {
        this.fermerFenetre();
    }

    protected void actionAjouter() {
        String string = null;
        float f = Float.MAX_VALUE;
        String string2 = null;
        try {
            string2 = this.listType.getSelectedItem();
            string = this.listCouleur.getSelectedItem();
            f = Float.parseFloat(this.tfValeur.getText());
            if (string2 != null && string != null && f != Float.MAX_VALUE) {
                this.listTableFaite.add("('" + string2 + "'," + f + "," + string + ")");
                this.listType.remove(string2);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private boolean sauver() {
        boolean bl = false;
        String string = null;
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, Langage.getString("sauver") + " " + Langage.getString("table_nourriture"), 1);
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() == null) {
            fileDialog.dispose();
            frame.dispose();
            return false;
        }
        string = fileDialog.getDirectory() + fileDialog.getFile();
        fileDialog.dispose();
        frame.dispose();
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        TableNourriture tableNourriture = this.setListToTableNourriture();
        return tableNourriture.sauver(string);
    }

    private void init() {
        this.listType.removeAll();
        this.listCouleur.removeAll();
        this.listTableFaite.removeAll();
        int n = 0;
        while (n < TableNourriture.tableType.length) {
            this.listType.add("" + TableNourriture.tableType[n]);
            ++n;
        }
        n = 0;
        while (n < TableNourriture.tableCouleur.length) {
            this.listCouleur.add(Nourriture.colorToString(TableNourriture.tableCouleur[n]));
            ++n;
        }
    }

    private boolean charger() {
        Object var2_1 = null;
        String string = null;
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, Langage.getString("charger") + " " + Langage.getString("table_nourriture"), 0);
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() == null) {
            fileDialog.dispose();
            frame.dispose();
            return false;
        }
        string = fileDialog.getDirectory() + fileDialog.getFile();
        fileDialog.dispose();
        frame.dispose();
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        TableNourriture tableNourriture = null;
        tableNourriture = TableNourriture.charger(string);
        if (tableNourriture == null) {
            return false;
        }
        this.setTableNourritureToList(tableNourriture);
        return true;
    }

    private TableNourriture setListToTableNourriture() {
        TableNourriture tableNourriture = new TableNourriture();
        int n = 0;
        while (n < this.listTableFaite.getItemCount()) {
            int n2 = 5;
            String string = this.listTableFaite.getItem(n);
            while (string.charAt(n2) != ',') {
                ++n2;
            }
            Nourriture nourriture = new Nourriture(string.substring(2, 3).charAt(0), Float.parseFloat(string.substring(5, n2)));
            nourriture.setCouleur(Nourriture.stringToColor(string.substring(n2 + 1, string.length() - 1)));
            tableNourriture.putNourriture(nourriture);
            ++n;
        }
        return tableNourriture;
    }

    private void setTableNourritureToList(TableNourriture tableNourriture) {
        if (tableNourriture == null) {
            return;
        }
        Nourriture[] nourritureArray = tableNourriture.lister();
        try {
            this.init();
            int n = 0;
            while (n < nourritureArray.length) {
                this.listTableFaite.add("('" + nourritureArray[n].getType() + "'," + nourritureArray[n].getValeur() + "," + Nourriture.colorToString(nourritureArray[n].getCouleur()) + ")");
                this.listType.remove("" + nourritureArray[n].getType());
                ++n;
            }
        }
        catch (Exception exception) {
            this.init();
        }
    }
}

