/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Ihm;

import fr.lifl.Aquarium.Ihm.BoiteEntouree;
import fr.lifl.Aquarium.Ihm.FenetreDialog;
import fr.lifl.Aquarium.Ihm.FenetreParametre;
import fr.lifl.Aquarium.Ihm.SuperDialog;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.Parametres;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FenetreConfigurerAlgoGenetic
extends SuperDialog {
    private Checkbox cbCroosEtMute = null;
    private Checkbox cbDeuxFils = null;
    private TextField tfTailleTranche = null;
    private TextField tfTauxMutation = null;
    private Checkbox cbUnFils = null;
    private Button buttonAnnuler = null;
    private TextField tfTauxCrossingOver = null;
    private TextField tfNbMutation = null;
    private CheckboxGroup cbgCrossEtMute = null;
    private Button buttonOk = null;
    private Checkbox cbNonCroosEtMute = null;
    private FenetreParametre fenetreMere = null;
    private CheckboxGroup cbgDeuxFils = null;

    public FenetreConfigurerAlgoGenetic(FenetreParametre fenetreParametre) {
        super(fenetreParametre);
        this.fenetreMere = fenetreParametre;
        this.setTitle(Langage.getString("titre_fenetre_conf_algo"));
        this.contentPane.setLayout(new BorderLayout());
        this.tfTauxMutation = new TextField();
        this.tfNbMutation = new TextField();
        this.tfTauxCrossingOver = new TextField();
        this.tfTailleTranche = new TextField();
        this.cbgDeuxFils = new CheckboxGroup();
        this.cbgCrossEtMute = new CheckboxGroup();
        this.cbDeuxFils = new Checkbox(Langage.getString("deux_fils"));
        this.cbUnFils = new Checkbox(Langage.getString("un_fils"));
        this.cbUnFils.setCheckboxGroup(this.cbgDeuxFils);
        this.cbDeuxFils.setCheckboxGroup(this.cbgDeuxFils);
        this.cbCroosEtMute = new Checkbox(Langage.getString("cross_et_mute"));
        this.cbNonCroosEtMute = new Checkbox(Langage.getString("cross_non_mute"));
        this.cbCroosEtMute.setCheckboxGroup(this.cbgCrossEtMute);
        this.cbNonCroosEtMute.setCheckboxGroup(this.cbgCrossEtMute);
        this.buttonOk = new Button(Langage.getString("ok"));
        this.buttonAnnuler = new Button(Langage.getString("annuler"));
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerAlgoGenetic.this.actionOk();
            }
        });
        this.buttonAnnuler.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreConfigurerAlgoGenetic.this.actionAnnuler();
            }
        });
        BoiteEntouree boiteEntouree = new BoiteEntouree(Langage.getString("titre_boite_taux"));
        boiteEntouree.setLayout(new GridLayout(4, 2, 5, 5));
        boiteEntouree.add(new Label(Langage.getString("taux_mutation"), 2));
        boiteEntouree.add(this.tfTauxMutation);
        boiteEntouree.add(new Label(Langage.getString("nb_mutation"), 2));
        boiteEntouree.add(this.tfNbMutation);
        boiteEntouree.add(new Label(Langage.getString("taux_crossingOver"), 2));
        boiteEntouree.add(this.tfTauxCrossingOver);
        boiteEntouree.add(new Label(Langage.getString("taille_tranche"), 2));
        boiteEntouree.add(this.tfTailleTranche);
        BoiteEntouree boiteEntouree2 = new BoiteEntouree(Langage.getString("titre_boite_enfant"));
        boiteEntouree2.setLayout(new GridLayout(2, 1, 5, 5));
        boiteEntouree2.add(this.cbUnFils);
        boiteEntouree2.add(this.cbDeuxFils);
        BoiteEntouree boiteEntouree3 = new BoiteEntouree(Langage.getString("titre_boite_algo"));
        boiteEntouree3.setLayout(new GridLayout(2, 1, 5, 5));
        boiteEntouree3.add(this.cbCroosEtMute);
        boiteEntouree3.add(this.cbNonCroosEtMute);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1, 5, 5));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 5, 5));
        panel2.add(boiteEntouree2);
        panel2.add(boiteEntouree3);
        panel.add(panel2);
        panel.add(boiteEntouree);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 3, 5, 5));
        panel3.add(this.buttonAnnuler);
        panel3.add(new Label());
        panel3.add(this.buttonOk);
        this.contentPane.add((Component)panel, "Center");
        this.contentPane.add((Component)panel3, "South");
        this.setParametres(this.fenetreMere.getParametres());
        this.pack();
        this.centrer();
        ((Component)this).setVisible(true);
    }

    protected boolean acceptParametres() {
        try {
            int n = Integer.parseInt(this.tfTailleTranche.getText());
            n = Integer.parseInt(this.tfTauxCrossingOver.getText());
            n = Integer.parseInt(this.tfTauxMutation.getText());
            n = Integer.parseInt(this.tfNbMutation.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    protected void actionAnnuler() {
        this.fermerFenetre();
    }

    protected void validerParametres() {
        this.fenetreMere.getParametres().setTailleTrancheCrossingOver(Integer.parseInt(this.tfTailleTranche.getText()));
        this.fenetreMere.getParametres().setTauxCrossingOver(Integer.parseInt(this.tfTauxCrossingOver.getText()));
        this.fenetreMere.getParametres().setTauxMutation(Integer.parseInt(this.tfTauxMutation.getText()));
        this.fenetreMere.getParametres().setNbMutation(Integer.parseInt(this.tfNbMutation.getText()));
        this.fenetreMere.getParametres().setDeuxFils(this.cbDeuxFils.getState());
        this.fenetreMere.getParametres().setCrossEtMute(this.cbCroosEtMute.getState());
    }

    protected void actionOk() {
        if (this.acceptParametres()) {
            this.validerParametres();
            this.fermerFenetre();
        } else {
            FenetreDialog.afficher(this, Langage.getString("erreur"), Langage.getString("format_numerique"), 5);
        }
    }

    protected void setParametres(Parametres parametres) {
        if (parametres != null) {
            this.tfTailleTranche.setText(String.valueOf(parametres.getTailleTrancheCrossingOver()));
            this.tfTauxCrossingOver.setText(String.valueOf(parametres.getTauxCrossingOver()));
            this.tfTauxMutation.setText(String.valueOf(parametres.getTauxMutation()));
            this.tfNbMutation.setText(String.valueOf(parametres.getNbMutation()));
            if (parametres.getDeuxFils()) {
                this.cbDeuxFils.setState(true);
                this.cbUnFils.setState(false);
            } else {
                this.cbUnFils.setState(true);
                this.cbDeuxFils.setState(false);
            }
            if (parametres.getCrossEtMute()) {
                this.cbCroosEtMute.setState(true);
                this.cbNonCroosEtMute.setState(false);
            } else {
                this.cbNonCroosEtMute.setState(true);
                this.cbCroosEtMute.setState(false);
            }
        }
    }
}

