/*
 * Decompiled with CFR 0.152.
 */
package fr.lifl.Aquarium.Ihm;

import fr.lifl.Aquarium.Ihm.ComboNourriture;
import fr.lifl.Aquarium.Ihm.FenetrePrincipale;
import fr.lifl.Aquarium.Ihm.MesIcones;
import fr.lifl.Aquarium.Simulation.GestionSimulation;
import fr.lifl.Aquarium.Simulation.Langage;
import fr.lifl.Aquarium.Simulation.PisteGraphique;
import fr.lifl.Aquarium.Simulation.TableNourriture;
import java.awt.Checkbox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

public class BarreOutilsPrincipale
extends JToolBar {
    protected FenetrePrincipale fenetreMere = null;
    private ComboNourriture cNourriture = null;
    private JComboBox cTaillePinceau = null;
    private JButton boutonInformation = null;
    private JButton boutonParametre = null;
    private JButton boutonPause = null;
    private JButton boutonLancer = null;
    private JButton boutonOuvrir = null;
    private JButton boutonEnregistrer = null;
    private JButton boutonArreter = null;
    private Checkbox chkNourrire = null;
    private JButton boutonAccelerer = null;
    private JComboBox cQuantiteNourriture = null;
    private final int[] quantiteNourriture = new int[]{50, 100, 150, 200, 500, 1000};
    private final int[] valeursPinceaux = new int[]{1, 5, 10, 15, 20, 25};
    private static final int espace = 20;

    public void remplirComboNourriture(TableNourriture tableNourriture) {
        if (tableNourriture != null) {
            this.cNourriture.addTableNourriture(tableNourriture);
        }
    }

    public void pause() {
        if (GestionSimulation.ETAT_COURANT == 1) {
            this.boutonLancer.setEnabled(true);
            this.boutonOuvrir.setEnabled(false);
            this.boutonEnregistrer.setEnabled(true);
            this.boutonLancer.setToolTipText(Langage.getString("continuer"));
            this.boutonAccelerer.setEnabled(false);
            this.boutonPause.setEnabled(false);
            this.boutonArreter.setEnabled(true);
        }
    }

    public void lancer() {
        this.boutonLancer.setEnabled(false);
        this.boutonOuvrir.setEnabled(false);
        this.boutonEnregistrer.setEnabled(false);
        if (GestionSimulation.ETAT_COURANT == 2) {
            this.boutonLancer.setToolTipText(Langage.getString("lancer"));
            this.boutonAccelerer.setEnabled(true);
            this.boutonPause.setEnabled(true);
            this.boutonArreter.setEnabled(true);
        }
        if (GestionSimulation.ETAT_COURANT == 0) {
            this.boutonAccelerer.setEnabled(true);
            this.boutonPause.setEnabled(true);
            this.boutonArreter.setEnabled(true);
        }
        if (GestionSimulation.ETAT_COURANT == 3) {
            this.boutonLancer.setToolTipText(Langage.getString("lancer"));
            this.boutonAccelerer.setEnabled(true);
            this.boutonPause.setEnabled(true);
            this.boutonArreter.setEnabled(true);
        }
    }

    public int getTaillePinceau() {
        int n = -1;
        String string = this.cTaillePinceau.getSelectedItem().toString();
        if (string.startsWith(Langage.getString("uniforme"))) {
            return n;
        }
        try {
            n = Integer.parseInt(string.substring(0, string.length() - 4));
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public int getQuantiteNourriture() {
        int n = 100;
        Object object = this.cQuantiteNourriture.getSelectedItem();
        if (object == null) {
            return n;
        }
        String string = object.toString();
        if (string == null) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public char getNourriture() {
        char c = '*';
        Object object = this.cNourriture.getSelectedItem();
        if (object == null) {
            return c;
        }
        String string = object.toString();
        if (string == null) {
            return c;
        }
        if (string.startsWith(Langage.getString("melange"))) {
            return c;
        }
        return string.charAt(2);
    }

    public void arreter() {
        if (GestionSimulation.ETAT_COURANT == 1 || GestionSimulation.ETAT_COURANT == 2 || GestionSimulation.ETAT_COURANT == 3) {
            this.boutonLancer.setToolTipText(Langage.getString("lancer"));
            this.boutonLancer.setEnabled(true);
            this.boutonOuvrir.setEnabled(true);
            this.boutonEnregistrer.setEnabled(false);
            this.boutonAccelerer.setEnabled(false);
            this.boutonPause.setEnabled(false);
            this.boutonArreter.setEnabled(false);
        }
    }

    public BarreOutilsPrincipale(FenetrePrincipale fenetrePrincipale) {
        this.fenetreMere = fenetrePrincipale;
        this.boutonOuvrir = new JButton(MesIcones.IMG_OUVRIR);
        this.boutonOuvrir.setToolTipText(Langage.getString("charger"));
        this.boutonEnregistrer = new JButton(MesIcones.IMG_SAUVER);
        this.boutonEnregistrer.setToolTipText(Langage.getString("enregistrer"));
        this.boutonLancer = new JButton(MesIcones.IMG_LANCER);
        this.boutonLancer.setToolTipText(Langage.getString("lancer"));
        this.boutonAccelerer = new JButton(MesIcones.IMG_ACCELERER);
        this.boutonAccelerer.setToolTipText(Langage.getString("accelerer"));
        this.boutonPause = new JButton(MesIcones.IMG_PAUSE);
        this.boutonPause.setToolTipText(Langage.getString("pause"));
        this.boutonArreter = new JButton(MesIcones.IMG_ARRETER);
        this.boutonArreter.setToolTipText(Langage.getString("arreter"));
        this.boutonParametre = new JButton(MesIcones.IMG_PARAMETRE);
        this.boutonParametre.setToolTipText(Langage.getString("parametres"));
        this.boutonInformation = new JButton(MesIcones.IMG_AIDE);
        this.boutonInformation.setToolTipText(Langage.getString("information"));
        this.cNourriture = new ComboNourriture(this.fenetreMere.getParametres().getTableNourriture());
        this.cNourriture.setToolTipText(Langage.getString("nourrire_avec"));
        this.cTaillePinceau = new JComboBox();
        this.cTaillePinceau.addItem(Langage.getString("uniforme"));
        int n = 0;
        while (n < this.valeursPinceaux.length) {
            this.cTaillePinceau.addItem(String.valueOf(this.valeursPinceaux[n]) + " pts");
            ++n;
        }
        this.cTaillePinceau.setToolTipText(Langage.getString("pinceau"));
        this.cQuantiteNourriture = new JComboBox();
        n = 0;
        while (n < this.quantiteNourriture.length) {
            this.cQuantiteNourriture.addItem(String.valueOf(this.quantiteNourriture[n]));
            ++n;
        }
        this.cQuantiteNourriture.setToolTipText(Langage.getString("quantite_nourriture"));
        this.cQuantiteNourriture.setSelectedItem("200");
        this.chkNourrire = new Checkbox(Langage.getString("nourrire_automatiquement"), true);
        this.chkNourrire.setBackground(this.getBackground());
        this.chkNourrire.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GestionSimulation.NOURRIRE_MANUELLEMENT = BarreOutilsPrincipale.this.chkNourrire.getState();
            }
        });
        this.boutonOuvrir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionOuvrir();
            }
        });
        this.boutonEnregistrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionEnregistrer();
            }
        });
        this.boutonLancer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionLancer();
            }
        });
        this.boutonAccelerer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionAccelerer();
            }
        });
        this.boutonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionPause();
            }
        });
        this.boutonArreter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionArreter();
            }
        });
        this.boutonParametre.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionParametre();
            }
        });
        this.boutonInformation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionInformation();
            }
        });
        this.cNourriture.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionNourriture();
            }
        });
        this.cTaillePinceau.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionNourriture();
            }
        });
        this.cQuantiteNourriture.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarreOutilsPrincipale.this.actionNourriture();
            }
        });
        this.setFloatable(false);
        this.add(this.boutonOuvrir);
        this.add(this.boutonEnregistrer);
        this.addSeparator();
        this.add(this.boutonLancer);
        this.add(this.boutonAccelerer);
        this.add(this.boutonPause);
        this.add(this.boutonArreter);
        this.addSeparator();
        this.add(this.boutonParametre);
        this.addSeparator();
        this.add(this.boutonInformation);
        this.addSeparator();
        this.add(this.cTaillePinceau);
        this.add(this.cNourriture);
        this.add(this.cQuantiteNourriture);
        this.addSeparator();
        this.add(this.chkNourrire);
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.addSeparator();
        this.boutonAccelerer.setEnabled(false);
        this.boutonPause.setEnabled(false);
        this.boutonArreter.setEnabled(false);
        this.boutonEnregistrer.setEnabled(false);
        this.setPreferredSize(null);
    }

    public void accelerer() {
        if (GestionSimulation.ETAT_COURANT == 1) {
            this.boutonLancer.setEnabled(true);
            this.boutonOuvrir.setEnabled(false);
            this.boutonEnregistrer.setEnabled(false);
            this.boutonLancer.setToolTipText(Langage.getString("vitesse_normal"));
            this.boutonAccelerer.setEnabled(false);
            this.boutonPause.setEnabled(false);
            this.boutonArreter.setEnabled(true);
        }
    }

    protected void actionPause() {
        this.fenetreMere.pause();
    }

    protected void actionParametre() {
        this.fenetreMere.afficheParametre();
    }

    protected void actionOuvrir() {
        this.fenetreMere.charger();
    }

    protected void actionNourriture() {
        PisteGraphique.TAILLE_PINCEAU = this.getTaillePinceau();
        PisteGraphique.TYPE_NOURRITURE = this.getNourriture();
        PisteGraphique.QUANTITE_NOURRITURE = this.getQuantiteNourriture();
    }

    protected void actionLancer() {
        this.fenetreMere.lancer();
    }

    protected void actionEnregistrer() {
        this.fenetreMere.sauver();
    }

    protected void actionArreter() {
        this.fenetreMere.arreter();
    }

    protected void actionAccelerer() {
        this.fenetreMere.accelerer();
    }

    protected void actionInformation() {
        this.fenetreMere.informer();
    }
}

